/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.structure_gel.core.item.building_tool;

import com.legacy.structure_gel.api.registry.SGSimpleRegistry;
import com.legacy.structure_gel.core.SGConfig;
import com.legacy.structure_gel.core.StructureGelMod;
import com.legacy.structure_gel.core.capability.level.BuildingToolPlayerData;
import com.legacy.structure_gel.core.capability.level.BuildingToolWorldData;
import com.legacy.structure_gel.core.item.building_tool.BuildingToolItem;
import com.legacy.structure_gel.core.item.building_tool.BuildingToolMode;
import com.legacy.structure_gel.core.registry.SGRegistry;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.Clearable;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;

public class ActionHistory {
    public static final Codec<ActionHistory> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.fieldOf("player").forGetter(i -> i.player), (App)Action.CODEC.listOf().fieldOf("actions").forGetter(i -> i.actions), (App)ExtraCodecs.f_144628_.fieldOf("last_action").forGetter(i -> i.lastActionIndex), (App)Codec.LONG.optionalFieldOf("last_modified", (Object)0L).forGetter(i -> i.lastModified)).apply((Applicative)instance, ActionHistory::new));
    private String player;
    private final LinkedList<Action> actions;
    private int lastActionIndex;
    private boolean dirty = false;
    private long lastModified = 0L;
    public static final ActionHistory EMPTY = new ActionHistory("EMPTY"){

        @Override
        public void add(Level level, ActionBuilder action) {
        }

        @Override
        public boolean undo(ServerPlayer player) {
            return false;
        }

        @Override
        public boolean redo(ServerPlayer player) {
            return false;
        }

        @Override
        public boolean isEmpty() {
            return true;
        }
    };
    private boolean spamming = false;

    public ActionHistory(String player, List<Action> actions, int lastActionIndex, long lastModified) {
        this.player = player;
        this.actions = new LinkedList<Action>(actions);
        this.lastActionIndex = lastActionIndex;
        this.lastModified = lastModified;
    }

    public ActionHistory(String player) {
        this(player, Collections.emptyList(), 0, 0L);
    }

    public static ActionHistory get(Player player) {
        return ActionHistory.get(player.m_36316_().getName(), player.m_9236_());
    }

    public static ActionHistory get(String playerName, Level level) {
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            return BuildingToolPlayerData.get(serverLevel, playerName).getActionHistory();
        }
        return EMPTY;
    }

    public static Set<String> getHistoryOwners(Level level) {
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            return BuildingToolWorldData.get(serverLevel).getPlayers();
        }
        return Collections.emptySet();
    }

    public static Set<String> getHistoryOwners(MinecraftServer server) {
        HashSet<String> owners = new HashSet<String>();
        server.m_129785_().forEach(level -> owners.addAll(ActionHistory.getHistoryOwners((Level)level)));
        return owners;
    }

    public String getPlayer() {
        return this.player;
    }

    public void add(Level level, ActionBuilder action) {
        long oldModified = this.lastModified;
        this.modified(level);
        long timeSinceLastModification = this.lastModified - oldModified;
        boolean wasSpamming = this.spamming;
        if (timeSinceLastModification > 2L) {
            this.spamming = false;
            while (this.lastActionIndex > 0) {
                this.actions.removeFirst();
                --this.lastActionIndex;
            }
        } else {
            this.spamming = true;
            Action firstAction = this.actions.pollFirst();
            action.insertOld(firstAction);
            if (!wasSpamming) {
                Action secondAction = this.actions.pollFirst();
                action.insertOld(secondAction);
            }
        }
        this.actions.addFirst(action.build());
        while (this.actions.size() > SGConfig.COMMON.getBuildingToolMaxUndos()) {
            this.actions.removeLast();
        }
    }

    public boolean undo(ServerPlayer player) {
        this.modified(player.m_9236_());
        if (this.lastActionIndex < this.actions.size()) {
            if (this.actions.get(this.lastActionIndex).undo(player, player.m_284548_())) {
                ++this.lastActionIndex;
            }
            return true;
        }
        return false;
    }

    public boolean redo(ServerPlayer player) {
        this.modified(player.m_9236_());
        if (this.lastActionIndex > 0) {
            if (this.actions.get(this.lastActionIndex - 1).redo(player, player.m_284548_())) {
                --this.lastActionIndex;
            }
            return true;
        }
        return false;
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public void setDirty(boolean changed) {
        this.dirty = changed;
    }

    public void setModified(long time) {
        this.lastModified = time;
        this.setDirty(true);
    }

    public void modified(Level level) {
        this.lastModified = level.m_46467_();
        this.setModified(this.lastModified);
    }

    public boolean isExpired(Level level) {
        return this.isEmpty() || level.m_46467_() - this.lastModified > SGConfig.COMMON.buildingToolHistoryExpiration();
    }

    public boolean isEmpty() {
        return this.actions.isEmpty();
    }

    public void clear() {
        this.actions.clear();
        this.lastActionIndex = 0;
    }

    public static ActionBuilder newAction() {
        return new ActionBuilder();
    }

    public static void init() {
        Change.init();
    }

    private record Action(Change[] changes) {
        public static final Codec<Action> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Change.CODEC.listOf().fieldOf("changes").xmap(l -> (Change[])l.toArray(Change[]::new), Arrays::asList).forGetter(Action::changes)).apply((Applicative)instance, Action::new));
        private static final String UNDO_KEY = "info.structure_gel.building_tool.message.undo";
        private static final String REDO_KEY = "info.structure_gel.building_tool.message.redo";

        public boolean undo(ServerPlayer player, ServerLevel level) {
            int totalChanges = this.changes.length;
            int changes = 0;
            int lastPercent = 0;
            for (int i = this.changes.length - 1; i > -1; --i) {
                this.changes[i].undo(player, level);
                lastPercent = this.sendMessage(player, UNDO_KEY, lastPercent, ++changes, totalChanges);
            }
            return true;
        }

        public boolean redo(ServerPlayer player, ServerLevel level) {
            int totalChanges = this.changes.length;
            int changes = 0;
            int lastPercent = 0;
            for (Change change : this.changes) {
                change.redo(player, level);
                lastPercent = this.sendMessage(player, REDO_KEY, lastPercent, ++changes, totalChanges);
            }
            return true;
        }

        private int sendMessage(ServerPlayer player, String key, int lastPercent, int changes, int totalChanges) {
            int percent = Math.round((float)changes / (float)totalChanges * 100.0f);
            if (percent - lastPercent >= 1 || percent == 100) {
                player.m_5661_((Component)Component.m_237110_((String)key, (Object[])new Object[]{percent}), true);
            }
            return percent;
        }
    }

    public static class ActionBuilder {
        private final LinkedList<Change> changes = new LinkedList();

        private ActionBuilder() {
        }

        public ActionBuilder insertOld(@Nullable Action action) {
            if (action != null) {
                Change[] changes = action.changes;
                for (int i = changes.length - 1; i > -1; --i) {
                    this.changes.addFirst(changes[i]);
                }
            }
            return this;
        }

        public ActionBuilder changeBlock(BlockPos pos, BlockState oldState, @Nullable CompoundTag oldBlockEntity, BlockState newState, @Nullable CompoundTag newBlockEntity) {
            this.changes.add(new BlockChange(pos, oldState, Optional.ofNullable(oldBlockEntity), newState, Optional.ofNullable(newBlockEntity)));
            return this;
        }

        public ActionBuilder changeSelection(BuildingToolMode mode, int posIndex, BlockPos oldPos, BlockPos newPos) {
            this.changes.add(new SelectionChange(mode, posIndex, oldPos, newPos));
            return this;
        }

        private Action build() {
            return new Action((Change[])this.changes.toArray(Change[]::new));
        }
    }

    private static interface Change {
        public static final SGSimpleRegistry<ResourceLocation, ChangeType> TYPE_REGISTRY = new SGSimpleRegistry(StructureGelMod.locate("world_change_type"), () -> null, null);
        public static final Codec<Change> CODEC = ResourceLocation.f_135803_.xmap(name -> TYPE_REGISTRY.get((ResourceLocation)name), change -> TYPE_REGISTRY.getKey((ChangeType)change)).dispatch(Change::type, ChangeType::codec);

        public static void init() {
            TYPE_REGISTRY.register(StructureGelMod.locate("block_change"), BlockChange.TYPE);
            TYPE_REGISTRY.register(StructureGelMod.locate("selection_change"), SelectionChange.TYPE);
        }

        public void undo(ServerPlayer var1, ServerLevel var2);

        public void redo(ServerPlayer var1, ServerLevel var2);

        public ChangeType type();

        public static interface ChangeType {
            public Codec<? extends Change> codec();
        }
    }

    private record SelectionChange(BuildingToolMode mode, int posIndex, BlockPos oldPos, BlockPos newPos) implements Change
    {
        public static final Codec<SelectionChange> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)BuildingToolMode.CODEC.fieldOf("mode").forGetter(SelectionChange::mode), (App)ExtraCodecs.f_144628_.fieldOf("pos_index").forGetter(SelectionChange::posIndex), (App)BlockPos.f_121852_.fieldOf("old_pos").forGetter(SelectionChange::oldPos), (App)BlockPos.f_121852_.fieldOf("new_pos").forGetter(SelectionChange::newPos)).apply((Applicative)instance, SelectionChange::new));
        public static final Change.ChangeType TYPE = () -> CODEC;

        @Override
        public void undo(ServerPlayer player, ServerLevel level) {
            this.apply(player, this.oldPos);
        }

        @Override
        public void redo(ServerPlayer player, ServerLevel level) {
            this.apply(player, this.newPos);
        }

        private void apply(ServerPlayer player, BlockPos pos) {
            ItemStack buildingTool;
            ItemStack mainItem = player.m_21205_();
            ItemStack offItem = player.m_21206_();
            Object object = mainItem.m_150930_((Item)SGRegistry.Items.BUILDING_TOOL.get()) ? mainItem : (buildingTool = offItem.m_150930_((Item)SGRegistry.Items.BUILDING_TOOL.get()) ? offItem : null);
            if (buildingTool != null && BuildingToolItem.getMode(buildingTool) == this.mode) {
                BuildingToolItem.setPos(buildingTool, this.posIndex, (Vec3i)pos);
            }
        }

        @Override
        public Change.ChangeType type() {
            return TYPE;
        }
    }

    private record BlockChange(BlockPos pos, BlockState oldState, Optional<CompoundTag> oldBlockEntity, BlockState newState, Optional<CompoundTag> newBlockEntity) implements Change
    {
        public static final Codec<BlockChange> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)BlockPos.f_121852_.fieldOf("pos").forGetter(BlockChange::pos), (App)BlockState.f_61039_.fieldOf("old_state").forGetter(BlockChange::oldState), (App)CompoundTag.f_128325_.optionalFieldOf("old_be").forGetter(BlockChange::oldBlockEntity), (App)BlockState.f_61039_.fieldOf("new_state").forGetter(BlockChange::newState), (App)CompoundTag.f_128325_.optionalFieldOf("new_be").forGetter(BlockChange::newBlockEntity)).apply((Applicative)instance, BlockChange::new));
        public static final Change.ChangeType TYPE = () -> CODEC;

        @Override
        public void undo(ServerPlayer player, ServerLevel level) {
            this.apply(level, this.oldState, this.oldBlockEntity);
        }

        @Override
        public void redo(ServerPlayer player, ServerLevel level) {
            this.apply(level, this.newState, this.newBlockEntity);
        }

        private void apply(ServerLevel level, BlockState state, Optional<CompoundTag> blockEntityTag) {
            BlockPos pos = this.pos;
            BlockEntity blockEntity = level.m_7702_(pos);
            if (blockEntity != null) {
                Clearable.m_18908_((Object)blockEntity);
                level.m_7731_(pos, Blocks.f_50016_.m_49966_(), 2);
            }
            int flags = 3;
            if (state.m_61138_((Property)BlockStateProperties.f_61401_) || state.m_61138_((Property)BlockStateProperties.f_61391_)) {
                flags += 16;
            }
            level.m_7731_(pos, state, flags);
            if (blockEntityTag.isPresent()) {
                level.m_7702_(pos).m_142466_(blockEntityTag.get());
            }
        }

        @Override
        public Change.ChangeType type() {
            return TYPE;
        }
    }
}

