/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.structure_gel.core.block;

import com.legacy.structure_gel.core.StructureGelMod;
import com.legacy.structure_gel.core.block_entity.DataHandlerBlockEntity;
import com.legacy.structure_gel.core.util.SGText;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.GameMasterBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class DataHandlerBlock
extends Block
implements SimpleWaterloggedBlock,
EntityBlock,
GameMasterBlock {
    public static final DirectionProperty FACING = BlockStateProperties.f_61372_;
    public static final EnumProperty<Mirror> MIRROR = EnumProperty.m_61587_((String)"mirror", Mirror.class);
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    public static final BooleanProperty CONNECT_TO_BLOCKS = BooleanProperty.m_61465_((String)"connect_to_blocks");

    public DataHandlerBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_(MIRROR, (Comparable)Mirror.NONE)).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)CONNECT_TO_BLOCKS, (Comparable)Boolean.valueOf(true)));
    }

    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new DataHandlerBlockEntity(pos, state);
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof DataHandlerBlockEntity) {
            DataHandlerBlockEntity dataHandler = (DataHandlerBlockEntity)blockEntity;
            if (player.m_36337_()) {
                boolean waterlogged = (Boolean)state.m_61143_((Property)WATERLOGGED);
                Item heldItem = player.m_21205_().m_41720_();
                if (heldItem == Items.f_42447_ && !waterlogged || heldItem == Items.f_42446_ && waterlogged) {
                    return InteractionResult.PASS;
                }
                if (level.f_46443_) {
                    StructureGelMod.proxy.openDataHandlerScreen(dataHandler);
                }
                return InteractionResult.m_19078_((boolean)level.f_46443_);
            }
        }
        return InteractionResult.PASS;
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        FluidState fluidState = context.m_43725_().m_6425_(context.m_8083_());
        return (BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)context.m_7820_().m_122424_())).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidState.m_76152_() == Fluids.f_76193_));
    }

    public void m_6402_(Level level, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        BlockEntity blockEntity;
        if (stack.m_41788_() && (blockEntity = level.m_7702_(pos)) instanceof DataHandlerBlockEntity) {
            DataHandlerBlockEntity dataHandler = (DataHandlerBlockEntity)blockEntity;
            dataHandler.setCustomName(stack.m_41786_());
        }
    }

    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(true) : Fluids.f_76191_.m_76145_();
    }

    public BlockState m_7417_(BlockState state, Direction direction, BlockState neighborState, LevelAccessor level, BlockPos pos, BlockPos neighborPos) {
        if (((Boolean)state.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            level.m_186469_(pos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)level));
        }
        return state;
    }

    public VoxelShape m_7952_(BlockState state, BlockGetter level, BlockPos pos) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) != false ? Shapes.m_83040_() : Shapes.m_83144_();
    }

    public BlockState m_6843_(BlockState state, Rotation rotation) {
        return (BlockState)state.m_61124_((Property)FACING, (Comparable)rotation.m_55954_((Direction)state.m_61143_((Property)FACING)));
    }

    public BlockState m_6943_(BlockState state, Mirror mirror) {
        return (BlockState)this.m_6843_(state, mirror.m_54846_((Direction)state.m_61143_((Property)FACING))).m_61124_(MIRROR, (Comparable)mirror);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{MIRROR, FACING, WATERLOGGED, CONNECT_TO_BLOCKS});
    }

    public void m_5871_(ItemStack stack, BlockGetter level, List<Component> lore, TooltipFlag showAdvanced) {
        if (Screen.m_96638_()) {
            lore.add((Component)Component.m_237115_((String)"info.structure_gel.data_handler_description").m_130940_(ChatFormatting.GRAY));
        } else {
            CompoundTag beTag;
            lore.add(SGText.applyKeybindFilter((Component)Component.m_237115_((String)"info.structure_gel.hold_shift")));
            String beTagKey = "BlockEntityTag";
            CompoundTag tag = stack.m_41783_();
            if (tag != null && tag.m_128425_(beTagKey, 10) && (beTag = tag.m_128469_(beTagKey)).m_128425_("handlers", 9)) {
                lore.add((Component)SGText.NEW_LINE);
                List handlers = DataHandlerBlockEntity.loadAllHandlers(beTag).m_146338_();
                int size = handlers.size();
                for (int i = 0; i < size; ++i) {
                    DataHandlerBlockEntity.RawHandler handler;
                    ResourceLocation type;
                    if (i > 0) {
                        lore.add((Component)SGText.NEW_LINE);
                    }
                    if ((type = (handler = (DataHandlerBlockEntity.RawHandler)handlers.get(i)).typeName()).m_135815_().isEmpty()) continue;
                    lore.add((Component)Component.m_237113_((String)type.toString()).m_130940_(ChatFormatting.GRAY));
                    LinkedHashMap<String, String> dataEntries = handler.dataEntries();
                    if (size > 1) {
                        lore.add((Component)SGText.BULLET_POINT.m_6881_().m_130940_(ChatFormatting.GRAY).m_7220_((Component)Component.m_237115_((String)"info.structure_gel.building_tool.property.weight").m_130948_(SGText.VALUE_LABEL_STYLE)).m_7220_((Component)Component.m_237113_((String)(": " + handler.m_142631_().m_146281_()))));
                    }
                    for (Map.Entry<String, String> entry : dataEntries.entrySet()) {
                        String value;
                        String key = entry.getKey();
                        String translationKey = "gui.structure_gel.data_handler." + type + "." + key + ".label";
                        MutableComponent propertyLabel = Component.m_237115_((String)translationKey);
                        if (propertyLabel.getString().equals(translationKey)) {
                            propertyLabel = Component.m_237113_((String)key);
                        }
                        if ((value = entry.getValue()).isEmpty()) continue;
                        lore.add((Component)SGText.BULLET_POINT.m_6881_().m_130940_(ChatFormatting.GRAY).m_7220_((Component)propertyLabel.m_130948_(SGText.VALUE_LABEL_STYLE)).m_7220_((Component)Component.m_237113_((String)(": " + value))));
                    }
                }
            }
        }
    }
}

