/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.structure_gel.api.structure;

import com.legacy.structure_gel.api.data.tags.SGTags;
import com.legacy.structure_gel.api.registry.RegistryHelper;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.WorldGenRegion;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.chunk.ChunkGeneratorStructureState;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureType;
import net.minecraft.world.level.levelgen.structure.placement.StructurePlacement;

public class StructureAccessHelper {
    private static final Set<ResourceKey<? extends Structure>> LAKE_PROOF = new HashSet<ResourceKey<? extends Structure>>();
    private static final Map<ResourceKey<? extends Structure>, Set<ResourceKey<Level>>> STRUCTURE_DIM_FILTERS = new HashMap<ResourceKey<? extends Structure>, Set<ResourceKey<Level>>>();

    public static boolean isLakeProof(RegistryAccess registryAccess, Structure structure) {
        Registry registry = registryAccess.m_175515_(Registries.f_256944_);
        Optional key = registry.m_7854_((Object)structure);
        if (key.isPresent() && LAKE_PROOF.contains(key.get())) {
            return true;
        }
        return RegistryHelper.isInTag(registry, SGTags.StructureTags.LAKE_PROOF, structure);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setLakeProof(ResourceKey<? extends Structure> structure) {
        Set<ResourceKey<? extends Structure>> set = LAKE_PROOF;
        synchronized (set) {
            LAKE_PROOF.add(structure);
        }
    }

    public static boolean isInStructurePiece(ServerLevelAccessor levelAccessor, Structure structure, BlockPos pos) {
        if (levelAccessor.m_46805_(pos)) {
            StructureManager structureManager;
            if (levelAccessor instanceof ServerLevel) {
                ServerLevel sl = (ServerLevel)levelAccessor;
                structureManager = sl.m_215010_();
            } else if (levelAccessor instanceof WorldGenRegion) {
                WorldGenRegion wg = (WorldGenRegion)levelAccessor;
                structureManager = levelAccessor.m_6018_().m_215010_().m_220468_(wg);
            } else {
                structureManager = null;
            }
            StructureManager structureManager2 = structureManager;
            return structureManager2 != null && structureManager2.m_220524_(pos, structure).m_73603_();
        }
        return false;
    }

    public static boolean isInStructurePiece(ServerLevelAccessor levelAccessor, StructureType<?> type, BlockPos pos) {
        return levelAccessor.m_9598_().m_175515_(Registries.f_256944_).m_123024_().filter(s -> type.equals(s.m_213658_())).anyMatch(s -> StructureAccessHelper.isInStructurePiece(levelAccessor, s, pos));
    }

    public static boolean isInStructure(ServerLevelAccessor levelAccessor, Structure structure, BlockPos pos) {
        if (levelAccessor.m_46805_(pos)) {
            StructureManager structureManager;
            if (levelAccessor instanceof ServerLevel) {
                ServerLevel sl = (ServerLevel)levelAccessor;
                structureManager = sl.m_215010_();
            } else if (levelAccessor instanceof WorldGenRegion) {
                WorldGenRegion wg = (WorldGenRegion)levelAccessor;
                structureManager = levelAccessor.m_6018_().m_215010_().m_220468_(wg);
            } else {
                structureManager = null;
            }
            StructureManager structureManager2 = structureManager;
            return structureManager2 != null && structureManager2.m_220494_(pos, structure).m_73603_();
        }
        return false;
    }

    public static boolean isInStructure(ServerLevelAccessor levelAccessor, StructureType<?> type, BlockPos pos) {
        return levelAccessor.m_9598_().m_175515_(Registries.f_256944_).m_123024_().filter(s -> type.equals(s.m_213658_())).anyMatch(s -> StructureAccessHelper.isInStructure(levelAccessor, s, pos));
    }

    public static boolean hasStructureChunkInRange(ChunkGeneratorStructureState chunkGenStructureState, TagKey<Structure> structureTag, RegistryAccess registryAccess, ChunkPos chunkPos, int radius) {
        return StructureAccessHelper.hasStructureChunkInRange(chunkGenStructureState, (HolderSet<Structure>)registryAccess.m_175515_(Registries.f_256944_).m_203561_(structureTag), chunkPos, radius);
    }

    public static boolean hasStructureChunkInRange(ChunkGeneratorStructureState chunkGenStructureState, HolderSet<Structure> structures, ChunkPos chunkPos, int radius) {
        for (Holder structure : structures) {
            if (!StructureAccessHelper.hasStructureChunkInRange(chunkGenStructureState, (Holder<Structure>)structure, chunkPos, radius)) continue;
            return true;
        }
        return false;
    }

    public static boolean hasStructureChunkInRange(ChunkGeneratorStructureState chunkGenStructureState, Holder<Structure> structure, ChunkPos chunkPos, int radius) {
        int chunkX = chunkPos.f_45578_;
        int chunkZ = chunkPos.f_45579_;
        for (StructurePlacement placement : chunkGenStructureState.m_255260_(structure)) {
            for (int x = chunkX - radius; x <= chunkX + radius; ++x) {
                for (int z = chunkZ - radius; z <= chunkZ + radius; ++z) {
                    if (!placement.m_255071_(chunkGenStructureState, x, z)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public static boolean isValidDimension(Optional<? extends ResourceKey<? extends Structure>> structureKey, ResourceKey<Level> levelKey) {
        if (structureKey.isPresent()) {
            Set<ResourceKey<Level>> dimKeys = STRUCTURE_DIM_FILTERS.get(structureKey.get());
            return dimKeys == null || dimKeys.isEmpty() || dimKeys.contains(levelKey);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addValidDimensions(ResourceKey<? extends Structure> structureKey, Collection<ResourceKey<Level>> levelKeys) {
        Map<ResourceKey<? extends Structure>, Set<ResourceKey<Level>>> map = STRUCTURE_DIM_FILTERS;
        synchronized (map) {
            STRUCTURE_DIM_FILTERS.computeIfAbsent(structureKey, k -> new HashSet()).addAll(levelKeys);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static Set<ResourceKey<Level>> setValidDimensions(ResourceKey<? extends Structure> structureKey, Collection<ResourceKey<Level>> levelKeys) {
        Map<ResourceKey<? extends Structure>, Set<ResourceKey<Level>>> map = STRUCTURE_DIM_FILTERS;
        synchronized (map) {
            return STRUCTURE_DIM_FILTERS.put(structureKey, new HashSet<ResourceKey<Level>>(levelKeys));
        }
    }
}

