/*
 * Decompiled with CFR 0.152.
 */
package codechicken.chunkloader.world;

import codechicken.chunkloader.api.IChunkLoader;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.ChunkPos;
import net.minecraftforge.common.world.ForgeChunkManager;

public class ChunkTicket {
    private final ServerLevel level;
    private final ChunkPos pos;
    private final Set<IChunkLoader> loaders = new HashSet<IChunkLoader>();

    public ChunkTicket(ServerLevel level, ChunkPos pos) {
        this.level = level;
        this.pos = pos;
    }

    public boolean addLoader(IChunkLoader loader) {
        boolean empty = this.loaders.isEmpty();
        if (this.loaders.add(loader)) {
            ForgeChunkManager.forceChunk((ServerLevel)this.level, (String)"chickenchunks", (BlockPos)loader.pos(), (int)this.pos.f_45578_, (int)this.pos.f_45579_, (boolean)true, (boolean)true);
        }
        return empty;
    }

    public boolean remLoader(IChunkLoader loader) {
        if (this.loaders.remove(loader)) {
            ForgeChunkManager.forceChunk((ServerLevel)this.level, (String)"chickenchunks", (BlockPos)loader.pos(), (int)this.pos.f_45578_, (int)this.pos.f_45579_, (boolean)false, (boolean)true);
        }
        return this.loaders.isEmpty();
    }

    public Set<IChunkLoader> getLoaders() {
        return Collections.unmodifiableSet(this.loaders);
    }
}

