/*
 * Decompiled with CFR 0.152.
 */
package codechicken.chunkloader.init;

import codechicken.chunkloader.block.BlockChunkLoader;
import codechicken.chunkloader.block.BlockSpotLoader;
import codechicken.chunkloader.init.ChickenChunksModContent;
import codechicken.lib.datagen.ItemModelProvider;
import codechicken.lib.datagen.LootTableProvider;
import com.google.gson.JsonObject;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import net.covers1624.quack.util.CrashLock;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.client.model.generators.BlockModelBuilder;
import net.minecraftforge.client.model.generators.BlockStateProvider;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.common.data.BlockTagsProvider;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.jetbrains.annotations.Nullable;

public class DataGenerators {
    private static final CrashLock LOCK = new CrashLock("Already initialized.");

    public static void init() {
        LOCK.lock();
        FMLJavaModLoadingContext.get().getModEventBus().addListener(DataGenerators::gatherDataGenerators);
    }

    private static void gatherDataGenerators(GatherDataEvent event) {
        DataGenerator gen = event.getGenerator();
        PackOutput output = gen.getPackOutput();
        ExistingFileHelper files = event.getExistingFileHelper();
        CompletableFuture lookupProvider = event.getLookupProvider();
        gen.addProvider(event.includeServer(), (DataProvider)new LootTables(output));
        gen.addProvider(event.includeServer(), (DataProvider)new BlockTags(output, lookupProvider, files));
        gen.addProvider(event.includeClient(), (DataProvider)new BlockStates(output, files));
        gen.addProvider(event.includeClient(), (DataProvider)new ItemModels(output, files));
    }

    private static class LootTables
    extends LootTableProvider.BlockLootProvider {
        protected LootTables(PackOutput output) {
            super(output, "chickenchunks");
        }

        protected void registerTables() {
            this.register((Block)ChickenChunksModContent.CHUNK_LOADER_BLOCK.get(), new LootPool.Builder[]{this.singleItem((ItemLike)ChickenChunksModContent.CHUNK_LOADER_BLOCK.get())});
            this.register((Block)ChickenChunksModContent.SPOT_LOADER_BLOCK.get(), new LootPool.Builder[]{this.singleItem((ItemLike)ChickenChunksModContent.SPOT_LOADER_BLOCK.get())});
        }
    }

    private static class BlockTags
    extends BlockTagsProvider {
        public BlockTags(PackOutput output, CompletableFuture<HolderLookup.Provider> lookupProvider, @Nullable ExistingFileHelper existingFileHelper) {
            super(output, lookupProvider, "chickenchunks", existingFileHelper);
        }

        protected void m_6577_(HolderLookup.Provider provider) {
            this.m_206424_(net.minecraft.tags.BlockTags.f_144282_).m_255245_((Object)((Block)ChickenChunksModContent.CHUNK_LOADER_BLOCK.get())).m_255245_((Object)((Block)ChickenChunksModContent.SPOT_LOADER_BLOCK.get()));
        }
    }

    private static class BlockStates
    extends BlockStateProvider {
        public BlockStates(PackOutput output, ExistingFileHelper exFileHelper) {
            super(output, "chickenchunks", exFileHelper);
        }

        protected void registerStatesAndModels() {
            this.simpleBlock((Block)ChickenChunksModContent.CHUNK_LOADER_BLOCK.get(), this.chunkLoader("chunk_loader", "full", BlockChunkLoader.SHAPE));
            this.simpleBlock((Block)ChickenChunksModContent.SPOT_LOADER_BLOCK.get(), this.chunkLoader("spot_loader", "spot", BlockSpotLoader.SHAPE));
        }

        private ModelFile chunkLoader(String name, String texturePrefix, VoxelShape shape) {
            AABB box = shape.m_83215_();
            return ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().getBuilder(name)).texture("particle", this.modLoc("block/" + texturePrefix + "/side"))).texture("top", this.modLoc("block/" + texturePrefix + "/top"))).texture("side", this.modLoc("block/" + texturePrefix + "/side"))).texture("bottom", this.modLoc("block/" + texturePrefix + "/bottom"))).element().from((float)box.f_82288_ * 16.0f, (float)box.f_82289_ * 16.0f, (float)box.f_82290_ * 16.0f).to((float)box.f_82291_ * 16.0f, (float)box.f_82292_ * 16.0f, (float)box.f_82293_ * 16.0f).allFaces((dir, builder) -> {
                switch (dir) {
                    case NORTH: 
                    case EAST: 
                    case SOUTH: 
                    case WEST: {
                        builder.texture("#side");
                        break;
                    }
                    case UP: {
                        builder.texture("#top");
                        break;
                    }
                    case DOWN: {
                        builder.texture("#bottom");
                    }
                }
            }).end();
        }
    }

    private static class ItemModels
    extends ItemModelProvider {
        public ItemModels(PackOutput output, ExistingFileHelper existingFileHelper) {
            super(output, "chickenchunks", existingFileHelper);
        }

        protected void registerModels() {
            ((ChunkLoaderItemModelLoaderBuilder)this.generated((ItemLike)ChickenChunksModContent.CHUNK_LOADER_ITEM.get()).noTexture().customLoader(ChunkLoaderItemModelLoaderBuilder::new)).childModel("chickenchunks:block/chunk_loader").spotLoader(false);
            ((ChunkLoaderItemModelLoaderBuilder)this.generated((ItemLike)ChickenChunksModContent.SPOT_LOADER_ITEM.get()).noTexture().customLoader(ChunkLoaderItemModelLoaderBuilder::new)).childModel("chickenchunks:block/spot_loader").spotLoader(true);
        }
    }

    private static class ChunkLoaderItemModelLoaderBuilder
    extends ItemModelProvider.CustomLoaderBuilder {
        @Nullable
        private String childModel;
        private boolean isSpotLoader;

        public ChunkLoaderItemModelLoaderBuilder(ItemModelProvider.SimpleItemModelBuilder parent) {
            super(new ResourceLocation("chickenchunks", "chunk_loader"), parent);
        }

        public ChunkLoaderItemModelLoaderBuilder childModel(String childModel) {
            this.childModel = childModel;
            return this;
        }

        public ChunkLoaderItemModelLoaderBuilder spotLoader(boolean isSpotLoader) {
            this.isSpotLoader = isSpotLoader;
            return this;
        }

        protected JsonObject toJson(JsonObject json) {
            super.toJson(json);
            json.addProperty("childModel", Objects.requireNonNull(this.childModel));
            json.addProperty("isSpotLoader", Boolean.valueOf(this.isSpotLoader));
            return json;
        }
    }
}

