/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.tipsmod.impl;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.google.gson.annotations.Expose;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.Reader;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import net.darkhax.bookshelf.api.Services;
import net.darkhax.bookshelf.api.serialization.Serializers;
import net.darkhax.tipsmod.api.TipsAPI;
import net.darkhax.tipsmod.impl.Constants;
import net.minecraft.network.chat.Component;

public class Config {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().registerTypeAdapter(Component.class, (Object)new ComponentTypeAdapter()).excludeFieldsWithoutExposeAnnotation().create();
    @Expose
    public int defaultCycleTime = 5000;
    @Expose
    public List<String> ignoredNamespaces = new ArrayList<String>();
    @Expose
    public List<String> ignoredTips = new ArrayList<String>();
    @Expose
    public boolean hideUnlocalizedTips = false;
    @Expose
    public float tipRenderWidthPercent = 0.35f;
    @Expose
    public Component defaultTitle = TipsAPI.DEFAULT_TITLE;

    public static Config load() {
        File configFile = Services.PLATFORM.getConfigPath().resolve("tips.json").toFile();
        Config config = new Config();
        if (configFile.exists()) {
            try (FileReader reader = new FileReader(configFile);){
                config = (Config)GSON.fromJson((Reader)reader, Config.class);
                Constants.LOG.info("Loaded config file.");
            }
            catch (Exception e) {
                Constants.LOG.error("Could not read config file {}. Defaults will be used.", (Object)configFile.getAbsolutePath(), (Object)e);
            }
        } else {
            Constants.LOG.info("Creating a new config file at {}.", (Object)configFile.getAbsolutePath());
            configFile.getParentFile().mkdirs();
        }
        try (FileWriter writer = new FileWriter(configFile);){
            GSON.toJson((Object)config, (Appendable)writer);
            Constants.LOG.info("Saved config file.");
        }
        catch (Exception e) {
            Constants.LOG.error("Could not write config file '{}'!", (Object)configFile.getAbsolutePath(), (Object)e);
        }
        return config;
    }

    private static final class ComponentTypeAdapter
    implements JsonSerializer<Component>,
    JsonDeserializer<Component> {
        private ComponentTypeAdapter() {
        }

        public Component deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            return (Component)Serializers.TEXT.fromJSON(json);
        }

        public JsonElement serialize(Component src, Type typeOfSrc, JsonSerializationContext context) {
            return Serializers.TEXT.toJSON((Object)src);
        }
    }
}

