/*
 * Decompiled with CFR 0.152.
 */
package telepathicgrunt.structure_layout_optimizer.utils;

import java.util.ServiceLoader;
import net.minecraft.core.FrontAndTop;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.level.block.JigsawBlock;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;

public final class GeneralUtils {
    private GeneralUtils() {
    }

    public static <T> T loadService(Class<T> service) {
        return ServiceLoader.load(service).findFirst().orElseThrow(() -> new IllegalStateException("No platform implementation found for " + service.getName()));
    }

    public static boolean canJigsawsAttach(StructureTemplate.StructureBlockInfo jigsaw1, StructureTemplate.StructureBlockInfo jigsaw2) {
        FrontAndTop prop1 = (FrontAndTop)jigsaw1.f_74676_().m_61143_((Property)JigsawBlock.f_54222_);
        FrontAndTop prop2 = (FrontAndTop)jigsaw2.f_74676_().m_61143_((Property)JigsawBlock.f_54222_);
        return prop1.m_122625_() == prop2.m_122625_().m_122424_() && (prop1.m_122629_() == prop2.m_122629_() || GeneralUtils.isRollableJoint(jigsaw1, prop1)) && GeneralUtils.getStringMicroOptimised(jigsaw1.f_74677_(), "target").equals(GeneralUtils.getStringMicroOptimised(jigsaw2.f_74677_(), "name"));
    }

    private static boolean isRollableJoint(StructureTemplate.StructureBlockInfo jigsaw1, FrontAndTop prop1) {
        String joint = GeneralUtils.getStringMicroOptimised(jigsaw1.f_74677_(), "joint");
        if (!joint.equals("rollable") && !joint.equals("aligned")) {
            return !prop1.m_122625_().m_122434_().m_122479_();
        }
        return joint.equals("rollable");
    }

    public static String getStringMicroOptimised(CompoundTag tag, String key) {
        String string;
        Tag tag2 = tag.m_128423_(key);
        if (tag2 instanceof StringTag) {
            StringTag stringTag = (StringTag)tag2;
            string = stringTag.m_7916_();
        } else {
            string = "";
        }
        return string;
    }
}

