/*
 * Decompiled with CFR 0.152.
 */
package dev.obscuria.lootjournal.forge;

import dev.obscuria.lootjournal.LootJournal;
import dev.obscuria.lootjournal.ModConfig;
import dev.obscuria.lootjournal.client.DefaultBehavior;
import dev.obscuria.lootjournal.client.render.Anchor;
import dev.obscuria.lootjournal.client.render.Style;
import java.util.List;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.config.ModConfigEvent;
import org.apache.commons.compress.utils.Lists;

public final class ForgeConfig {
    private static final ForgeConfigSpec SPEC;
    private static final ForgeConfigSpec.EnumValue<Style> STYLE;
    private static final ForgeConfigSpec.BooleanValue USE_RARITY_COLOR;
    private static final ForgeConfigSpec.ConfigValue<String> ITEMS_COLOR;
    private static final ForgeConfigSpec.ConfigValue<String> GROUPED_ITEMS_COLOR;
    private static final ForgeConfigSpec.ConfigValue<String> EXPERIENCE_COLOR;
    private static final ForgeConfigSpec.BooleanValue DISPLAY_EXPERIENCE;
    private static final ForgeConfigSpec.BooleanValue DISPLAY_TOTAL;
    private static final ForgeConfigSpec.EnumValue<Anchor> ANCHOR;
    private static final ForgeConfigSpec.IntValue ANCHOR_OFFSET;
    private static final ForgeConfigSpec.IntValue NOTIFICATION_SEPARATION;
    private static final ForgeConfigSpec.IntValue NOTIFICATION_LIFETIME;
    private static final ForgeConfigSpec.IntValue MAX_VISIBLE_NOTIFICATIONS;
    private static final ForgeConfigSpec.IntValue MAX_QUEUED_NOTIFICATIONS;
    private static final ForgeConfigSpec.EnumValue<DefaultBehavior> DEFAULT_BEHAVIOR;
    private static final ForgeConfigSpec.ConfigValue<List<? extends String>> TABS_BLACKLIST;
    private static final ForgeConfigSpec.ConfigValue<List<? extends String>> ITEMS_BLACKLIST;
    private static final ForgeConfigSpec.ConfigValue<List<? extends String>> TABS_WHITELIST;
    private static final ForgeConfigSpec.ConfigValue<List<? extends String>> ITEMS_WHITELIST;

    public static void init(IEventBus eventBus) {
        eventBus.addListener(ForgeConfig::onUpdate);
        ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)SPEC, "obscuria/loot_journal-client.toml");
    }

    public static void onUpdate(ModConfigEvent event) {
        LootJournal.CONFIG.style = (Style)((Object)STYLE.get());
        LootJournal.CONFIG.useRarityColor = (Boolean)USE_RARITY_COLOR.get();
        LootJournal.CONFIG.itemsColor = ModConfig.hexToInt((String)ITEMS_COLOR.get());
        LootJournal.CONFIG.groupedItemsColor = ModConfig.hexToInt((String)GROUPED_ITEMS_COLOR.get());
        LootJournal.CONFIG.experienceColor = ModConfig.hexToInt((String)EXPERIENCE_COLOR.get());
        LootJournal.CONFIG.displayExperience = (Boolean)DISPLAY_EXPERIENCE.get();
        LootJournal.CONFIG.displayTotal = (Boolean)DISPLAY_TOTAL.get();
        LootJournal.CONFIG.anchor = (Anchor)((Object)ANCHOR.get());
        LootJournal.CONFIG.anchorOffset = (Integer)ANCHOR_OFFSET.get();
        LootJournal.CONFIG.notificationSeparation = (Integer)NOTIFICATION_SEPARATION.get();
        LootJournal.CONFIG.notificationLifetime = ((Integer)NOTIFICATION_LIFETIME.get()).intValue();
        LootJournal.CONFIG.maxVisibleNotifications = (Integer)MAX_VISIBLE_NOTIFICATIONS.get();
        LootJournal.CONFIG.maxQueuedNotifications = (Integer)MAX_QUEUED_NOTIFICATIONS.get();
        LootJournal.CONFIG.defaultBehavior = (DefaultBehavior)((Object)DEFAULT_BEHAVIOR.get());
        LootJournal.CONFIG.tabsBlacklist = ModConfig.mapTabs((List)TABS_BLACKLIST.get());
        LootJournal.CONFIG.itemsBlacklist = ModConfig.mapItems((List)ITEMS_BLACKLIST.get());
        LootJournal.CONFIG.tabsWhitelist = ModConfig.mapTabs((List)TABS_WHITELIST.get());
        LootJournal.CONFIG.itemsWhitelist = ModConfig.mapItems((List)ITEMS_WHITELIST.get());
    }

    static {
        ForgeConfigSpec.Builder builder = new ForgeConfigSpec.Builder();
        builder.push("Display");
        STYLE = builder.defineEnum("style", (Enum)ModConfig.STYLE);
        USE_RARITY_COLOR = builder.define("useRarityColor", true);
        ITEMS_COLOR = builder.define("itemsColor", (Object)ModConfig.intToHex(0xFFFFFF));
        GROUPED_ITEMS_COLOR = builder.define("groupedItemsColor", (Object)ModConfig.intToHex(0xFFFFFF));
        EXPERIENCE_COLOR = builder.define("experienceColor", (Object)ModConfig.intToHex(0x55FF55));
        DISPLAY_EXPERIENCE = builder.define("displayExperience", true);
        DISPLAY_TOTAL = builder.define("displayTotal", true);
        builder.pop();
        builder.push("Positioning");
        ANCHOR = builder.defineEnum("anchor", (Enum)ModConfig.ANCHOR);
        ANCHOR_OFFSET = builder.defineInRange("anchorOffset", 3, 0, 256);
        NOTIFICATION_SEPARATION = builder.defineInRange("notificationSeparation", 3, 0, 16);
        NOTIFICATION_LIFETIME = builder.defineInRange("notificationLifetime", 6, 0, 32);
        MAX_VISIBLE_NOTIFICATIONS = builder.defineInRange("maxVisibleNotifications", 12, 1, 64);
        MAX_QUEUED_NOTIFICATIONS = builder.defineInRange("maxQueuedNotifications", 23, 0, 256);
        builder.pop();
        builder.push("Filtering");
        DEFAULT_BEHAVIOR = builder.defineEnum("defaultBehavior", (Enum)ModConfig.DEFAULT_BEHAVIOR);
        TABS_BLACKLIST = builder.defineList("tabsBlacklist", (List)Lists.newArrayList(), it -> it instanceof String);
        ITEMS_BLACKLIST = builder.defineList("itemsBlacklist", (List)Lists.newArrayList(), it -> it instanceof String);
        TABS_WHITELIST = builder.defineList("tabsWhitelist", (List)Lists.newArrayList(), it -> it instanceof String);
        ITEMS_WHITELIST = builder.defineList("itemsWhitelist", (List)Lists.newArrayList(), it -> it instanceof String);
        builder.pop();
        SPEC = builder.build();
    }
}

