/*
 * Decompiled with CFR 0.152.
 */
package dev.obscuria.lootjournal.client.pickup;

import dev.obscuria.lootjournal.LootJournal;
import dev.obscuria.lootjournal.client.pickup.IPickup;
import java.util.List;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.world.item.ItemStack;
import org.apache.commons.compress.utils.Lists;

public final class GroupedItemsPickup
implements IPickup {
    private final List<ItemStack> stacks = Lists.newArrayList();
    private int count;

    public GroupedItemsPickup(ItemStack stack) {
        this.stacks.add(stack);
        this.count = stack.m_41613_();
    }

    @Override
    public void renderIcon(GuiGraphics graphics, long time) {
        if (this.stacks.isEmpty()) {
            return;
        }
        int interval = Math.max(200, 1000 - 50 * this.stacks.size());
        ItemStack stack = this.stacks.get((int)(time / (long)interval % (long)this.stacks.size()));
        graphics.m_280203_(stack, -8, -8);
    }

    @Override
    public boolean tryMerge(IPickup pickup) {
        if (!(pickup instanceof GroupedItemsPickup)) {
            return false;
        }
        GroupedItemsPickup other = (GroupedItemsPickup)pickup;
        this.stacks.addAll(other.stacks);
        this.count += other.count;
        return true;
    }

    @Override
    public MutableComponent getDisplayName() {
        return (this.count <= 1 ? Component.m_237115_((String)"pickup.loot_journal.grouped_items_single") : Component.m_237110_((String)"pickup.loot_journal.grouped_items_multiple", (Object[])new Object[]{this.count})).m_130948_(Style.f_131099_.m_178520_(LootJournal.CONFIG.groupedItemsColor));
    }

    @Override
    public boolean shouldDisplayTotal() {
        return false;
    }

    @Override
    public int getTotal() {
        return 0;
    }
}

