/*
 * Decompiled with CFR 0.152.
 */
package dev.obscuria.lootjournal;

import dev.obscuria.lootjournal.client.DefaultBehavior;
import dev.obscuria.lootjournal.client.render.Anchor;
import dev.obscuria.lootjournal.client.render.Style;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.DefaultedRegistry;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import org.apache.commons.compress.utils.Lists;

public final class ModConfig {
    public static final Style STYLE = Style.CLASSIC;
    public static final boolean USE_RARITY_COLOR = true;
    public static final int ITEMS_COLOR = 0xFFFFFF;
    public static final int GROUPED_ITEMS_COLOR = 0xFFFFFF;
    public static final int EXPERIENCE_COLOR = 0x55FF55;
    public static final boolean DISPLAY_EXPERIENCE = true;
    public static final boolean DISPLAY_TOTAL = true;
    public static final Anchor ANCHOR = Anchor.BOTTOM_RIGHT;
    public static final int ANCHOR_OFFSET = 3;
    public static final int NOTIFICATION_SEPARATION = 3;
    public static final int NOTIFICATION_LIFETIME = 6;
    public static final int MAX_VISIBLE_NOTIFICATIONS = 12;
    public static final int MAX_QUEUED_NOTIFICATIONS = 23;
    public static final DefaultBehavior DEFAULT_BEHAVIOR = DefaultBehavior.ALL_WHITELISTED;
    public Style style = STYLE;
    public boolean useRarityColor = true;
    public int itemsColor = 0xFFFFFF;
    public int groupedItemsColor = 0xFFFFFF;
    public int experienceColor = 0x55FF55;
    public boolean displayExperience = true;
    public boolean displayTotal = true;
    public Anchor anchor = ANCHOR;
    public int anchorOffset = 3;
    public int notificationSeparation = 3;
    public double notificationLifetime = 6.0;
    public int maxVisibleNotifications = 12;
    public int maxQueuedNotifications = 23;
    public DefaultBehavior defaultBehavior = DEFAULT_BEHAVIOR;
    public List<CreativeModeTab> tabsBlacklist = Lists.newArrayList();
    public List<Item> itemsBlacklist = Lists.newArrayList();
    public List<CreativeModeTab> tabsWhitelist = Lists.newArrayList();
    public List<Item> itemsWhitelist = Lists.newArrayList();

    public static String intToHex(int color) {
        return String.format("%06X", 0xFFFFFF & color);
    }

    public static int hexToInt(String color) {
        try {
            return Integer.parseInt(color, 16);
        }
        catch (Exception ignored) {
            return 0xFFFFFF;
        }
    }

    public static List<CreativeModeTab> mapTabs(List<? extends String> values) {
        return values.stream().map(value -> Optional.ofNullable(ResourceLocation.m_135820_((String)value))).map(value -> value.map(arg_0 -> ((Registry)BuiltInRegistries.f_279662_).m_7745_(arg_0))).filter(Optional::isPresent).map(Optional::get).toList();
    }

    public static List<Item> mapItems(List<? extends String> values) {
        return values.stream().map(value -> Optional.ofNullable(ResourceLocation.m_135820_((String)value))).map(value -> value.map(arg_0 -> ((DefaultedRegistry)BuiltInRegistries.f_257033_).m_7745_(arg_0))).filter(Optional::isPresent).map(Optional::get).toList();
    }
}

