/*
 * Decompiled with CFR 0.152.
 */
package org.localmc.tools.ftbqkeys;

import com.google.common.collect.Lists;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.mojang.brigadier.tree.ArgumentCommandNode;
import com.mojang.brigadier.tree.CommandNode;
import com.mojang.brigadier.tree.LiteralCommandNode;
import com.mojang.brigadier.tree.RootCommandNode;
import dev.architectury.event.events.common.CommandRegistrationEvent;
import dev.architectury.platform.Platform;
import dev.ftb.mods.ftbquests.api.FTBQuestsAPI;
import dev.ftb.mods.ftbquests.quest.BaseQuestFile;
import dev.ftb.mods.ftbquests.quest.Chapter;
import dev.ftb.mods.ftbquests.quest.ChapterGroup;
import dev.ftb.mods.ftbquests.quest.Quest;
import dev.ftb.mods.ftbquests.quest.loot.RewardTable;
import dev.ftb.mods.ftbquests.quest.reward.Reward;
import dev.ftb.mods.ftbquests.quest.task.Task;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.StringJoiner;
import java.util.TreeMap;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.client.Minecraft;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.network.chat.Component;
import org.apache.commons.io.FileUtils;
import org.localmc.tools.ftbqkeys.mixin.BaseQuestFileAccessor;
import org.localmc.tools.ftbqkeys.mixin.ChapterImageMixin;

public class FTBQKeysMod {
    public static final String MODID = "ftbqkeys";
    public static final Path gameDir = Platform.getGameFolder();
    public static final Path configDir = Platform.getConfigFolder();
    public static final Gson gson = new GsonBuilder().setPrettyPrinting().create();

    private static List<String> getLocales() {
        return FTBQKeysMod.map(Minecraft.m_91087_().m_91102_().m_264450_().entrySet(), Map.Entry::getKey);
    }

    private static <T, R> List<R> map(Collection<T> list, Function<T, R> function) {
        ArrayList<R> l = new ArrayList<R>(list.size() + 1);
        for (T t : list) {
            l.add(function.apply(t));
        }
        return l;
    }

    public static void saveLang(TreeMap<String, String> transKeys, String lang, File parent) throws IOException {
        File langFile = new File(parent, lang.toLowerCase(Locale.ROOT) + ".json");
        FileUtils.write((File)langFile, (CharSequence)gson.toJson(transKeys), (Charset)StandardCharsets.UTF_8);
    }

    public static void init() {
        CommandRegistrationEvent.EVENT.register((dispatcher, registry, selection) -> {
            RootCommandNode rootCommandNode = dispatcher.getRoot();
            LiteralCommandNode commandNode = ((LiteralArgumentBuilder)Commands.m_82127_((String)"ftbqkey").executes(context -> 0)).build();
            ArgumentCommandNode argumentCommandNode = ((RequiredArgumentBuilder)Commands.m_82129_((String)"lang", (ArgumentType)StringArgumentType.word()).suggests((commandContext, suggestionsBuilder) -> SharedSuggestionProvider.m_82967_((String[])FTBQKeysMod.getLocales().toArray(new String[0]), (SuggestionsBuilder)suggestionsBuilder)).executes(context -> {
                try {
                    int i;
                    File parent = new File(gameDir.toFile(), MODID);
                    File transFiles = new File(parent, "export-lang/");
                    File questsFolder = new File(configDir.toFile(), "ftbquests/");
                    if (questsFolder.exists()) {
                        File backup = new File(parent, "backup/ftbquests");
                        FileUtils.copyDirectory((File)questsFolder, (File)backup);
                    }
                    TreeMap<String, String> transKeys = new TreeMap<String, String>();
                    BaseQuestFile file = FTBQuestsAPI.api().getQuestFile(false);
                    for (i = 0; i < file.getRewardTables().size(); ++i) {
                        RewardTable table = (RewardTable)file.getRewardTables().get(i);
                        transKeys.put("loot_table." + (i + 1), table.getRawTitle());
                        table.getRawTitle().compareTo("{loot_table." + (i + 1) + "}");
                    }
                    for (i = 0; i < ((BaseQuestFileAccessor)file).getChapterGroups().size(); ++i) {
                        ChapterGroup chapterGroup = ((BaseQuestFileAccessor)file).getChapterGroups().get(i);
                        if (chapterGroup.getRawTitle().isBlank()) continue;
                        transKeys.put("category." + (i + 1), chapterGroup.getRawTitle());
                        chapterGroup.getRawTitle().compareTo("{category." + (i + 1) + "}");
                    }
                    for (i = 0; i < file.getAllChapters().size(); ++i) {
                        int i1;
                        Chapter chapter = (Chapter)file.getAllChapters().get(i);
                        String prefix = "chapter." + (i + 1);
                        if (!chapter.getRawTitle().isBlank()) {
                            transKeys.put(prefix + ".title", chapter.getRawTitle());
                            chapter.getRawTitle().compareTo("{" + prefix + ".title}");
                        }
                        if (chapter.getRawSubtitle().size() > 0) {
                            transKeys.put(prefix + ".subtitle", String.join((CharSequence)"\n", chapter.getRawTitle()));
                            chapter.getRawSubtitle().clear();
                            chapter.getRawSubtitle().add("{" + prefix + ".subtitle}");
                        }
                        for (i1 = 0; i1 < chapter.images().toList().size(); ++i1) {
                            List<String> hover = new ChapterImageMixin().getHovers();
                            if (hover.isEmpty()) continue;
                            transKeys.put(prefix + ".image." + (i1 + 1), String.join((CharSequence)"\n", hover));
                            hover.clear();
                            hover.add("{" + prefix + ".image." + (i1 + 1) + "}");
                        }
                        for (i1 = 0; i1 < chapter.getQuests().size(); ++i1) {
                            int i2;
                            Quest quest = (Quest)chapter.getQuests().get(i1);
                            if (!quest.getRawTitle().isBlank()) {
                                transKeys.put(prefix + ".quest." + (i1 + 1) + ".title", quest.getRawTitle());
                                quest.getRawTitle().compareTo("{" + prefix + ".quest." + (i1 + 1) + ".title}");
                            }
                            if (!quest.getRawSubtitle().isBlank()) {
                                transKeys.put(prefix + ".quest." + (i1 + 1) + ".subtitle", quest.getRawTitle());
                                quest.getRawSubtitle().compareTo("{" + prefix + ".quest." + (i1 + 1) + ".subtitle}");
                            }
                            if (quest.getRawDescription().size() > 0) {
                                ArrayList descList = Lists.newArrayList();
                                StringJoiner joiner = new StringJoiner("\n");
                                int num = 1;
                                for (int i22 = 0; i22 < quest.getRawDescription().size(); ++i22) {
                                    String desc = (String)quest.getRawDescription().get(i22);
                                    String regex = "\\{image:.*?}";
                                    if (desc.contains("{image:")) {
                                        if (!joiner.toString().isBlank()) {
                                            transKeys.put(prefix + ".quest." + (i1 + 1) + ".description." + num, joiner.toString());
                                            descList.add("{" + prefix + ".quest." + (i1 + 1) + ".description." + num + "}");
                                            joiner = new StringJoiner("\n");
                                            ++num;
                                        }
                                        Pattern pattern = Pattern.compile("\\{image:.*?}", 8);
                                        Matcher matcher = pattern.matcher(desc);
                                        while (matcher.find()) {
                                            desc = desc.replace(matcher.group(0), "");
                                            descList.add(matcher.group(0));
                                        }
                                        continue;
                                    }
                                    if (desc.isBlank()) {
                                        joiner.add("\n");
                                        continue;
                                    }
                                    joiner.add(desc);
                                }
                                if (!joiner.toString().isBlank()) {
                                    transKeys.put(prefix + ".quest." + (i1 + 1) + ".description." + num, joiner.toString());
                                    descList.add("{" + prefix + ".quest." + (i1 + 1) + ".description." + num + "}");
                                }
                                quest.getRawDescription().clear();
                                quest.getRawDescription().addAll(descList);
                            }
                            for (i2 = 0; i2 < quest.getTasks().size(); ++i2) {
                                Task task = quest.getQuestFile().getTask((long)i2);
                                if (task.getRawTitle().isBlank()) continue;
                                transKeys.put(prefix + ".quest." + (i1 + 1) + ".task." + (i2 + 1) + ".title", task.getRawTitle());
                                task.getRawTitle().compareTo("{" + prefix + ".quest." + (i1 + 1) + ".task." + (i2 + 1) + ".title}");
                            }
                            for (i2 = 0; i2 < quest.getRewards().size(); ++i2) {
                                Reward reward = quest.getQuestFile().getReward((long)i2);
                                if (reward.getRawTitle().isBlank()) continue;
                                transKeys.put(prefix + ".quest." + (i1 + 1) + ".reward." + (i2 + 1) + ".title", reward.getRawTitle());
                                reward.getRawTitle().compareTo("{" + prefix + ".quest." + (i1 + 1) + ".reward." + (i2 + 1) + ".title}");
                            }
                        }
                    }
                    File output = new File(parent, "config/ftbquests");
                    file.writeDataFull(output.toPath());
                    String lang = (String)context.getArgument("lang", String.class);
                    FTBQKeysMod.saveLang(transKeys, lang, transFiles);
                    if (!lang.equalsIgnoreCase("en_us")) {
                        FTBQKeysMod.saveLang(transKeys, "en_us", transFiles);
                    }
                    ((CommandSourceStack)context.getSource()).m_243053_((Component)Component.m_237110_((String)"command.ftbqkeys.message", (Object[])new Object[]{parent.getAbsolutePath()}));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                return 1;
            })).build();
            rootCommandNode.addChild((CommandNode)commandNode);
            commandNode.addChild((CommandNode)argumentCommandNode);
        });
    }
}

