/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.utils;

import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.Difficulty;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.ItemStack;

public class ModFoodData {
    public int foodLevel = 20;
    public float saturationLevel = 5.0f;
    public float exhaustionLevel;
    public int tickTimer;
    public int lastFoodLevel = 20;
    public boolean shouldStarve = false;

    public ModFoodData(boolean shouldStarve) {
        this.shouldStarve = shouldStarve;
    }

    public void eat(int nutrition, float saturation) {
        this.foodLevel = Math.min(nutrition + this.foodLevel, 20);
        this.saturationLevel = Math.min(this.saturationLevel + (float)nutrition * saturation * 2.0f, (float)this.foodLevel);
    }

    public void eat(ItemStack itemStack, @Nullable LivingEntity entity) {
        FoodProperties foodproperties;
        if (itemStack.m_41614_() && (foodproperties = itemStack.getFoodProperties(entity)) != null) {
            this.eat(foodproperties.m_38744_(), foodproperties.m_38745_());
        }
    }

    public void tick(LivingEntity livingEntity) {
        boolean isHurt = livingEntity.m_21223_() > 0.0f && livingEntity.m_21223_() < livingEntity.m_21233_();
        Difficulty difficulty = livingEntity.m_9236_().m_46791_();
        this.lastFoodLevel = this.foodLevel;
        if (this.exhaustionLevel > 4.0f) {
            this.exhaustionLevel -= 4.0f;
            if (this.saturationLevel > 0.0f) {
                this.saturationLevel = Math.max(this.saturationLevel - 1.0f, 0.0f);
            } else if (difficulty != Difficulty.PEACEFUL) {
                this.foodLevel = Math.max(this.foodLevel - 1, 0);
            }
        }
        if (this.saturationLevel > 0.0f && isHurt && this.foodLevel >= 20) {
            ++this.tickTimer;
            if (this.tickTimer >= 10) {
                float f = Math.min(this.saturationLevel, 6.0f);
                livingEntity.m_5634_(f / 6.0f);
                this.addExhaustion(f);
                this.tickTimer = 0;
            }
        } else if (this.foodLevel >= 18 && isHurt) {
            ++this.tickTimer;
            if (this.tickTimer >= 80) {
                livingEntity.m_5634_(1.0f);
                this.addExhaustion(6.0f);
                this.tickTimer = 0;
            }
        } else if (this.foodLevel <= 0 && this.shouldStarve) {
            ++this.tickTimer;
            if (this.tickTimer >= 80) {
                if (livingEntity.m_21223_() > 10.0f || difficulty == Difficulty.HARD || livingEntity.m_21223_() > 1.0f && difficulty == Difficulty.NORMAL) {
                    livingEntity.m_6469_(livingEntity.m_269291_().m_269064_(), 1.0f);
                }
                this.tickTimer = 0;
            }
        } else {
            this.tickTimer = 0;
        }
    }

    public void readAdditionalSaveData(CompoundTag p_38716_) {
        if (p_38716_.m_128425_("foodLevel", 99)) {
            this.foodLevel = p_38716_.m_128451_("foodLevel");
            this.tickTimer = p_38716_.m_128451_("foodTickTimer");
            this.saturationLevel = p_38716_.m_128457_("foodSaturationLevel");
            this.exhaustionLevel = p_38716_.m_128457_("foodExhaustionLevel");
            this.shouldStarve = p_38716_.m_128471_("shouldStarve");
        }
    }

    public void addAdditionalSaveData(CompoundTag p_38720_) {
        p_38720_.m_128405_("foodLevel", this.foodLevel);
        p_38720_.m_128405_("foodTickTimer", this.tickTimer);
        p_38720_.m_128350_("foodSaturationLevel", this.saturationLevel);
        p_38720_.m_128350_("foodExhaustionLevel", this.exhaustionLevel);
        p_38720_.m_128379_("shouldStarve", this.shouldStarve);
    }

    public int getFoodLevel() {
        return this.foodLevel;
    }

    public int getLastFoodLevel() {
        return this.lastFoodLevel;
    }

    public boolean needsFood() {
        return this.foodLevel < 20;
    }

    public void addExhaustion(float p_38704_) {
        this.exhaustionLevel = Math.min(this.exhaustionLevel + p_38704_, 40.0f);
    }

    public float getExhaustionLevel() {
        return this.exhaustionLevel;
    }

    public float getSaturationLevel() {
        return this.saturationLevel;
    }

    public void setFoodLevel(int p_38706_) {
        this.foodLevel = p_38706_;
    }

    public void setSaturation(float p_38718_) {
        this.saturationLevel = p_38718_;
    }

    public void setExhaustion(float p_150379_) {
        this.exhaustionLevel = p_150379_;
    }

    public boolean isShouldStarve() {
        return this.shouldStarve;
    }

    public void setShouldStarve(boolean shouldStarve) {
        this.shouldStarve = shouldStarve;
    }
}

