/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.utils;

import com.Polarice3.Goety.common.effects.GoetyEffects;
import com.Polarice3.Goety.common.items.ModItems;
import com.Polarice3.Goety.common.items.ModTiers;
import com.Polarice3.Goety.common.items.equipment.PhilosophersMaceItem;
import com.Polarice3.Goety.config.ItemConfig;
import com.Polarice3.Goety.utils.MathHelper;
import com.Polarice3.Goety.utils.SEHelper;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.BannerItem;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TieredItem;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BannerPattern;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class ItemHelper {
    public static <T extends LivingEntity> void hurtAndRemove(ItemStack stack, int pAmount, T pEntity) {
        if (!(pEntity.f_19853_.f_46443_ || pEntity instanceof Player && ((Player)pEntity).m_150110_().f_35937_ || !stack.m_41763_() || !stack.m_220157_(pAmount, pEntity.m_217043_(), pEntity instanceof ServerPlayer ? (ServerPlayer)pEntity : null))) {
            stack.m_41774_(1);
            stack.m_41721_(0);
        }
    }

    public static <T extends LivingEntity> void hurtAndBreak(ItemStack itemStack, int pAmount, T pEntity) {
        itemStack.m_41622_(pAmount, pEntity, p_220045_0_ -> p_220045_0_.m_21166_(EquipmentSlot.MAINHAND));
    }

    public static void hurtNoEntity(ItemStack itemStack, int pAmount, Level level) {
        if (!level.f_46443_ && itemStack.m_41763_() && itemStack.m_220157_(pAmount, level.m_213780_(), null)) {
            itemStack.m_41774_(1);
            itemStack.m_41721_(0);
        }
    }

    public static ItemEntity itemEntityDrop(LivingEntity livingEntity, ItemStack itemStack) {
        return new ItemEntity(livingEntity.f_19853_, livingEntity.m_20185_(), livingEntity.m_20186_(), livingEntity.m_20189_(), itemStack);
    }

    public static void addItemEntity(Level level, BlockPos blockPos, ItemStack itemStack) {
        double d0 = (double)(level.f_46441_.m_188501_() * 0.5f) + 0.25;
        double d1 = (double)(level.f_46441_.m_188501_() * 0.5f) + 0.25;
        double d2 = (double)(level.f_46441_.m_188501_() * 0.5f) + 0.25;
        ItemEntity itementity = new ItemEntity(level, (double)blockPos.m_123341_() + d0, (double)blockPos.m_123342_() + d1, (double)blockPos.m_123343_() + d2, itemStack);
        itementity.m_32060_();
        level.m_7967_((Entity)itementity);
    }

    public static void addAndConsumeItem(Player player, InteractionHand hand, ItemStack toAdd) {
        ItemHelper.addAndConsumeItem(player, hand, toAdd, true);
    }

    public static void addAndConsumeItem(Player player, InteractionHand hand, ItemStack toAdd, boolean addToInventory) {
        ItemStack stack = player.m_21120_(hand);
        if (stack.m_41613_() == 1) {
            if (!player.m_7500_()) {
                player.m_21008_(hand, toAdd);
            } else if (addToInventory && !player.m_150109_().m_36054_(toAdd)) {
                player.m_7197_(toAdd, false, true);
            }
        } else {
            if (!player.m_7500_()) {
                stack.m_41774_(1);
            }
            if (!player.m_150109_().m_36054_(toAdd)) {
                player.m_7197_(toAdd, false, true);
            }
        }
    }

    public static boolean hasItem(Player player, Item item) {
        return !ItemHelper.findItem(player, item).m_41619_();
    }

    public static ItemStack findItem(Player playerEntity, Item item) {
        ItemStack foundStack = ItemStack.f_41583_;
        for (int i = 0; i < playerEntity.m_150109_().m_6643_(); ++i) {
            ItemStack itemStack = playerEntity.m_150109_().m_8020_(i);
            if (itemStack.m_41619_() || itemStack.m_41720_() != item) continue;
            foundStack = itemStack;
            break;
        }
        return foundStack;
    }

    public static ItemStack findItem(Player playerEntity, Predicate<ItemStack> item) {
        ItemStack foundStack = ItemStack.f_41583_;
        for (int i = 0; i < playerEntity.m_150109_().m_6643_(); ++i) {
            ItemStack itemStack = playerEntity.m_150109_().m_8020_(i);
            if (itemStack.m_41619_() || !item.test(itemStack)) continue;
            foundStack = itemStack;
            break;
        }
        return foundStack;
    }

    public static boolean findHelmet(Player player, Item item) {
        return player.m_6844_(EquipmentSlot.HEAD).m_41720_() == item;
    }

    public static boolean armorSet(LivingEntity living, ArmorMaterial material) {
        ArmorItem helmet;
        int i = 0;
        EquipmentSlot[] equipmentSlotArray = living.m_6844_(EquipmentSlot.HEAD).m_41720_();
        if (equipmentSlotArray instanceof ArmorItem && (helmet = (ArmorItem)equipmentSlotArray).m_40401_() == material) {
            for (EquipmentSlot equipmentSlot : EquipmentSlot.values()) {
                ArmorItem armorItem;
                Item item;
                if (equipmentSlot.m_20743_() != EquipmentSlot.Type.ARMOR || !((item = living.m_6844_(equipmentSlot).m_41720_()) instanceof ArmorItem) || (armorItem = (ArmorItem)item).m_40401_() != material) continue;
                ++i;
            }
        }
        return i >= 4;
    }

    public static boolean isFullEquipped(LivingEntity living) {
        int i = 0;
        for (EquipmentSlot equipmentSlot : EquipmentSlot.values()) {
            if (equipmentSlot.m_20743_() != EquipmentSlot.Type.ARMOR || living.m_6844_(equipmentSlot).m_41619_()) continue;
            ++i;
        }
        return i >= 4;
    }

    public static boolean isFullArmored(LivingEntity living) {
        int i = 0;
        for (EquipmentSlot equipmentSlot : EquipmentSlot.values()) {
            if (equipmentSlot.m_20743_() != EquipmentSlot.Type.ARMOR || !(living.m_6844_(equipmentSlot).m_41720_() instanceof ArmorItem)) continue;
            ++i;
        }
        return i >= 4;
    }

    public static boolean noArmor(LivingEntity living) {
        int i = 0;
        for (EquipmentSlot equipmentSlot : EquipmentSlot.values()) {
            if (equipmentSlot.m_20743_() != EquipmentSlot.Type.ARMOR || !living.m_6844_(equipmentSlot).m_41619_()) continue;
            ++i;
        }
        return i >= 4;
    }

    public static void repairTick(ItemStack stack, Entity entityIn, boolean isSelected) {
        if (((Boolean)ItemConfig.SoulRepair.get()).booleanValue() && entityIn instanceof Player) {
            Player player = (Player)entityIn;
            if ((!player.f_20911_ || !isSelected) && stack.m_41768_() && SEHelper.getSoulsContainer(player)) {
                int i = 1;
                if (!stack.getAllEnchantments().isEmpty() && ((Boolean)ItemConfig.SoulRepairEnchant.get()).booleanValue()) {
                    i += stack.getAllEnchantments().size();
                }
                if (SEHelper.getSoulsAmount(player, (Integer)ItemConfig.ItemsRepairAmount.get() * i) && player.f_19797_ % 20 == 0) {
                    stack.m_41721_(stack.m_41773_() - 1);
                    SEHelper.decreaseSouls(player, (Integer)ItemConfig.ItemsRepairAmount.get() * i);
                }
            }
        }
    }

    public static boolean isValidFluidContainerToDrain(ItemStack stack, Fluid fluid) {
        if (stack.m_41619_() || stack.m_41613_() != 1) {
            return false;
        }
        return stack.getCapability(ForgeCapabilities.FLUID_HANDLER_ITEM).map(handler -> {
            FluidStack simulate = handler.drain(new FluidStack(fluid, 1000), IFluidHandler.FluidAction.SIMULATE);
            return !simulate.isEmpty() && simulate.getFluid() == fluid && simulate.getAmount() == 1000;
        }).orElse(false);
    }

    public static ItemStack drain(Fluid fluid, ItemStack stack) {
        return stack.getCapability(ForgeCapabilities.FLUID_HANDLER_ITEM).map(handler -> {
            handler.drain(new FluidStack(fluid, 1000), IFluidHandler.FluidAction.EXECUTE);
            return handler.getContainer();
        }).orElse(stack);
    }

    public static boolean isValidFluidContainerToFill(ItemStack stack, Fluid fluid) {
        if (stack.m_41619_()) {
            return false;
        }
        ItemStack container = stack;
        if (stack.m_41613_() > 1) {
            container = new ItemStack((ItemLike)stack.m_41720_());
        }
        return container.getCapability(ForgeCapabilities.FLUID_HANDLER_ITEM).map(handler -> {
            int amount = handler.fill(new FluidStack(fluid, 1000), IFluidHandler.FluidAction.SIMULATE);
            return amount == 1000;
        }).orElse(false);
    }

    public static ItemStack fill(Fluid fluid, ItemStack stack) {
        return stack.getCapability(ForgeCapabilities.FLUID_HANDLER_ITEM).map(handler -> {
            handler.fill(new FluidStack(fluid, 1000), IFluidHandler.FluidAction.EXECUTE);
            return handler.getContainer();
        }).orElse(stack);
    }

    public static void setItemEffect(ItemStack stack, LivingEntity victim) {
        Item item = stack.m_41720_();
        if (item instanceof TieredItem) {
            TieredItem weapon = (TieredItem)item;
            if (weapon.m_43314_() == ModTiers.DARK) {
                victim.m_7292_(new MobEffectInstance((MobEffect)GoetyEffects.WANE.get(), 60));
            }
            if (weapon == ModItems.FELL_BLADE.get() && victim.m_217043_().m_188499_()) {
                victim.m_7292_(new MobEffectInstance((MobEffect)GoetyEffects.BUSTED.get(), MathHelper.secondsToTicks(5)));
            }
            if (weapon == ModItems.FROZEN_BLADE.get()) {
                victim.m_7292_(new MobEffectInstance((MobEffect)GoetyEffects.FREEZING.get(), MathHelper.secondsToTicks(2)));
            }
        } else if (stack.m_41720_() instanceof PhilosophersMaceItem) {
            int i2 = EnchantmentHelper.getTagEnchantmentLevel((Enchantment)Enchantments.f_44982_, (ItemStack)stack);
            victim.m_7292_(new MobEffectInstance((MobEffect)GoetyEffects.GOLD_TOUCHED.get(), 300, i2));
        }
    }

    public static Component getShiftInfoTooltip() {
        MutableComponent shift = Component.m_237113_((String)"SHIFT").m_130940_(ChatFormatting.AQUA);
        return Component.m_237110_((String)"info.goety.item_info", (Object[])new Object[]{shift}).m_130940_(ChatFormatting.GRAY);
    }

    public static void addOnShift(List<Component> tooltip, Runnable lambda) {
        if (Screen.m_96638_()) {
            lambda.run();
        } else {
            tooltip.add(ItemHelper.getShiftInfoTooltip());
        }
    }

    public static boolean sameBanner(ItemStack banner1, ItemStack banner2) {
        if (banner1.m_41720_() instanceof BannerItem && banner2.m_41720_() instanceof BannerItem) {
            CompoundTag compoundtag1 = BlockItem.m_186336_((ItemStack)banner1);
            CompoundTag compoundtag2 = BlockItem.m_186336_((ItemStack)banner2);
            if (compoundtag1 != null && compoundtag2 != null && compoundtag1.m_128441_("Patterns") && compoundtag2.m_128441_("Patterns")) {
                ListTag listtag1 = compoundtag1.m_128437_("Patterns", 10);
                ListTag listtag2 = compoundtag2.m_128437_("Patterns", 10);
                if (listtag1.size() == listtag2.size()) {
                    int i = 0;
                    for (int j = 0; j < listtag1.size(); ++j) {
                        CompoundTag compoundtag3 = listtag1.m_128728_(i);
                        CompoundTag compoundtag4 = listtag2.m_128728_(i);
                        Holder holder1 = BannerPattern.m_222700_((String)compoundtag3.m_128461_("Pattern"));
                        Holder holder2 = BannerPattern.m_222700_((String)compoundtag4.m_128461_("Pattern"));
                        if (holder1 == null || holder2 == null || !((BannerPattern)holder1.get()).m_58579_().equals(((BannerPattern)holder2.get()).m_58579_())) continue;
                        ++i;
                    }
                    return i == listtag1.size();
                }
            }
        }
        return false;
    }

    public static int repairPlayerItems(Player p_147093_, int experience) {
        Map.Entry entry = EnchantmentHelper.m_44839_((Enchantment)Enchantments.f_44962_, (LivingEntity)p_147093_, ItemStack::m_41768_);
        if (entry != null) {
            ItemStack itemstack = (ItemStack)entry.getValue();
            int i = Math.min((int)((float)experience * itemstack.getXpRepairRatio()), itemstack.m_41773_());
            itemstack.m_41721_(itemstack.m_41773_() - i);
            int j = experience - ItemHelper.durabilityToXp(i);
            return j > 0 ? ItemHelper.repairPlayerItems(p_147093_, j) : 0;
        }
        return experience;
    }

    private static int durabilityToXp(int p_20794_) {
        return p_20794_ / 2;
    }

    public static InteractionResultHolder<ItemStack> getVoidBottle(Player player, Level world, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (stack.m_41619_() || !stack.m_150930_(Items.f_42590_)) {
            return InteractionResultHolder.m_19098_((Object)stack);
        }
        BlockHitResult result = ItemHelper.getPlayerPOVHitResult(world, player, ClipContext.Fluid.ANY);
        if (result.m_82450_().f_82480_ <= (double)world.m_141937_()) {
            if (!world.f_46443_) {
                ItemStack enderAir = new ItemStack((ItemLike)ModItems.VOID_BOTTLE.get());
                player.m_150109_().m_150079_(enderAir);
                stack.m_41774_(1);
                world.m_5594_(null, player.m_20183_(), SoundEvents.f_12019_, SoundSource.NEUTRAL, 0.5f, 1.0f);
                world.m_220400_((Entity)player, GameEvent.f_157816_, player.m_20182_());
            }
            return InteractionResultHolder.m_19092_((Object)stack, (boolean)world.m_5776_());
        }
        return InteractionResultHolder.m_19098_((Object)stack);
    }

    protected static BlockHitResult getPlayerPOVHitResult(Level p_41436_, Player p_41437_, ClipContext.Fluid p_41438_) {
        float f = p_41437_.m_146909_();
        float f1 = p_41437_.m_146908_();
        Vec3 vec3 = p_41437_.m_146892_();
        float f2 = Mth.m_14089_((float)(-f1 * ((float)Math.PI / 180) - (float)Math.PI));
        float f3 = Mth.m_14031_((float)(-f1 * ((float)Math.PI / 180) - (float)Math.PI));
        float f4 = -Mth.m_14089_((float)(-f * ((float)Math.PI / 180)));
        float f5 = Mth.m_14031_((float)(-f * ((float)Math.PI / 180)));
        float f6 = f3 * f4;
        float f7 = f2 * f4;
        double d0 = p_41437_.getBlockReach();
        Vec3 vec31 = vec3.m_82520_((double)f6 * d0, (double)f5 * d0, (double)f7 * d0);
        return p_41436_.m_45547_(new ClipContext(vec3, vec31, ClipContext.Block.OUTLINE, p_41438_, (Entity)p_41437_));
    }
}

