/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.utils;

import com.Polarice3.Goety.api.entities.IOwned;
import com.Polarice3.Goety.api.magic.SpellType;
import com.Polarice3.Goety.common.enchantments.ModEnchantments;
import com.Polarice3.Goety.common.entities.boss.Apostle;
import com.Polarice3.Goety.common.entities.neutral.AbstractNecromancer;
import com.Polarice3.Goety.common.entities.neutral.ender.AbstractEnderling;
import com.Polarice3.Goety.common.items.ModItems;
import com.Polarice3.Goety.common.items.brew.ThrowableBrewItem;
import com.Polarice3.Goety.common.items.curios.AbyssRobeItem;
import com.Polarice3.Goety.common.items.curios.FrostRobeItem;
import com.Polarice3.Goety.common.items.curios.IllusionRobeItem;
import com.Polarice3.Goety.common.items.curios.MagicCrownItem;
import com.Polarice3.Goety.common.items.curios.MagicHatItem;
import com.Polarice3.Goety.common.items.curios.MagicRobeItem;
import com.Polarice3.Goety.common.items.curios.NecroGarbs;
import com.Polarice3.Goety.common.items.curios.NetherRobeItem;
import com.Polarice3.Goety.common.items.curios.RingItem;
import com.Polarice3.Goety.common.items.curios.UnholyHatItem;
import com.Polarice3.Goety.common.items.curios.UnholyRobeItem;
import com.Polarice3.Goety.common.items.curios.VoidRobeItem;
import com.Polarice3.Goety.common.items.curios.WarlockRobeItem;
import com.Polarice3.Goety.common.items.curios.WildRobeItem;
import com.Polarice3.Goety.common.items.curios.WindyRobeItem;
import com.Polarice3.Goety.common.items.curios.WitchHatItem;
import com.Polarice3.Goety.common.items.curios.WitchRobeItem;
import com.Polarice3.Goety.common.items.handler.BrewBagItemHandler;
import com.Polarice3.Goety.compat.curios.CuriosLoaded;
import com.Polarice3.Goety.config.ItemConfig;
import com.Polarice3.Goety.init.ModMobType;
import com.Polarice3.Goety.init.ModTags;
import com.Polarice3.Goety.utils.MobUtil;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.monster.Blaze;
import net.minecraft.world.entity.monster.EnderMan;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.monster.Ghast;
import net.minecraft.world.entity.monster.MagmaCube;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.SlotResult;

public class CuriosFinder {
    public static ItemStack findCurio(LivingEntity livingEntity, Predicate<ItemStack> filter) {
        Optional slotResult;
        ItemStack foundStack = ItemStack.f_41583_;
        if (livingEntity != null && CuriosLoaded.CURIOS.isLoaded() && (slotResult = CuriosApi.getCuriosInventory((LivingEntity)livingEntity).map(inv -> inv.findFirstCurio(filter)).orElse(Optional.empty())).isPresent()) {
            foundStack = ((SlotResult)slotResult.get()).stack();
        }
        return foundStack;
    }

    public static boolean hasCurio(LivingEntity livingEntity, Predicate<ItemStack> filter) {
        return !CuriosFinder.findCurio(livingEntity, filter).m_41619_();
    }

    public static boolean hasCurio(LivingEntity livingEntity, Item item) {
        return !CuriosFinder.findCurio(livingEntity, item).m_41619_();
    }

    public static ItemStack findCurio(LivingEntity livingEntity, Item item) {
        Optional slotResult;
        ItemStack foundStack = ItemStack.f_41583_;
        if (livingEntity != null && CuriosLoaded.CURIOS.isLoaded() && (slotResult = CuriosApi.getCuriosInventory((LivingEntity)livingEntity).map(inv -> inv.findFirstCurio(item)).orElse(Optional.empty())).isPresent()) {
            foundStack = ((SlotResult)slotResult.get()).stack();
        }
        return foundStack;
    }

    public static boolean noHeadWear(LivingEntity livingEntity) {
        if (livingEntity != null && CuriosLoaded.CURIOS.isLoaded()) {
            return CuriosApi.getCuriosInventory((LivingEntity)livingEntity).map(inv -> inv.findCurios(new String[]{"head"}).isEmpty()).orElse(false);
        }
        return true;
    }

    public static boolean hasWanting(Entity entity) {
        Player player = null;
        if (entity instanceof Player) {
            Player player1;
            player = player1 = (Player)entity;
        } else {
            LivingEntity livingEntity = MobUtil.getOwner(entity);
            if (livingEntity instanceof Player) {
                Player player1;
                player = player1 = (Player)livingEntity;
            }
        }
        if (player != null && CuriosFinder.findRing(player).m_41720_() == ModItems.RING_OF_WANT.get() && CuriosFinder.findRing(player).m_41793_()) {
            float wanting = EnchantmentHelper.getTagEnchantmentLevel((Enchantment)((Enchantment)ModEnchantments.WANTING.get()), (ItemStack)CuriosFinder.findRing(player));
            return wanting > 0.0f;
        }
        return false;
    }

    public static boolean hasMagicHat(LivingEntity livingEntity) {
        return CuriosFinder.hasCurio(livingEntity, (ItemStack itemStack) -> itemStack.m_41720_() instanceof MagicHatItem);
    }

    public static boolean hasDarkRobe(LivingEntity livingEntity) {
        return CuriosFinder.hasCurio(livingEntity, (ItemStack itemStack) -> itemStack.m_41720_() instanceof MagicRobeItem);
    }

    public static boolean hasWildRobe(LivingEntity livingEntity) {
        return CuriosFinder.hasCurio(livingEntity, (ItemStack itemStack) -> itemStack.m_41720_() instanceof WildRobeItem);
    }

    public static boolean hasWildCrown(LivingEntity livingEntity) {
        return CuriosFinder.hasCurio(livingEntity, (ItemStack item) -> {
            Item patt4687$temp = item.m_41720_();
            if (!(patt4687$temp instanceof MagicCrownItem)) return false;
            MagicCrownItem crownItem = (MagicCrownItem)patt4687$temp;
            if (crownItem.spellType != SpellType.WILD) return false;
            return true;
        });
    }

    public static boolean hasWildSet(LivingEntity livingEntity) {
        return CuriosFinder.hasWildRobe(livingEntity) && CuriosFinder.hasWildCrown(livingEntity);
    }

    public static boolean neutralWildSet(LivingEntity livingEntity) {
        return CuriosFinder.hasWildSet(livingEntity) && (Boolean)ItemConfig.WildSetMobNeutral.get() != false;
    }

    public static boolean validWildMob(LivingEntity livingEntity) {
        return !(livingEntity.m_6336_() != ModMobType.NATURAL && livingEntity.m_6336_() != MobType.f_21642_ && !(livingEntity instanceof Animal) && !livingEntity.m_6095_().m_204039_(ModTags.EntityTypes.WILD_SET_NEUTRAL) || !((double)livingEntity.m_21233_() <= (Double)ItemConfig.WildSetMobNeutralHealth.get()) || livingEntity instanceof IOwned && !(livingEntity instanceof Enemy));
    }

    public static boolean hasVoidRobe(LivingEntity livingEntity) {
        return CuriosFinder.hasCurio(livingEntity, (ItemStack itemStack) -> itemStack.m_41720_() instanceof VoidRobeItem);
    }

    public static boolean hasVoidCrown(LivingEntity livingEntity) {
        return CuriosFinder.hasCurio(livingEntity, (ItemStack item) -> {
            Item patt5933$temp = item.m_41720_();
            if (!(patt5933$temp instanceof MagicCrownItem)) return false;
            MagicCrownItem crownItem = (MagicCrownItem)patt5933$temp;
            if (crownItem.spellType != SpellType.VOID) return false;
            return true;
        });
    }

    public static boolean hasVoidSet(LivingEntity livingEntity) {
        return CuriosFinder.hasVoidRobe(livingEntity) && CuriosFinder.hasVoidCrown(livingEntity);
    }

    public static boolean neutralVoidSet(LivingEntity livingEntity) {
        return CuriosFinder.hasVoidSet(livingEntity) && (Boolean)ItemConfig.VoidSetMobNeutral.get() != false;
    }

    public static boolean validVoidMob(LivingEntity livingEntity) {
        return !(!(livingEntity instanceof AbstractEnderling) && !(livingEntity instanceof EnderMan) && !livingEntity.m_6095_().m_204039_(ModTags.EntityTypes.VOID_SET_NEUTRAL) || !((double)livingEntity.m_21233_() <= (Double)ItemConfig.VoidSetMobNeutralHealth.get()) || livingEntity instanceof IOwned && !(livingEntity instanceof Enemy));
    }

    public static boolean hasIllusionRobe(LivingEntity livingEntity) {
        return CuriosFinder.hasCurio(livingEntity, (ItemStack itemStack) -> itemStack.m_41720_() instanceof IllusionRobeItem);
    }

    public static boolean hasWitchHat(LivingEntity livingEntity) {
        return CuriosFinder.hasCurio(livingEntity, (ItemStack itemStack) -> itemStack.m_41720_() instanceof WitchHatItem);
    }

    public static boolean hasWitchRobe(LivingEntity livingEntity) {
        return CuriosFinder.hasCurio(livingEntity, (ItemStack itemStack) -> itemStack.m_41720_() instanceof WitchRobeItem);
    }

    public static boolean hasWarlockRobe(LivingEntity livingEntity) {
        return CuriosFinder.hasCurio(livingEntity, (ItemStack itemStack) -> itemStack.m_41720_() instanceof WarlockRobeItem);
    }

    public static boolean hasNetherRobe(LivingEntity livingEntity) {
        return CuriosFinder.hasCurio(livingEntity, (ItemStack itemStack) -> itemStack.m_41720_() instanceof NetherRobeItem) || CuriosFinder.hasUnholyRobe(livingEntity);
    }

    public static boolean hasNetherCrown(LivingEntity livingEntity) {
        return CuriosFinder.hasCurio(livingEntity, (ItemStack item) -> {
            Item patt7876$temp = item.m_41720_();
            if (!(patt7876$temp instanceof MagicCrownItem)) return false;
            MagicCrownItem crownItem = (MagicCrownItem)patt7876$temp;
            if (crownItem.spellType != SpellType.NETHER) return false;
            return true;
        });
    }

    public static boolean hasNetherSet(LivingEntity livingEntity) {
        return CuriosFinder.hasNetherRobe(livingEntity) && CuriosFinder.hasNetherCrown(livingEntity);
    }

    public static boolean neutralNetherSet(LivingEntity livingEntity) {
        return CuriosFinder.hasNetherSet(livingEntity) && (Boolean)ItemConfig.NetherSetMobNeutral.get() != false;
    }

    public static boolean validNetherMob(LivingEntity livingEntity) {
        return !(livingEntity.m_6336_() != ModMobType.NETHER && !(livingEntity instanceof Blaze) && !(livingEntity instanceof Ghast) && !(livingEntity instanceof MagmaCube) && !livingEntity.m_6095_().m_204039_(ModTags.EntityTypes.NETHER_SET_NEUTRAL) || !((double)livingEntity.m_21233_() <= (Double)ItemConfig.NetherSetMobNeutralHealth.get()) || livingEntity instanceof IOwned && !(livingEntity instanceof Enemy));
    }

    public static boolean hasUnholyRobe(LivingEntity livingEntity) {
        return CuriosFinder.hasCurio(livingEntity, (ItemStack itemStack) -> itemStack.m_41720_() instanceof UnholyRobeItem);
    }

    public static boolean hasUnholyHat(LivingEntity livingEntity) {
        return CuriosFinder.hasCurio(livingEntity, (ItemStack item) -> item.m_41720_() instanceof UnholyHatItem);
    }

    public static boolean hasUnholySet(LivingEntity livingEntity) {
        return CuriosFinder.hasUnholyRobe(livingEntity) && CuriosFinder.hasUnholyHat(livingEntity) || livingEntity instanceof Apostle;
    }

    public static boolean isWitchFriendly(LivingEntity livingEntity) {
        return CuriosFinder.hasWitchSet(livingEntity) && (Boolean)ItemConfig.WitchSetWitchNeutral.get() != false || CuriosFinder.hasWarlockRobe(livingEntity) && (Boolean)ItemConfig.WarlockRobeWitchNeutral.get() != false || CuriosFinder.hasNetherRobe(livingEntity) && (Boolean)ItemConfig.NetherRobeWitchNeutral.get() != false || CuriosFinder.hasUnholyRobe(livingEntity) || CuriosFinder.hasUnholyHat(livingEntity);
    }

    public static boolean hasWitchSet(LivingEntity livingEntity) {
        return CuriosFinder.hasWitchHat(livingEntity) && CuriosFinder.hasWitchRobe(livingEntity);
    }

    public static boolean hasNecroCrown(LivingEntity livingEntity) {
        return CuriosFinder.hasCurio(livingEntity, (ItemStack itemStack) -> {
            Item patt10160$temp = itemStack.m_41720_();
            if (!(patt10160$temp instanceof NecroGarbs.NecroCrownItem)) return false;
            NecroGarbs.NecroCrownItem crownItem = (NecroGarbs.NecroCrownItem)patt10160$temp;
            if (crownItem.isNameless) return false;
            return true;
        });
    }

    public static boolean hasNecroCape(LivingEntity livingEntity) {
        return CuriosFinder.hasCurio(livingEntity, (ItemStack itemStack) -> {
            Item patt10396$temp = itemStack.m_41720_();
            if (!(patt10396$temp instanceof NecroGarbs.NecroCapeItem)) return false;
            NecroGarbs.NecroCapeItem capeItem = (NecroGarbs.NecroCapeItem)patt10396$temp;
            if (capeItem.isNameless) return false;
            return true;
        });
    }

    public static boolean neutralNecroCrown(LivingEntity livingEntity) {
        return CuriosFinder.hasNecroCrown(livingEntity) && (Boolean)ItemConfig.NecroSetUndeadNeutral.get() != false;
    }

    public static boolean neutralNecroCape(LivingEntity livingEntity) {
        return CuriosFinder.hasNecroCape(livingEntity) && (Boolean)ItemConfig.NecroSetUndeadNeutral.get() != false;
    }

    public static boolean hasNecroSet(LivingEntity livingEntity) {
        return CuriosFinder.hasNecroCrown(livingEntity) && CuriosFinder.hasNecroCape(livingEntity);
    }

    public static boolean neutralNecroSet(LivingEntity livingEntity) {
        return CuriosFinder.hasNecroSet(livingEntity) && (Boolean)ItemConfig.NecroSetUndeadNeutral.get() != false;
    }

    public static boolean validNecroUndead(LivingEntity livingEntity) {
        return !(livingEntity.m_6336_() != MobType.f_21641_ && !livingEntity.m_6095_().m_204039_(ModTags.EntityTypes.NECRO_SET_NEUTRAL) || !((double)livingEntity.m_21233_() <= (Double)ItemConfig.NecroSetUndeadNeutralHealth.get()) || livingEntity instanceof IOwned && !(livingEntity instanceof Enemy));
    }

    public static boolean hasNamelessCrown(LivingEntity livingEntity) {
        return CuriosFinder.hasCurio(livingEntity, (ItemStack itemStack) -> {
            Item patt11649$temp = itemStack.m_41720_();
            if (!(patt11649$temp instanceof NecroGarbs.NecroCrownItem)) return false;
            NecroGarbs.NecroCrownItem crownItem = (NecroGarbs.NecroCrownItem)patt11649$temp;
            if (!crownItem.isNameless) return false;
            return true;
        });
    }

    public static boolean hasNamelessCape(LivingEntity livingEntity) {
        return CuriosFinder.hasCurio(livingEntity, (ItemStack itemStack) -> {
            Item patt11887$temp = itemStack.m_41720_();
            if (!(patt11887$temp instanceof NecroGarbs.NecroCapeItem)) return false;
            NecroGarbs.NecroCapeItem capeItem = (NecroGarbs.NecroCapeItem)patt11887$temp;
            if (!capeItem.isNameless) return false;
            return true;
        });
    }

    public static boolean neutralNamelessCrown(LivingEntity livingEntity) {
        return CuriosFinder.hasNamelessCrown(livingEntity) && (Boolean)ItemConfig.NamelessSetUndeadNeutral.get() != false;
    }

    public static boolean neutralNamelessCape(LivingEntity livingEntity) {
        return CuriosFinder.hasNamelessCape(livingEntity) && (Boolean)ItemConfig.NamelessSetUndeadNeutral.get() != false;
    }

    public static boolean hasNamelessSet(LivingEntity livingEntity) {
        return CuriosFinder.hasNamelessCrown(livingEntity) && CuriosFinder.hasNamelessCape(livingEntity);
    }

    public static boolean neutralNamelessSet(LivingEntity livingEntity) {
        return CuriosFinder.hasNamelessSet(livingEntity) && (Boolean)ItemConfig.NamelessSetUndeadNeutral.get() != false;
    }

    public static boolean validNamelessUndead(LivingEntity livingEntity) {
        return !(livingEntity.m_6336_() != MobType.f_21641_ && !livingEntity.m_6095_().m_204039_(ModTags.EntityTypes.NECRO_SET_NEUTRAL) || !((double)livingEntity.m_21233_() <= (Double)ItemConfig.NamelessSetUndeadNeutralHealth.get()) || livingEntity instanceof IOwned && !(livingEntity instanceof Enemy));
    }

    public static boolean hasUndeadCrown(LivingEntity livingEntity) {
        return CuriosFinder.hasCurio(livingEntity, (ItemStack itemStack) -> itemStack.m_41720_() instanceof NecroGarbs.NecroCrownItem) || livingEntity instanceof AbstractNecromancer;
    }

    public static boolean hasUndeadCape(LivingEntity livingEntity) {
        return CuriosFinder.hasCurio(livingEntity, (ItemStack itemStack) -> itemStack.m_41720_() instanceof NecroGarbs.NecroCapeItem) || livingEntity instanceof AbstractNecromancer;
    }

    public static boolean hasUndeadSet(LivingEntity livingEntity) {
        return CuriosFinder.hasUndeadCrown(livingEntity) && CuriosFinder.hasUndeadCape(livingEntity);
    }

    public static boolean hasFrostRobes(LivingEntity livingEntity) {
        return CuriosFinder.hasCurio(livingEntity, (ItemStack item) -> item.m_41720_() instanceof FrostRobeItem);
    }

    public static boolean hasFrostCrown(LivingEntity livingEntity) {
        return CuriosFinder.hasCurio(livingEntity, (ItemStack item) -> {
            Item patt14008$temp = item.m_41720_();
            if (!(patt14008$temp instanceof MagicCrownItem)) return false;
            MagicCrownItem crownItem = (MagicCrownItem)patt14008$temp;
            if (crownItem.spellType != SpellType.FROST) return false;
            return true;
        });
    }

    public static boolean hasFrostSet(LivingEntity livingEntity) {
        return CuriosFinder.hasFrostRobes(livingEntity) && CuriosFinder.hasFrostCrown(livingEntity);
    }

    public static boolean neutralFrostSet(LivingEntity livingEntity) {
        return CuriosFinder.hasFrostSet(livingEntity) && (Boolean)ItemConfig.FrostSetMobNeutral.get() != false;
    }

    public static boolean validFrostMob(LivingEntity livingEntity) {
        return !(livingEntity.m_6336_() != ModMobType.FROST && !livingEntity.m_6095_().m_204039_(ModTags.EntityTypes.FROST_SET_NEUTRAL) || !((double)livingEntity.m_21233_() <= (Double)ItemConfig.FrostSetMobNeutralHealth.get()) || livingEntity instanceof IOwned && !(livingEntity instanceof Enemy));
    }

    public static boolean hasWindyRobes(LivingEntity livingEntity) {
        return CuriosFinder.hasCurio(livingEntity, (ItemStack item) -> item.m_41720_() instanceof WindyRobeItem);
    }

    public static boolean hasAbyssCrown(LivingEntity livingEntity) {
        return CuriosFinder.hasCurio(livingEntity, (ItemStack item) -> {
            Item patt15137$temp = item.m_41720_();
            if (!(patt15137$temp instanceof MagicCrownItem)) return false;
            MagicCrownItem crownItem = (MagicCrownItem)patt15137$temp;
            if (crownItem.spellType != SpellType.ABYSS) return false;
            return true;
        });
    }

    public static boolean hasAbyssRobes(LivingEntity livingEntity) {
        return CuriosFinder.hasCurio(livingEntity, (ItemStack item) -> item.m_41720_() instanceof AbyssRobeItem);
    }

    public static boolean hasAbyssSet(LivingEntity livingEntity) {
        return CuriosFinder.hasAbyssRobes(livingEntity) && CuriosFinder.hasAbyssCrown(livingEntity);
    }

    public static boolean neutralAbyssSet(LivingEntity livingEntity) {
        return CuriosFinder.hasAbyssSet(livingEntity) && (Boolean)ItemConfig.AbyssSetMobNeutral.get() != false;
    }

    public static boolean validAbyssMob(LivingEntity livingEntity) {
        return !(livingEntity.m_6336_() != MobType.f_21644_ && !livingEntity.m_6095_().m_204039_(ModTags.EntityTypes.ABYSS_SET_NEUTRAL) || !((double)livingEntity.m_21233_() <= (Double)ItemConfig.AbyssSetMobNeutralHealth.get()) || livingEntity instanceof IOwned && !(livingEntity instanceof Enemy));
    }

    private static boolean isRing(ItemStack itemStack) {
        return itemStack.m_41720_() instanceof RingItem;
    }

    public static ItemStack findRing(Player playerEntity) {
        ItemStack foundStack;
        block2: {
            block1: {
                foundStack = ItemStack.f_41583_;
                if (!CuriosLoaded.CURIOS.isLoaded()) break block1;
                Optional slotResult = CuriosApi.getCuriosInventory((LivingEntity)playerEntity).map(inv -> inv.findFirstCurio(CuriosFinder::isRing)).orElse(Optional.empty());
                if (!slotResult.isPresent()) break block2;
                foundStack = ((SlotResult)slotResult.get()).stack();
                break block2;
            }
            for (int i = 0; i < playerEntity.m_150109_().m_6643_(); ++i) {
                ItemStack itemStack = playerEntity.m_150109_().m_8020_(i);
                if (itemStack.m_41619_() || !CuriosFinder.isRing(itemStack)) continue;
                foundStack = itemStack;
                break;
            }
        }
        return foundStack;
    }

    public static ItemStack findBrewInBag(Player player) {
        ItemStack foundStack = ItemStack.f_41583_;
        if (!CuriosFinder.findBrewBag(player).m_41619_()) {
            BrewBagItemHandler brewBagItemHandler = BrewBagItemHandler.get(CuriosFinder.findBrewBag(player));
            for (int i = 1; i < brewBagItemHandler.getSlots(); ++i) {
                ItemStack itemStack = brewBagItemHandler.getStackInSlot(i);
                if (!(itemStack.m_41720_() instanceof ThrowableBrewItem)) continue;
                foundStack = itemStack;
            }
        }
        return foundStack;
    }

    public static int getBrewBagTotal(Player player) {
        int num = 0;
        if (!CuriosFinder.findBrewBag(player).m_41619_()) {
            BrewBagItemHandler brewBagItemHandler = BrewBagItemHandler.get(CuriosFinder.findBrewBag(player));
            for (int i = 1; i < brewBagItemHandler.getSlots(); ++i) {
                ItemStack itemStack = brewBagItemHandler.getStackInSlot(i);
                if (!(itemStack.m_41720_() instanceof ThrowableBrewItem)) continue;
                ++num;
            }
        }
        return num;
    }

    public static boolean hasEmptyBrewBagSpace(Player player) {
        return CuriosFinder.getBrewBagTotal(player) < 10;
    }

    public static boolean hasBrewInBag(Player player) {
        return !CuriosFinder.findBrewInBag(player).m_41619_();
    }

    private static boolean isBrewBag(ItemStack itemStack) {
        return itemStack.m_41720_() == ModItems.BREW_BAG.get();
    }

    public static ItemStack findBrewBag(Player playerEntity) {
        Optional slotResult;
        ItemStack foundStack = ItemStack.f_41583_;
        if (CuriosLoaded.CURIOS.isLoaded() && (slotResult = CuriosApi.getCuriosInventory((LivingEntity)playerEntity).map(inv -> inv.findFirstCurio(CuriosFinder::isBrewBag)).orElse(Optional.empty())).isPresent()) {
            foundStack = ((SlotResult)slotResult.get()).stack();
        }
        for (int i = 0; i < playerEntity.m_150109_().m_6643_(); ++i) {
            ItemStack itemStack = playerEntity.m_150109_().m_8020_(i);
            if (itemStack.m_41619_() || !CuriosFinder.isBrewBag(itemStack)) continue;
            foundStack = itemStack;
            break;
        }
        return foundStack;
    }
}

