/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.common.ritual;

import com.Polarice3.Goety.common.blocks.entities.DarkAltarBlockEntity;
import com.Polarice3.Goety.common.crafting.RitualRecipe;
import com.Polarice3.Goety.common.ritual.Ritual;
import com.Polarice3.Goety.common.ritual.RitualRequirements;
import com.Polarice3.Goety.utils.MobUtil;
import java.util.List;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.Level;

public class ConvertRitual
extends Ritual {
    private final boolean tame;
    private final boolean newEquip;

    public ConvertRitual(RitualRecipe recipe, boolean tame, boolean newEquip) {
        super(recipe);
        this.tame = tame;
        this.newEquip = newEquip;
    }

    @Override
    public boolean isValid(Level world, BlockPos darkAltarPos, DarkAltarBlockEntity tileEntity, Player castingPlayer, ItemStack activationItem, List<Ingredient> remainingAdditionalIngredients) {
        return super.isValid(world, darkAltarPos, tileEntity, castingPlayer, activationItem, remainingAdditionalIngredients) && RitualRequirements.canSummon(world, castingPlayer, this.recipe.getEntityToConvertInto());
    }

    @Override
    public void finish(Level world, BlockPos blockPos, DarkAltarBlockEntity tileEntity, Player castingPlayer, ItemStack activationItem) {
        super.finish(world, blockPos, tileEntity, castingPlayer, activationItem);
        activationItem.m_41774_(1);
        ((ServerLevel)world).m_8767_((ParticleOptions)ParticleTypes.f_123755_, (double)blockPos.m_123341_() + 0.5, (double)blockPos.m_123342_() + 0.5, (double)blockPos.m_123343_() + 0.5, 1, 0.0, 0.0, 0.0, 0.0);
        EntityType<?> entityType = this.recipe.getEntityToConvertInto();
        if (entityType != null && tileEntity.getConvertEntity != null) {
            Entity entity = MobUtil.convertTo((Entity)tileEntity.getConvertEntity, entityType, true, this.newEquip, (Player)(this.tame ? castingPlayer : null));
            if (entity instanceof Mob) {
                Mob mob = (Mob)entity;
                mob.m_21373_();
            }
            if (castingPlayer instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)castingPlayer;
                CriteriaTriggers.f_10580_.m_68256_(serverPlayer, entity);
            }
        }
    }

    public Entity createSummonedEntity(EntityType<?> entityType, Level world, BlockPos goldenBowlPosition, DarkAltarBlockEntity tileEntity, Player castingPlayer) {
        return entityType.m_20615_(world);
    }

    public void initSummoned(LivingEntity living, Level world, BlockPos goldenBowlPosition, DarkAltarBlockEntity tileEntity, Player castingPlayer) {
    }
}

