/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.common.network.server;

import com.Polarice3.Goety.utils.EntityFinder;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkEvent;

public class SPlayEntitySoundPacket {
    private UUID entity;
    private SoundEvent soundEvent;
    private float volume;
    private float pitch;

    public SPlayEntitySoundPacket(UUID uuid, SoundEvent soundEvent, float volume, float pitch) {
        this.entity = uuid;
        this.soundEvent = soundEvent;
        this.volume = volume;
        this.pitch = pitch;
    }

    public static void encode(SPlayEntitySoundPacket packet, FriendlyByteBuf buffer) {
        buffer.m_130077_(packet.entity);
        buffer.m_130085_(packet.soundEvent.m_11660_());
        buffer.writeFloat(packet.volume);
        buffer.writeFloat(packet.pitch);
    }

    public static SPlayEntitySoundPacket decode(FriendlyByteBuf buffer) {
        return new SPlayEntitySoundPacket(buffer.m_130259_(), SoundEvent.m_262824_((ResourceLocation)buffer.m_130281_()), buffer.readFloat(), buffer.readFloat());
    }

    public static void consume(SPlayEntitySoundPacket packet, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            Entity entity;
            ClientLevel clientWorld;
            if (((NetworkEvent.Context)ctx.get()).getDirection() == NetworkDirection.PLAY_TO_CLIENT && (clientWorld = Minecraft.m_91087_().f_91073_) != null && (entity = EntityFinder.getEntityByUuiDGlobal(packet.entity).get()) != null) {
                clientWorld.m_245747_(entity.m_20183_(), packet.soundEvent, entity.m_5720_(), packet.volume, packet.pitch, false);
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

