/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.common.network.client.brew;

import com.Polarice3.Goety.common.entities.projectiles.ThrownBrew;
import com.Polarice3.Goety.common.items.brew.ThrowableBrewItem;
import com.Polarice3.Goety.common.items.handler.BrewBagItemHandler;
import com.Polarice3.Goety.utils.BrewUtils;
import com.Polarice3.Goety.utils.CuriosFinder;
import java.util.function.Supplier;
import net.minecraft.core.Holder;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSoundPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.registries.ForgeRegistries;

public class CThrowBrewKeyPacket {
    public int chosenBrew;

    public CThrowBrewKeyPacket(int chosenBrew) {
        this.chosenBrew = chosenBrew;
    }

    public static void encode(CThrowBrewKeyPacket packet, FriendlyByteBuf buffer) {
        buffer.writeInt(packet.chosenBrew);
    }

    public static CThrowBrewKeyPacket decode(FriendlyByteBuf buffer) {
        return new CThrowBrewKeyPacket(buffer.readInt());
    }

    public static void consume(CThrowBrewKeyPacket packet, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> CThrowBrewKeyPacket.swapFocus(packet.chosenBrew, (Player)((NetworkEvent.Context)ctx.get()).getSender()));
    }

    public static void swapFocus(int swapSlot, Player player) {
        ItemStack stack = CuriosFinder.findBrewBag(player);
        if (stack.m_41613_() <= 0) {
            return;
        }
        BrewBagItemHandler bagHandler = BrewBagItemHandler.get(stack);
        ItemStack bagFocus = bagHandler.getStackInSlot(swapSlot);
        if (bagFocus.m_41720_() instanceof ThrowableBrewItem) {
            if (!player.f_19853_.f_46443_) {
                ThrownBrew thrownBrew = new ThrownBrew(player.f_19853_, (LivingEntity)player);
                thrownBrew.m_37446_(bagFocus);
                float velocity = 0.5f + BrewUtils.getVelocity(bagFocus);
                thrownBrew.m_37251_((Entity)player, player.m_146909_(), player.m_146908_(), -20.0f, velocity, 1.0f);
                player.f_19853_.m_7967_((Entity)thrownBrew);
            }
            player.m_36246_(Stats.f_12982_.m_12902_((Object)bagFocus.m_41720_()));
            if (!player.m_150110_().f_35937_) {
                bagFocus.m_41774_(1);
            }
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                serverPlayer.f_8906_.m_9829_((Packet)new ClientboundSoundPacket((Holder)ForgeRegistries.SOUND_EVENTS.getHolder((Object)SoundEvents.f_12437_).get(), SoundSource.PLAYERS, serverPlayer.m_20182_().f_82479_, serverPlayer.m_20182_().f_82480_, serverPlayer.m_20182_().f_82481_, 1.0f, 1.0f, serverPlayer.m_9236_().m_213780_().m_188505_()));
            }
        }
    }
}

