/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.common.magic.spells.nether;

import com.Polarice3.Goety.api.magic.SpellType;
import com.Polarice3.Goety.common.enchantments.ModEnchantments;
import com.Polarice3.Goety.common.entities.util.FirePillar;
import com.Polarice3.Goety.common.magic.Spell;
import com.Polarice3.Goety.common.magic.SpellStat;
import com.Polarice3.Goety.config.SpellConfig;
import com.Polarice3.Goety.init.ModSounds;
import com.Polarice3.Goety.utils.BlockFinder;
import com.Polarice3.Goety.utils.MobUtil;
import com.Polarice3.Goety.utils.WandUtil;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class FlameStrikeSpell
extends Spell {
    @Override
    public SpellStat defaultStats() {
        return super.defaultStats().setDuration(180).setRadius(3.0);
    }

    @Override
    public int defaultSoulCost() {
        return (Integer)SpellConfig.FlameStrikeCost.get();
    }

    @Override
    public int defaultCastDuration() {
        return (Integer)SpellConfig.FlameStrikeDuration.get();
    }

    @Override
    @Nullable
    public SoundEvent CastingSound() {
        return (SoundEvent)ModSounds.RUMBLE.get();
    }

    @Override
    public int defaultSpellCooldown() {
        return (Integer)SpellConfig.FlameStrikeCoolDown.get();
    }

    @Override
    public SpellType getSpellType() {
        return SpellType.NETHER;
    }

    @Override
    public List<Enchantment> acceptedEnchantments() {
        ArrayList<Enchantment> list = new ArrayList<Enchantment>();
        list.add((Enchantment)ModEnchantments.POTENCY.get());
        list.add((Enchantment)ModEnchantments.DURATION.get());
        list.add((Enchantment)ModEnchantments.RANGE.get());
        return list;
    }

    @Override
    public void startSpell(ServerLevel worldIn, LivingEntity caster, ItemStack staff, SpellStat spellStat) {
        block7: {
            FirePillar flames;
            float f2;
            int k;
            int duration;
            int warmUp;
            block6: {
                warmUp = this.castDuration(caster, staff) - 10;
                duration = spellStat.getDuration() * (WandUtil.getLevels((Enchantment)ModEnchantments.DURATION.get(), caster) + 1);
                int range = spellStat.getRange() + WandUtil.getLevels((Enchantment)ModEnchantments.RANGE.get(), caster);
                LivingEntity target = this.getTarget(caster, range);
                if (target == null || this.isShifting(caster)) break block6;
                double radius = spellStat.getRadius();
                if (this.rightStaff(staff)) {
                    radius *= 2.0;
                }
                List<Vec3> vec3s = BlockFinder.buildOuterBlockCircle(target.m_20182_(), radius);
                for (Vec3 vec3 : vec3s) {
                    FirePillar flames2 = new FirePillar((Level)worldIn, vec3.f_82479_, vec3.f_82480_, vec3.f_82481_);
                    flames2.setOwner(caster);
                    flames2.setDuration(duration);
                    flames2.setWarmUp(warmUp);
                    flames2.setExtraDamage(WandUtil.getLevels((Enchantment)ModEnchantments.POTENCY.get(), caster));
                    MobUtil.moveDownToGround(flames2);
                    worldIn.m_7967_((Entity)flames2);
                }
                break block7;
            }
            Vec3 vector3d = caster.m_20252_(1.0f);
            float f = (float)Mth.m_14136_((double)(vector3d.f_82481_ - caster.m_20189_()), (double)(vector3d.f_82479_ - caster.m_20185_()));
            for (k = 0; k < 8; ++k) {
                f2 = f + (float)k * (float)Math.PI * 0.25f + 1.0f;
                flames = new FirePillar((Level)worldIn, caster.m_20185_() + (double)Mth.m_14089_((float)f2), caster.m_20186_(), caster.m_20189_() + (double)Mth.m_14031_((float)f2));
                flames.setOwner(caster);
                flames.setDuration(duration);
                flames.setWarmUp(warmUp);
                flames.setExtraDamage(WandUtil.getLevels((Enchantment)ModEnchantments.POTENCY.get(), caster));
                MobUtil.moveDownToGround(flames);
                worldIn.m_7967_((Entity)flames);
            }
            for (k = 0; k < 8; ++k) {
                f2 = f + (float)k * (float)Math.PI * 0.25f + 3.0f;
                flames = new FirePillar((Level)worldIn, caster.m_20185_() + (double)Mth.m_14089_((float)f2) * 3.0, caster.m_20186_(), caster.m_20189_() + (double)Mth.m_14031_((float)f2) * 3.0);
                flames.setOwner(caster);
                flames.setDuration(duration);
                flames.setWarmUp(warmUp);
                flames.setExtraDamage(WandUtil.getLevels((Enchantment)ModEnchantments.POTENCY.get(), caster));
                MobUtil.moveDownToGround(flames);
                worldIn.m_7967_((Entity)flames);
            }
            if (!this.rightStaff(staff)) break block7;
            for (k = 0; k < 8; ++k) {
                f2 = f + (float)k * (float)Math.PI * 0.25f + 6.0f;
                flames = new FirePillar((Level)worldIn, caster.m_20185_() + (double)Mth.m_14089_((float)f2) * 6.0, caster.m_20186_(), caster.m_20189_() + (double)Mth.m_14031_((float)f2) * 6.0);
                flames.setOwner(caster);
                flames.setDuration(duration);
                flames.setWarmUp(warmUp);
                flames.setExtraDamage(WandUtil.getLevels((Enchantment)ModEnchantments.POTENCY.get(), caster));
                MobUtil.moveDownToGround(flames);
                worldIn.m_7967_((Entity)flames);
            }
            for (k = 0; k < 16; ++k) {
                f2 = f + (float)k * (float)Math.PI * 0.25f + 9.0f;
                flames = new FirePillar((Level)worldIn, caster.m_20185_() + (double)Mth.m_14089_((float)f2) * 9.0, caster.m_20186_(), caster.m_20189_() + (double)Mth.m_14031_((float)f2) * 9.0);
                flames.setOwner(caster);
                flames.setDuration(duration);
                flames.setWarmUp(warmUp);
                flames.setExtraDamage(WandUtil.getLevels((Enchantment)ModEnchantments.POTENCY.get(), caster));
                MobUtil.moveDownToGround(flames);
                worldIn.m_7967_((Entity)flames);
            }
        }
    }
}

