/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.common.magic.spells.nether;

import com.Polarice3.Goety.api.magic.SpellType;
import com.Polarice3.Goety.client.particles.ModParticleTypes;
import com.Polarice3.Goety.client.particles.ShockwaveParticleOption;
import com.Polarice3.Goety.client.particles.VerticalCircleExplodeParticleOption;
import com.Polarice3.Goety.common.enchantments.ModEnchantments;
import com.Polarice3.Goety.common.magic.Spell;
import com.Polarice3.Goety.common.magic.SpellStat;
import com.Polarice3.Goety.config.SpellConfig;
import com.Polarice3.Goety.init.ModSounds;
import com.Polarice3.Goety.utils.ColorUtil;
import com.Polarice3.Goety.utils.CuriosFinder;
import com.Polarice3.Goety.utils.MobUtil;
import com.Polarice3.Goety.utils.ModDamageSource;
import com.Polarice3.Goety.utils.RandomUtil;
import com.Polarice3.Goety.utils.SpellExplosion;
import com.Polarice3.Goety.utils.WandUtil;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.Level;

public class FireBlastSpell
extends Spell {
    @Override
    public SpellStat defaultStats() {
        return super.defaultStats().setRadius(3.0);
    }

    @Override
    public int defaultSoulCost() {
        return (Integer)SpellConfig.FireBlastCost.get();
    }

    @Override
    public int defaultCastDuration() {
        return (Integer)SpellConfig.FireBlastDuration.get();
    }

    @Override
    public int defaultSpellCooldown() {
        return (Integer)SpellConfig.FireBlastCoolDown.get();
    }

    @Override
    public SoundEvent CastingSound() {
        return (SoundEvent)ModSounds.PREPARE_SPELL.get();
    }

    @Override
    public SpellType getSpellType() {
        return SpellType.NETHER;
    }

    @Override
    public List<Enchantment> acceptedEnchantments() {
        ArrayList<Enchantment> list = new ArrayList<Enchantment>();
        list.add((Enchantment)ModEnchantments.POTENCY.get());
        list.add((Enchantment)ModEnchantments.RADIUS.get());
        list.add((Enchantment)ModEnchantments.BURNING.get());
        return list;
    }

    @Override
    public void SpellResult(ServerLevel worldIn, LivingEntity caster, ItemStack staff, SpellStat spellStat) {
        int radius = (int)spellStat.getRadius();
        float damage = ((Double)SpellConfig.FireBlastDamage.get()).floatValue() * (float)((Integer)SpellConfig.SpellDamageMultiplier.get()).intValue();
        float maxDamage = ((Double)SpellConfig.FireBlastMaxDamage.get()).floatValue() * (float)((Integer)SpellConfig.SpellDamageMultiplier.get()).intValue();
        int burning = spellStat.getBurning();
        if (WandUtil.enchantedFocus(caster)) {
            radius += WandUtil.getLevels((Enchantment)ModEnchantments.RADIUS.get(), caster);
            damage += (float)WandUtil.getLevels((Enchantment)ModEnchantments.POTENCY.get(), caster) / 2.0f;
            maxDamage += (float)WandUtil.getLevels((Enchantment)ModEnchantments.POTENCY.get(), caster) / 2.0f;
            burning += WandUtil.getLevels((Enchantment)ModEnchantments.BURNING.get(), caster);
        }
        damage += (float)spellStat.getPotency();
        maxDamage += (float)spellStat.getPotency();
        for (int i = -radius; i < radius; ++i) {
            for (int k = -radius; k < radius; ++k) {
                BlockPos blockPos = caster.m_20183_().m_7918_(i, 0, k);
                worldIn.m_8767_((ParticleOptions)((SimpleParticleType)ModParticleTypes.BIG_FIRE.get()), (double)blockPos.m_123341_(), (double)((float)blockPos.m_123342_() + 0.5f), (double)blockPos.m_123343_(), 0, 0.0, 0.04, 0.0, 0.5);
            }
        }
        ColorUtil colorUtil = new ColorUtil(14523414);
        worldIn.m_8767_((ParticleOptions)new ShockwaveParticleOption(colorUtil.red(), colorUtil.green(), colorUtil.blue()), caster.m_20185_(), caster.m_20186_() + 0.5, caster.m_20189_(), 0, 0.0, 0.0, 0.0, 0.0);
        worldIn.m_8767_((ParticleOptions)new VerticalCircleExplodeParticleOption(colorUtil.red(), colorUtil.green(), colorUtil.blue(), radius, 1), caster.m_20185_(), caster.m_20186_() + 0.5, caster.m_20189_(), 1, 0.0, 0.0, 0.0, 0.0);
        float trueDamage = Mth.m_14036_((float)(damage + (float)RandomUtil.nextInt(worldIn.m_213780_(), (int)(maxDamage - damage))), (float)damage, (float)maxDamage);
        DamageSource damageSource = ModDamageSource.fireBreath((Entity)caster, (Entity)caster);
        if (CuriosFinder.hasNetherRobe(caster)) {
            damageSource = ModDamageSource.magicFireBreath((Entity)caster, (Entity)caster);
        }
        if (MobUtil.getOwner((Entity)caster) != null && CuriosFinder.hasNetherRobe(MobUtil.getOwner((Entity)caster))) {
            damageSource = ModDamageSource.magicFireBreath((Entity)caster, (Entity)caster);
        }
        if (CuriosFinder.hasUnholySet(caster)) {
            damageSource = ModDamageSource.hellfire((Entity)caster, (Entity)caster);
        }
        final int finalBurning = burning;
        float increase = 0.0f;
        if (this.rightStaff(staff)) {
            increase = 0.5f;
        }
        new SpellExplosion((Level)worldIn, (Entity)caster, damageSource, caster.m_20183_(), (float)radius + increase, trueDamage){

            @Override
            public void explodeHurt(Entity target, DamageSource damageSource, double x, double y, double z, double seen, float actualDamage) {
                if (target instanceof LivingEntity) {
                    LivingEntity target1 = (LivingEntity)target;
                    super.explodeHurt(target, damageSource, x, y, z, seen, actualDamage);
                    if (!target.m_5825_()) {
                        int i = finalBurning + 1;
                        target1.m_20254_(5 * i);
                    }
                }
            }
        };
        this.playSound(worldIn, (Entity)caster, SoundEvents.f_11913_, 2.0f, 1.0f);
        this.playSound(worldIn, (Entity)caster, (SoundEvent)ModSounds.HELL_BLAST_IMPACT.get(), 2.0f, 1.0f);
    }
}

