/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.common.magic.spells.frost;

import com.Polarice3.Goety.api.magic.SpellType;
import com.Polarice3.Goety.common.enchantments.ModEnchantments;
import com.Polarice3.Goety.common.entities.projectiles.HailCloud;
import com.Polarice3.Goety.common.magic.Spell;
import com.Polarice3.Goety.common.magic.SpellStat;
import com.Polarice3.Goety.config.SpellConfig;
import com.Polarice3.Goety.init.ModSounds;
import com.Polarice3.Goety.utils.WandUtil;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;

public class HailSpell
extends Spell {
    @Override
    public SpellStat defaultStats() {
        return super.defaultStats().setDuration(100);
    }

    @Override
    public int defaultSoulCost() {
        return (Integer)SpellConfig.HailCost.get();
    }

    @Override
    public int defaultCastDuration() {
        return (Integer)SpellConfig.HailDuration.get();
    }

    @Override
    public SoundEvent CastingSound() {
        return (SoundEvent)ModSounds.FROST_PREPARE_SPELL.get();
    }

    @Override
    public int defaultSpellCooldown() {
        return (Integer)SpellConfig.HailCoolDown.get();
    }

    @Override
    public SpellType getSpellType() {
        return SpellType.FROST;
    }

    @Override
    public List<Enchantment> acceptedEnchantments() {
        ArrayList<Enchantment> list = new ArrayList<Enchantment>();
        list.add((Enchantment)ModEnchantments.POTENCY.get());
        list.add((Enchantment)ModEnchantments.RANGE.get());
        list.add((Enchantment)ModEnchantments.DURATION.get());
        list.add((Enchantment)ModEnchantments.RADIUS.get());
        return list;
    }

    @Override
    public void SpellResult(ServerLevel worldIn, LivingEntity caster, ItemStack staff, SpellStat spellStat) {
        int range = spellStat.getRange();
        int duration = spellStat.getDuration();
        double radius = spellStat.getRadius();
        float potency = spellStat.getPotency();
        if (WandUtil.enchantedFocus(caster)) {
            range += WandUtil.getLevels((Enchantment)ModEnchantments.RANGE.get(), caster);
            duration *= WandUtil.getLevels((Enchantment)ModEnchantments.DURATION.get(), caster) + 1;
            potency += (float)WandUtil.getLevels((Enchantment)ModEnchantments.POTENCY.get(), caster);
            radius += (double)WandUtil.getLevels((Enchantment)ModEnchantments.RADIUS.get(), caster);
        }
        HitResult rayTraceResult = this.rayTrace((Level)worldIn, caster, range, radius);
        LivingEntity target = this.getTarget(caster, range);
        if (target != null) {
            if (target instanceof LivingEntity) {
                HailCloud hailCloud = new HailCloud((Level)worldIn, caster, target);
                hailCloud.setExtraDamage(potency);
                hailCloud.setRadius((float)radius);
                hailCloud.setLifeSpan(duration);
                hailCloud.setStaff(this.rightStaff(staff));
                worldIn.m_7967_((Entity)hailCloud);
            }
            this.playSound(worldIn, (Entity)caster, SoundEvents.f_144205_);
        } else if (rayTraceResult instanceof BlockHitResult) {
            BlockPos blockPos = ((BlockHitResult)rayTraceResult).m_82425_();
            HailCloud hailCloud = new HailCloud((Level)worldIn, caster, null);
            hailCloud.setExtraDamage(potency);
            hailCloud.setRadius((float)radius);
            hailCloud.setLifeSpan(duration);
            hailCloud.setStaff(this.rightStaff(staff));
            hailCloud.m_6034_((float)blockPos.m_123341_() + 0.5f, blockPos.m_123342_() + 4, (float)blockPos.m_123343_() + 0.5f);
            worldIn.m_7967_((Entity)hailCloud);
            this.playSound(worldIn, (Entity)caster, SoundEvents.f_144205_);
        }
    }
}

