/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.common.magic.spells.abyss;

import com.Polarice3.Goety.api.magic.SpellType;
import com.Polarice3.Goety.common.enchantments.ModEnchantments;
import com.Polarice3.Goety.common.entities.projectiles.BouncyBubble;
import com.Polarice3.Goety.common.magic.Spell;
import com.Polarice3.Goety.common.magic.SpellStat;
import com.Polarice3.Goety.config.SpellConfig;
import com.Polarice3.Goety.utils.WandUtil;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class BouncyBubbleSpell
extends Spell {
    @Override
    public SpellStat defaultStats() {
        return super.defaultStats().setRadius(0.0);
    }

    @Override
    public int defaultSoulCost() {
        return (Integer)SpellConfig.BouncyBubbleCost.get();
    }

    @Override
    public int defaultCastDuration() {
        return (Integer)SpellConfig.BouncyBubbleDuration.get();
    }

    @Override
    @Nullable
    public SoundEvent CastingSound() {
        return SoundEvents.f_11917_;
    }

    @Override
    public int defaultSpellCooldown() {
        return (Integer)SpellConfig.BouncyBubbleCoolDown.get();
    }

    @Override
    public SpellType getSpellType() {
        return SpellType.ABYSS;
    }

    @Override
    public List<Enchantment> acceptedEnchantments() {
        ArrayList<Enchantment> list = new ArrayList<Enchantment>();
        list.add((Enchantment)ModEnchantments.POTENCY.get());
        list.add((Enchantment)ModEnchantments.VELOCITY.get());
        list.add((Enchantment)ModEnchantments.RADIUS.get());
        return list;
    }

    @Override
    public void SpellResult(ServerLevel worldIn, LivingEntity caster, ItemStack staff, SpellStat spellStat) {
        int potency = spellStat.getPotency();
        int velocity = (int)spellStat.getVelocity();
        int radius = (int)spellStat.getRadius();
        if (WandUtil.enchantedFocus(caster)) {
            potency += WandUtil.getLevels((Enchantment)ModEnchantments.POTENCY.get(), caster);
            velocity += WandUtil.getLevels((Enchantment)ModEnchantments.VELOCITY.get(), caster);
            radius += WandUtil.getLevels((Enchantment)ModEnchantments.RADIUS.get(), caster);
        }
        Vec3 vector3d = caster.m_20154_();
        BouncyBubble bouncyBubble = new BouncyBubble(caster.m_20185_() + vector3d.f_82479_ / 2.0, caster.m_20188_() - 0.2, caster.m_20189_() + vector3d.f_82481_ / 2.0, vector3d.f_82479_, vector3d.f_82480_, vector3d.f_82481_, (Level)worldIn);
        bouncyBubble.shoot(vector3d);
        bouncyBubble.m_5602_((Entity)caster);
        bouncyBubble.setExtraDamage(potency);
        bouncyBubble.setBoltSpeed(velocity);
        bouncyBubble.setSize(radius);
        worldIn.m_7967_((Entity)bouncyBubble);
        if (this.rightStaff(staff)) {
            for (int i = 0; i < 2; ++i) {
                BouncyBubble bouncyBubble2 = new BouncyBubble(caster.m_20185_() + vector3d.f_82479_ / 2.0 + worldIn.f_46441_.m_188583_(), caster.m_20188_() - 0.2, caster.m_20189_() + vector3d.f_82481_ / 2.0 + worldIn.f_46441_.m_188583_(), vector3d.f_82479_, vector3d.f_82480_, vector3d.f_82481_, (Level)worldIn);
                bouncyBubble2.shoot(vector3d);
                bouncyBubble2.m_5602_((Entity)caster);
                bouncyBubble2.setExtraDamage(potency);
                bouncyBubble2.setBoltSpeed(velocity);
                bouncyBubble2.setSize(radius);
                worldIn.m_7967_((Entity)bouncyBubble2);
            }
        }
    }
}

