/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.common.magic.spells;

import com.Polarice3.Goety.client.particles.ModParticleTypes;
import com.Polarice3.Goety.client.particles.ShockwaveParticleOption;
import com.Polarice3.Goety.common.effects.GoetyEffects;
import com.Polarice3.Goety.common.enchantments.ModEnchantments;
import com.Polarice3.Goety.common.magic.Spell;
import com.Polarice3.Goety.common.magic.SpellStat;
import com.Polarice3.Goety.config.SpellConfig;
import com.Polarice3.Goety.init.ModSounds;
import com.Polarice3.Goety.utils.ColorUtil;
import com.Polarice3.Goety.utils.MathHelper;
import com.Polarice3.Goety.utils.MobUtil;
import com.Polarice3.Goety.utils.WandUtil;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import org.jetbrains.annotations.Nullable;

public class WeakeningSpell
extends Spell {
    @Override
    public SpellStat defaultStats() {
        return super.defaultStats().setDuration(5).setRadius(7.0);
    }

    @Override
    public int defaultSoulCost() {
        return (Integer)SpellConfig.WeakeningCost.get();
    }

    @Override
    public int defaultCastDuration() {
        return (Integer)SpellConfig.WeakeningDuration.get();
    }

    @Override
    @Nullable
    public SoundEvent CastingSound() {
        return (SoundEvent)ModSounds.WEAKEN_CAST.get();
    }

    @Override
    public int defaultSpellCooldown() {
        return (Integer)SpellConfig.WeakeningCoolDown.get();
    }

    @Override
    public List<Enchantment> acceptedEnchantments() {
        ArrayList<Enchantment> list = new ArrayList<Enchantment>();
        list.add((Enchantment)ModEnchantments.POTENCY.get());
        list.add((Enchantment)ModEnchantments.RADIUS.get());
        list.add((Enchantment)ModEnchantments.DURATION.get());
        return list;
    }

    @Override
    public void SpellResult(ServerLevel worldIn, LivingEntity caster, ItemStack staff, SpellStat spellStat) {
        int potency = spellStat.getPotency();
        int radius = (int)spellStat.getRadius();
        int duration = spellStat.getDuration();
        if (WandUtil.enchantedFocus(caster)) {
            potency += WandUtil.getLevels((Enchantment)ModEnchantments.POTENCY.get(), caster);
            radius += WandUtil.getLevels((Enchantment)ModEnchantments.RADIUS.get(), caster);
            duration += WandUtil.getLevels((Enchantment)ModEnchantments.DURATION.get(), caster);
        }
        ColorUtil colorUtil = new ColorUtil(ChatFormatting.LIGHT_PURPLE);
        worldIn.m_8767_((ParticleOptions)new ShockwaveParticleOption(colorUtil.red, colorUtil.green, colorUtil.blue, radius, 1, true), caster.m_20185_(), caster.m_20186_() + 0.25, caster.m_20189_(), 0, 0.0, 0.0, 0.0, 0.0);
        for (int i = -radius; i < radius; ++i) {
            for (int k = -radius; k < radius; ++k) {
                BlockPos blockPos = caster.m_20183_().m_7918_(i, 0, k);
                if (!(worldIn.f_46441_.m_188501_() <= 0.25f)) continue;
                worldIn.m_8767_((ParticleOptions)((SimpleParticleType)ModParticleTypes.SPELL_SQUARE.get()), (double)blockPos.m_123341_(), (double)blockPos.m_123342_(), (double)blockPos.m_123343_(), 0, (double)colorUtil.red(), (double)colorUtil.green(), (double)colorUtil.blue(), 0.5);
            }
        }
        for (LivingEntity livingEntity : worldIn.m_45976_(LivingEntity.class, caster.m_20191_().m_82400_((double)radius))) {
            if (MobUtil.areAllies((Entity)caster, (Entity)livingEntity)) continue;
            livingEntity.m_7292_(new MobEffectInstance((MobEffect)GoetyEffects.SAPPED.get(), MathHelper.secondsToTicks(duration), potency + 4));
            livingEntity.m_7292_(new MobEffectInstance(MobEffects.f_19613_, MathHelper.secondsToTicks(duration), potency));
            livingEntity.m_216990_((SoundEvent)ModSounds.WEAKEN_CURSE.get());
        }
        this.playSound(worldIn, caster, 2.0f, 1.0f);
    }
}

