/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.common.items.armor;

import com.Polarice3.Goety.Goety;
import com.Polarice3.Goety.client.render.ModModelLayer;
import com.Polarice3.Goety.client.render.model.CursedPaladinArmorModel;
import com.Polarice3.Goety.common.items.ModItems;
import com.Polarice3.Goety.common.items.armor.ModArmorMaterials;
import com.Polarice3.Goety.utils.ItemHelper;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;

public class CursedPaladinArmor
extends ArmorItem {
    public CursedPaladinArmor(ArmorItem.Type p_40387_) {
        super((ArmorMaterial)ModArmorMaterials.CURSED_PALADIN, p_40387_, ModItems.baseProperties());
    }

    public <T extends LivingEntity> int damageItem(ItemStack stack, int amount, T entity, Consumer<T> onBroken) {
        if (ItemHelper.armorSet(entity, this.m_40401_()) && entity.m_217043_().m_188499_()) {
            return 0;
        }
        return amount;
    }

    public String getArmorTexture(ItemStack stack, Entity entity, EquipmentSlot slot, String layer) {
        if (slot == EquipmentSlot.LEGS) {
            return Goety.location("textures/models/armor/cursed_paladin_armor_layer.png").toString();
        }
        return Goety.location("textures/models/armor/cursed_paladin_armor.png").toString();
    }

    public void initializeClient(Consumer<IClientItemExtensions> consumer) {
        super.initializeClient(consumer);
        consumer.accept(new IClientItemExtensions(){

            public HumanoidModel<?> getHumanoidArmorModel(LivingEntity livingEntity, ItemStack itemStack, EquipmentSlot equipmentSlot, HumanoidModel<?> original) {
                EntityModelSet modelSet = Minecraft.m_91087_().m_167973_();
                ModelPart root = modelSet.m_171103_(equipmentSlot == EquipmentSlot.LEGS ? ModModelLayer.CURSED_PALADIN_ARMOR_INNER : ModModelLayer.CURSED_PALADIN_ARMOR_OUTER);
                CursedPaladinArmorModel model = new CursedPaladinArmorModel(root).animate(livingEntity);
                model.f_102809_.f_104207_ = equipmentSlot == EquipmentSlot.HEAD;
                model.body.f_104207_ = equipmentSlot == EquipmentSlot.CHEST;
                model.rightArm.f_104207_ = equipmentSlot == EquipmentSlot.CHEST;
                model.leftArm.f_104207_ = equipmentSlot == EquipmentSlot.CHEST;
                model.rightLeg.f_104207_ = equipmentSlot == EquipmentSlot.FEET;
                model.leftLeg.f_104207_ = equipmentSlot == EquipmentSlot.FEET;
                model.f_102610_ = original.f_102610_;
                model.f_102817_ = original.f_102817_;
                model.f_102609_ = original.f_102609_;
                model.f_102816_ = original.f_102816_;
                model.f_102815_ = original.f_102815_;
                return model;
            }
        });
    }
}

