/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.common.events;

import com.Polarice3.Goety.common.entities.ModEntityType;
import com.Polarice3.Goety.common.entities.hostile.Wight;
import com.Polarice3.Goety.common.entities.neutral.Owned;
import com.Polarice3.Goety.config.MainConfig;
import com.Polarice3.Goety.config.MobsConfig;
import com.Polarice3.Goety.init.ModTags;
import com.Polarice3.Goety.utils.BlockFinder;
import com.Polarice3.Goety.utils.SEHelper;
import java.util.Random;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.Tags;

public class WightSpawner {
    private int nextTick;

    public int tick(ServerLevel pLevel) {
        if (!((Boolean)MobsConfig.WightSpawn.get()).booleanValue()) {
            return 0;
        }
        RandomSource random = pLevel.f_46441_;
        --this.nextTick;
        if (this.nextTick > 0) {
            return 0;
        }
        this.nextTick += ((Integer)MobsConfig.WightSpawnFreq.get()).intValue();
        if (random.m_188503_(((Integer)MobsConfig.WightSpawnChance.get()).intValue()) != 0) {
            return 0;
        }
        int j = pLevel.m_6907_().size();
        if (j < 1) {
            return 0;
        }
        if (!pLevel.m_46469_().m_46207_(GameRules.f_46134_)) {
            return 0;
        }
        ServerPlayer pPlayer = (ServerPlayer)pLevel.m_6907_().get(random.m_188503_(j));
        float rawPercent = (float)SEHelper.getSoulAmountInt((Player)pPlayer) / (float)((Integer)MainConfig.MaxArcaSouls.get()).intValue();
        int sePercent = (int)(rawPercent * 100.0f);
        if (pPlayer.m_5833_() || pPlayer.m_7500_()) {
            return 0;
        }
        if (!pLevel.m_204166_(pPlayer.m_20183_()).m_203656_(ModTags.Biomes.WIGHT_SPAWN)) {
            return 0;
        }
        if (!pLevel.m_6443_(LivingEntity.class, pPlayer.m_20191_().m_82400_(64.0), entity -> entity.m_6095_().m_204039_(Tags.EntityTypes.BOSSES) || entity.m_6095_().m_204039_(ModTags.EntityTypes.MINI_BOSSES)).isEmpty()) {
            return 0;
        }
        if (sePercent >= 9 && sePercent < 20) {
            WightSpawner.summonWight(pLevel, (Player)pPlayer, sePercent);
            this.nextTick += ((Integer)MobsConfig.WightSpawnFreq.get()).intValue();
            return 1;
        }
        if (sePercent >= 20 && sePercent < 90) {
            WightSpawner.summonWight(pLevel, (Player)pPlayer, sePercent);
            return 1;
        }
        if (sePercent >= 90) {
            int extra = random.m_188503_(1);
            for (int i = 0; i < extra + 1; ++i) {
                WightSpawner.summonWight(pLevel, (Player)pPlayer, sePercent);
            }
            return 1;
        }
        return 0;
    }

    public static boolean summonWight(ServerLevel serverLevel, Player player, int sePercent) {
        Wight wight = new Wight((EntityType<? extends Owned>)((EntityType)ModEntityType.WIGHT.get()), (Level)serverLevel);
        Random rand = new Random();
        for (int i = 0; i < 16; ++i) {
            Vec3 vec3 = BlockFinder.getRandomSpawnBehindDirection(serverLevel, rand, player.m_20182_(), player.m_20154_());
            BlockPos blockPos = BlockPos.m_274446_((Position)vec3);
            if (!BlockFinder.canSeeBlock((Entity)player, blockPos) && i != 15 || !serverLevel.m_46749_(blockPos)) continue;
            wight.m_146884_(vec3);
            wight.m_6518_((ServerLevelAccessor)serverLevel, serverLevel.m_6436_(wight.m_20183_()), MobSpawnType.MOB_SUMMONED, null, null);
            wight.upgradePower(sePercent);
            return serverLevel.m_7967_((Entity)wight);
        }
        return false;
    }

    public void forceSpawn(ServerLevel pLevel, ServerPlayer pPlayer, CommandSourceStack pSource) {
        float rawPercent = (float)SEHelper.getSoulAmountInt((Player)pPlayer) / (float)((Integer)MainConfig.MaxArcaSouls.get()).intValue();
        int sePercent = (int)(rawPercent * 100.0f);
        if (WightSpawner.summonWight(pLevel, (Player)pPlayer, sePercent)) {
            pSource.m_288197_(() -> Component.m_237110_((String)"commands.goety.misc.wight.success", (Object[])new Object[]{pPlayer.m_5446_()}), true);
        } else {
            pSource.m_81352_((Component)Component.m_237115_((String)"commands.goety.misc.wight.failure"));
        }
    }
}

