/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.common.events;

import com.Polarice3.Goety.common.effects.GoetyEffects;
import com.Polarice3.Goety.common.network.ModNetwork;
import com.Polarice3.Goety.common.network.server.SRemoveEffectPacket;
import com.Polarice3.Goety.init.ModTags;
import com.Polarice3.Goety.utils.SEHelper;
import javax.annotation.Nullable;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.event.entity.living.LivingChangeTargetEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingEntityUseItemEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingKnockBackEvent;
import net.minecraftforge.event.entity.living.MobEffectEvent;
import net.minecraftforge.event.entity.player.AttackEntityEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="goety", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class StunnedEvents {
    private static boolean isStunned(@Nullable LivingEntity entity) {
        Player player;
        return entity != null && entity.m_6084_() && (entity.m_21023_((MobEffect)GoetyEffects.STUNNED.get()) || entity instanceof Player && SEHelper.hasCamera(player = (Player)entity));
    }

    public static void cancelEvent(LivingEvent event) {
        if (event.isCancelable() && StunnedEvents.isStunned(event.getEntity())) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void cancelPlayerAttack(AttackEntityEvent event) {
        StunnedEvents.cancelEvent((LivingEvent)event);
    }

    @SubscribeEvent
    public static void cancelBreakSpeed(PlayerEvent.BreakSpeed event) {
        StunnedEvents.cancelEvent((LivingEvent)event);
    }

    @SubscribeEvent
    public static void cancelActivateBlock(PlayerInteractEvent.RightClickBlock event) {
        StunnedEvents.cancelEvent((LivingEvent)event);
    }

    @SubscribeEvent
    public static void cancelInteract(PlayerInteractEvent.EntityInteract event) {
        StunnedEvents.cancelEvent((LivingEvent)event);
    }

    @SubscribeEvent
    public static void cancelUsingItem(LivingEntityUseItemEvent.Start event) {
        StunnedEvents.cancelEvent((LivingEvent)event);
    }

    @SubscribeEvent
    public static void cancelTickUsingItem(LivingEntityUseItemEvent.Tick event) {
        StunnedEvents.cancelEvent((LivingEvent)event);
    }

    @SubscribeEvent
    public static void cancelPlayerUseItem(PlayerInteractEvent.RightClickItem event) {
        StunnedEvents.cancelEvent((LivingEvent)event);
    }

    @SubscribeEvent
    public static void onLivingTarget(LivingChangeTargetEvent event) {
        Mob mob;
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Mob && StunnedEvents.isStunned((LivingEntity)(mob = (Mob)livingEntity))) {
            if (event.getTargetType() == LivingChangeTargetEvent.LivingTargetType.MOB_TARGET) {
                event.setNewTarget(null);
            } else {
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public static void onKnockback(LivingKnockBackEvent event) {
        if (event.getEntity().m_21023_((MobEffect)GoetyEffects.TANGLED.get())) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void PotionApplicationEvents(MobEffectEvent.Applicable event) {
        if ((event.getEffectInstance().m_19544_() == GoetyEffects.STUNNED.get() || event.getEffectInstance().m_19544_().m_19481_().contains("born_in_chaos_v1:stun")) && event.getEntity().m_6095_().m_204039_(ModTags.EntityTypes.UNSTUNNABLE)) {
            event.setResult(Event.Result.DENY);
        }
    }

    @SubscribeEvent
    public static void onLivingDeath(LivingDeathEvent event) {
        if (!event.getEntity().f_19853_.f_46443_ && StunnedEvents.isStunned(event.getEntity())) {
            event.getEntity().m_21195_((MobEffect)GoetyEffects.STUNNED.get());
            event.getEntity().m_21195_((MobEffect)GoetyEffects.TANGLED.get());
            ModNetwork.sendToALL(new SRemoveEffectPacket(event.getEntity().m_19879_(), MobEffect.m_19459_((MobEffect)((MobEffect)GoetyEffects.STUNNED.get()))));
            ModNetwork.sendToALL(new SRemoveEffectPacket(event.getEntity().m_19879_(), MobEffect.m_19459_((MobEffect)((MobEffect)GoetyEffects.TANGLED.get()))));
        }
    }
}

