/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.common.entities.projectiles;

import com.Polarice3.Goety.common.entities.projectiles.SpellEntity;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import net.minecraft.commands.arguments.ParticleArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.projectile.ItemSupplier;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class EyeItemEntity
extends SpellEntity
implements ItemSupplier {
    private static final EntityDataAccessor<ItemStack> DATA_ITEM_STACK = SynchedEntityData.m_135353_(EyeItemEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135033_);
    private static final EntityDataAccessor<ParticleOptions> DATA_PARTICLE = SynchedEntityData.m_135353_(EyeItemEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135036_);
    private double tx;
    private double ty;
    private double tz;
    private int life;
    private boolean surviveAfterDeath;

    public EyeItemEntity(EntityType<? extends EyeItemEntity> p_36957_, Level p_36958_) {
        super(p_36957_, p_36958_);
    }

    public EyeItemEntity(EntityType<? extends EyeItemEntity> p_36957_, Level p_36960_, double p_36961_, double p_36962_, double p_36963_) {
        this(p_36957_, p_36960_);
        this.m_6034_(p_36961_, p_36962_, p_36963_);
    }

    public void setItem(ItemStack p_36973_) {
        this.m_20088_().m_135381_(DATA_ITEM_STACK, (Object)p_36973_.m_255036_(1));
    }

    private ItemStack getItemRaw() {
        return (ItemStack)this.m_20088_().m_135370_(DATA_ITEM_STACK);
    }

    public ItemStack m_7846_() {
        ItemStack itemstack = this.getItemRaw();
        return itemstack.m_41619_() ? new ItemStack((ItemLike)Items.f_42545_) : itemstack;
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.m_20088_().m_135372_(DATA_ITEM_STACK, (Object)ItemStack.f_41583_);
        this.m_20088_().m_135372_(DATA_PARTICLE, (Object)ParticleTypes.f_123760_);
    }

    public ParticleOptions getParticle() {
        return (ParticleOptions)this.m_20088_().m_135370_(DATA_PARTICLE);
    }

    public void setParticle(ParticleOptions p_19725_) {
        this.m_20088_().m_135381_(DATA_PARTICLE, (Object)p_19725_);
    }

    public boolean m_6783_(double p_36966_) {
        double d0 = this.m_20191_().m_82309_() * 4.0;
        if (Double.isNaN(d0)) {
            d0 = 4.0;
        }
        return p_36966_ < (d0 *= 64.0) * d0;
    }

    public void signalTo(BlockPos p_36968_) {
        double d3;
        double d0 = p_36968_.m_123341_();
        int i = p_36968_.m_123342_();
        double d1 = p_36968_.m_123343_();
        double d2 = d0 - this.m_20185_();
        double d4 = Math.sqrt(d2 * d2 + (d3 = d1 - this.m_20189_()) * d3);
        if (d4 > 12.0) {
            this.tx = this.m_20185_() + d2 / d4 * 12.0;
            this.tz = this.m_20189_() + d3 / d4 * 12.0;
            this.ty = this.m_20186_() + 8.0;
        } else {
            this.tx = d0;
            this.ty = i;
            this.tz = d1;
        }
        this.life = 0;
        this.surviveAfterDeath = this.f_19796_.m_188503_(5) > 0;
    }

    public void setSurviveAfterDeath(boolean survive) {
        this.surviveAfterDeath = survive;
    }

    public void m_6001_(double p_36984_, double p_36985_, double p_36986_) {
        this.m_20334_(p_36984_, p_36985_, p_36986_);
        if (this.f_19860_ == 0.0f && this.f_19859_ == 0.0f) {
            double d0 = Math.sqrt(p_36984_ * p_36984_ + p_36986_ * p_36986_);
            this.m_146922_((float)(Mth.m_14136_((double)p_36984_, (double)p_36986_) * 57.2957763671875));
            this.m_146926_((float)(Mth.m_14136_((double)p_36985_, (double)d0) * 57.2957763671875));
            this.f_19859_ = this.m_146908_();
            this.f_19860_ = this.m_146909_();
        }
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        Vec3 vec3 = this.m_20184_();
        double d0 = this.m_20185_() + vec3.f_82479_;
        double d1 = this.m_20186_() + vec3.f_82480_;
        double d2 = this.m_20189_() + vec3.f_82481_;
        double d3 = vec3.m_165924_();
        this.m_146926_(EyeItemEntity.lerpRotation(this.f_19860_, (float)(Mth.m_14136_((double)vec3.f_82480_, (double)d3) * 57.2957763671875)));
        this.m_146922_(EyeItemEntity.lerpRotation(this.f_19859_, (float)(Mth.m_14136_((double)vec3.f_82479_, (double)vec3.f_82481_) * 57.2957763671875)));
        if (!this.f_19853_.f_46443_) {
            double d4 = this.tx - d0;
            double d5 = this.tz - d2;
            float f = (float)Math.sqrt(d4 * d4 + d5 * d5);
            float f1 = (float)Mth.m_14136_((double)d5, (double)d4);
            double d6 = Mth.m_14139_((double)0.0025, (double)d3, (double)f);
            double d7 = vec3.f_82480_;
            if (f < 1.0f) {
                d6 *= 0.8;
                d7 *= 0.8;
            }
            int j = this.m_20186_() < this.ty ? 1 : -1;
            vec3 = new Vec3(Math.cos(f1) * d6, d7 + ((double)j - d7) * (double)0.015f, Math.sin(f1) * d6);
            this.m_20256_(vec3);
        }
        float f2 = 0.25f;
        if (this.m_20069_()) {
            for (int i = 0; i < 4; ++i) {
                this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123795_, d0 - vec3.f_82479_ * 0.25, d1 - vec3.f_82480_ * 0.25, d2 - vec3.f_82481_ * 0.25, vec3.f_82479_, vec3.f_82480_, vec3.f_82481_);
            }
        } else {
            this.f_19853_.m_7106_(this.getParticle(), d0 - vec3.f_82479_ * 0.25 + this.f_19796_.m_188500_() * 0.6 - 0.3, d1 - vec3.f_82480_ * 0.25 - 0.5, d2 - vec3.f_82481_ * 0.25 + this.f_19796_.m_188500_() * 0.6 - 0.3, vec3.f_82479_, vec3.f_82480_, vec3.f_82481_);
        }
        if (!this.f_19853_.f_46443_) {
            this.m_6034_(d0, d1, d2);
            ++this.life;
            if (this.life > 80 && !this.f_19853_.f_46443_) {
                this.m_5496_(SoundEvents.f_11897_, 1.0f, 1.0f);
                this.m_146870_();
                if (this.surviveAfterDeath) {
                    this.f_19853_.m_7967_((Entity)new ItemEntity(this.f_19853_, this.m_20185_(), this.m_20186_(), this.m_20189_(), this.m_7846_()));
                } else {
                    this.breakParticles((ServerLevel)this.f_19853_, this.m_20183_());
                    if (this.m_269323_() != null) {
                        this.drawParticleBeam(this.m_269323_());
                    }
                }
            }
        } else {
            this.m_20343_(d0, d1, d2);
        }
    }

    private void drawParticleBeam(LivingEntity pSource) {
        double d0 = this.m_20185_() - pSource.m_20185_();
        double d1 = this.m_20186_() + (double)this.m_20206_() * 0.5 - (pSource.m_20186_() + (double)pSource.m_20206_() * 0.5);
        double d2 = this.m_20189_() - pSource.m_20189_();
        double d3 = Math.sqrt(d0 * d0 + d1 * d1 + d2 * d2);
        d0 /= d3;
        d1 /= d3;
        d2 /= d3;
        double d4 = pSource.f_19853_.f_46441_.m_188500_();
        Level level = pSource.f_19853_;
        if (level instanceof ServerLevel) {
            ServerLevel serverWorld = (ServerLevel)level;
            while (d4 < d3) {
                serverWorld.m_8767_((ParticleOptions)ParticleTypes.f_175830_, pSource.m_20185_() + d0 * (d4 += 1.0), pSource.m_20186_() + d1 * d4 + (double)pSource.m_20192_() * 0.5, pSource.m_20189_() + d2 * d4, 1, 0.0, 0.0, 0.0, 0.0);
            }
        }
    }

    public void breakParticles(ServerLevel serverLevel, BlockPos blockPos) {
        double d0 = (double)blockPos.m_123341_() + 0.5;
        double d7 = blockPos.m_123342_();
        double d9 = (double)blockPos.m_123343_() + 0.5;
        for (int k3 = 0; k3 < 8; ++k3) {
            serverLevel.m_8767_((ParticleOptions)new ItemParticleOption(ParticleTypes.f_123752_, this.m_7846_()), d0, d7, d9, 0, serverLevel.f_46441_.m_188583_() * 0.15, serverLevel.f_46441_.m_188500_() * 0.2, serverLevel.f_46441_.m_188583_() * 0.15, 0.5);
        }
        for (double d12 = 0.0; d12 < Math.PI * 2; d12 += 0.15707963267948966) {
            serverLevel.m_8767_(this.getParticle(), d0 + Math.cos(d12) * 5.0, d7 - 0.4, d9 + Math.sin(d12) * 5.0, 0, Math.cos(d12) * -5.0, 0.0, Math.sin(d12) * -5.0, 0.5);
            serverLevel.m_8767_(this.getParticle(), d0 + Math.cos(d12) * 5.0, d7 - 0.4, d9 + Math.sin(d12) * 5.0, 0, Math.cos(d12) * -7.0, 0.0, Math.sin(d12) * -7.0, 0.5);
        }
    }

    @Override
    public void m_7380_(CompoundTag p_36975_) {
        super.m_7380_(p_36975_);
        p_36975_.m_128359_("Particle", this.getParticle().m_5942_());
        p_36975_.m_128379_("Survive", this.surviveAfterDeath);
        ItemStack itemstack = this.getItemRaw();
        if (!itemstack.m_41619_()) {
            p_36975_.m_128365_("Item", (Tag)itemstack.m_41739_(new CompoundTag()));
        }
    }

    @Override
    public void m_7378_(CompoundTag p_36970_) {
        super.m_7378_(p_36970_);
        if (p_36970_.m_128425_("Particle", 8)) {
            try {
                this.setParticle(ParticleArgument.m_247456_((StringReader)new StringReader(p_36970_.m_128461_("Particle")), (HolderLookup)BuiltInRegistries.f_257034_.m_255303_()));
            }
            catch (CommandSyntaxException commandSyntaxException) {
                // empty catch block
            }
        }
        this.surviveAfterDeath = p_36970_.m_128471_("Survive");
        ItemStack itemstack = ItemStack.m_41712_((CompoundTag)p_36970_.m_128469_("Item"));
        this.setItem(itemstack);
    }

    public float m_213856_() {
        return 1.0f;
    }

    public boolean m_6097_() {
        return false;
    }

    protected static float lerpRotation(float p_37274_, float p_37275_) {
        while (p_37275_ - p_37274_ < -180.0f) {
            p_37274_ -= 360.0f;
        }
        while (p_37275_ - p_37274_ >= 180.0f) {
            p_37274_ += 360.0f;
        }
        return Mth.m_14179_((float)0.2f, (float)p_37274_, (float)p_37275_);
    }
}

