/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.common.entities.projectiles;

import com.Polarice3.Goety.api.entities.IOwned;
import com.Polarice3.Goety.client.particles.ModParticleTypes;
import com.Polarice3.Goety.client.particles.ShockwaveParticleOption;
import com.Polarice3.Goety.client.particles.VerticalCircleExplodeParticleOption;
import com.Polarice3.Goety.common.effects.GoetyEffects;
import com.Polarice3.Goety.common.entities.ModEntityType;
import com.Polarice3.Goety.common.entities.projectiles.SpellThrowableProjectile;
import com.Polarice3.Goety.config.SpellConfig;
import com.Polarice3.Goety.init.ModSounds;
import com.Polarice3.Goety.utils.ColorUtil;
import com.Polarice3.Goety.utils.MathHelper;
import com.Polarice3.Goety.utils.MobUtil;
import com.Polarice3.Goety.utils.ModDamageSource;
import com.Polarice3.Goety.utils.SpellExplosion;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class ElectroOrb
extends SpellThrowableProjectile {
    public double xd;
    public double yd;
    public double zd;

    public ElectroOrb(EntityType<? extends SpellThrowableProjectile> p_19870_, Level p_19871_) {
        super(p_19870_, p_19871_);
    }

    public ElectroOrb(Level pLevel, LivingEntity pOwner, @Nullable LivingEntity pTarget) {
        super((EntityType<? extends SpellThrowableProjectile>)((EntityType)ModEntityType.ELECTRO_ORB.get()), pOwner, pLevel);
        if (pTarget != null && !MobUtil.areAllies((Entity)pOwner, (Entity)pTarget)) {
            this.setTarget(pTarget);
        }
    }

    @Override
    protected float getGravity() {
        if (this.getTarget() == null) {
            return super.getGravity();
        }
        return 0.0f;
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (this.getTarget() != null) {
            double distance = this.m_20280_((Entity)this.getTarget());
            Vec3 vec3 = this.getTargetingVec(distance);
            this.m_20256_(vec3);
        }
        if (this.f_19797_ >= MathHelper.secondsToTicks(10)) {
            this.m_146870_();
        }
    }

    private Vec3 getTargetingVec(double distance) {
        if (this.getTarget() != null) {
            double dx = (this.getTarget().m_20185_() - this.m_20185_()) / distance;
            double dy = (this.getTarget().m_20191_().f_82289_ + (double)this.getTarget().m_20206_() * 0.6 - this.m_20186_()) / distance;
            double dz = (this.getTarget().m_20189_() - this.m_20189_()) / distance;
            double d2 = 0.2;
            this.xd += dx * d2;
            this.yd += dy * d2;
            this.zd += dz * d2;
            this.xd = Mth.m_14008_((double)this.xd, (double)-0.25, (double)0.25);
            this.yd = Mth.m_14008_((double)this.yd, (double)-0.25, (double)0.25);
            this.zd = Mth.m_14008_((double)this.zd, (double)-0.25, (double)0.25);
            return new Vec3(this.xd, this.yd, this.zd);
        }
        return Vec3.f_82478_;
    }

    protected void m_6532_(HitResult hitResult) {
        if (!this.f_19853_.f_46443_) {
            DamageSource damageSource = ModDamageSource.getDamageSource(this.f_19853_, ModDamageSource.SHOCK, new EntityType[0]);
            float damage = ((Double)SpellConfig.ElectroOrbDamage.get()).floatValue() * ((Integer)SpellConfig.SpellDamageMultiplier.get()).floatValue();
            if (this.getOwner() != null) {
                damageSource = ModDamageSource.indirectShock((Entity)this, (Entity)this.getOwner());
            }
            damage += this.getExtraDamage();
            if (hitResult instanceof EntityHitResult) {
                EntityHitResult result = (EntityHitResult)hitResult;
                Entity entity = result.m_82443_();
                entity.m_6469_(damageSource, damage);
                if (this.isStaff()) {
                    float chance = 0.05f;
                    if (this.f_19853_.m_46470_() && this.f_19853_.m_46758_(entity.m_20183_())) {
                        chance += 0.25f;
                    }
                    if (entity instanceof LivingEntity) {
                        LivingEntity livingEntity = (LivingEntity)entity;
                        if (this.f_19853_.f_46441_.m_188501_() <= chance) {
                            livingEntity.m_7292_(new MobEffectInstance((MobEffect)GoetyEffects.SPASMS.get(), MathHelper.secondsToTicks(5)));
                        }
                    }
                }
            }
            this.finalizeExplosion();
            this.m_5496_((SoundEvent)ModSounds.THUNDERBOLT.get(), 1.0f, 1.0f + (this.f_19796_.m_188501_() - this.f_19796_.m_188501_()) * 0.2f);
            this.m_146870_();
        }
    }

    public void finalizeExplosion() {
        Level level = this.f_19853_;
        if (level instanceof ServerLevel) {
            final ServerLevel serverLevel = (ServerLevel)level;
            ColorUtil colorUtil = new ColorUtil(16709015);
            if (this.isStaff()) {
                DamageSource damageSource = ModDamageSource.getDamageSource(this.f_19853_, ModDamageSource.SHOCK, new EntityType[0]);
                int radius = 2;
                float damage = ((Double)SpellConfig.ElectroOrbDamage.get()).floatValue() * ((Integer)SpellConfig.SpellDamageMultiplier.get()).floatValue();
                if (this.getOwner() != null) {
                    Mob mob;
                    damageSource = ModDamageSource.indirectShock((Entity)this, (Entity)this.getOwner());
                    LivingEntity livingEntity = this.getOwner();
                    if (livingEntity instanceof Mob && (mob = (Mob)livingEntity).m_21051_(Attributes.f_22281_) != null) {
                        damage = (float)mob.m_21133_(Attributes.f_22281_);
                    }
                }
                for (int i = -radius; i < radius; ++i) {
                    for (int k = -radius; k < radius; ++k) {
                        BlockPos blockPos = this.m_20183_().m_7918_(i, 0, k);
                        serverLevel.m_8767_((ParticleOptions)((SimpleParticleType)ModParticleTypes.ELECTRIC.get()), (double)blockPos.m_123341_(), (double)((float)blockPos.m_123342_() + 0.5f), (double)blockPos.m_123343_(), 0, 0.0, 0.04, 0.0, 0.5);
                    }
                }
                serverLevel.m_8767_((ParticleOptions)new ShockwaveParticleOption(colorUtil.red(), colorUtil.green(), colorUtil.blue(), 5.0f, 0, true), this.m_20185_(), this.m_20186_() + 0.5, this.m_20189_(), 0, 0.0, 0.0, 0.0, 0.0);
                serverLevel.m_8767_((ParticleOptions)new VerticalCircleExplodeParticleOption(colorUtil.red(), colorUtil.green(), colorUtil.blue(), radius, 1), this.m_20185_(), this.m_20186_() + 0.5, this.m_20189_(), 1, 0.0, 0.0, 0.0, 0.0);
                new SpellExplosion((Level)serverLevel, (Entity)this, damageSource, this.m_20183_(), radius, damage){

                    @Override
                    public void explodeHurt(Entity target, DamageSource damageSource, double x, double y, double z, double seen, float actualDamage) {
                        if (target instanceof LivingEntity) {
                            LivingEntity target1 = (LivingEntity)target;
                            super.explodeHurt(target, damageSource, x, y, z, seen, actualDamage);
                            float chance = 0.05f;
                            if (serverLevel.m_46470_() && serverLevel.m_46758_(target1.m_20183_())) {
                                chance += 0.25f;
                            }
                            if (serverLevel.f_46441_.m_188501_() <= chance) {
                                target1.m_7292_(new MobEffectInstance((MobEffect)GoetyEffects.SPASMS.get(), MathHelper.secondsToTicks(5)));
                            }
                        }
                    }
                };
                serverLevel.m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), (SoundEvent)ModSounds.REDSTONE_EXPLODE.get(), this.m_5720_(), 1.0f, 1.0f);
            }
        }
    }

    protected boolean m_5603_(Entity pEntity) {
        if (this.getOwner() != null) {
            Mob mob;
            if (pEntity == this.getOwner()) {
                return false;
            }
            LivingEntity livingEntity = this.getOwner();
            if (livingEntity instanceof Mob && (mob = (Mob)livingEntity).m_5448_() == pEntity) {
                return super.m_5603_(pEntity);
            }
            if (MobUtil.areAllies((Entity)this.getOwner(), pEntity)) {
                return false;
            }
            if (pEntity instanceof IOwned) {
                IOwned owned0 = (IOwned)pEntity;
                LivingEntity livingEntity2 = this.getOwner();
                if (livingEntity2 instanceof IOwned) {
                    IOwned owned1 = (IOwned)livingEntity2;
                    return !MobUtil.ownerStack(owned0, owned1);
                }
            }
        }
        return super.m_5603_(pEntity);
    }
}

