/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.common.entities.neutral;

import com.Polarice3.Goety.common.entities.ModEntityType;
import com.Polarice3.Goety.common.entities.ally.Summoned;
import com.Polarice3.Goety.common.entities.neutral.CarrionFly;
import com.Polarice3.Goety.common.entities.neutral.Owned;
import com.Polarice3.Goety.init.ModSounds;
import com.Polarice3.Goety.utils.ServerParticleUtil;
import java.util.EnumSet;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.ClimbOnTopOfPowderSnowGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LeapAtTargetGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.navigation.WallClimberNavigation;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class CarrionMaggot
extends Summoned {
    private static final EntityDataAccessor<Byte> DATA_FLAGS_ID = SynchedEntityData.m_135353_(CarrionMaggot.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    private static final EntityDataAccessor<Integer> DATA_HOST = SynchedEntityData.m_135353_(CarrionMaggot.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Boolean> DATA_COCOON = SynchedEntityData.m_135353_(CarrionMaggot.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public int cocoonTick;
    public AnimationState idleAnimationState = new AnimationState();
    public AnimationState emergeAnimationState = new AnimationState();

    public CarrionMaggot(EntityType<? extends CarrionMaggot> p_32591_, Level p_32592_) {
        super(p_32591_, p_32592_);
    }

    @Override
    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(0, (Goal)new CocoonGoal());
        this.f_21345_.m_25352_(1, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new ClimbOnTopOfPowderSnowGoal((Mob)this, this.f_19853_));
        this.f_21345_.m_25352_(3, (Goal)new LeapAtTargetGoal((Mob)this, 0.4f){

            public boolean m_8036_() {
                return super.m_8036_() && !CarrionMaggot.this.isCocoon();
            }

            public boolean m_8045_() {
                return super.m_8045_() && !CarrionMaggot.this.isCocoon();
            }

            public void m_8056_() {
                if (!CarrionMaggot.this.isCocoon()) {
                    super.m_8056_();
                }
            }
        });
        this.f_21345_.m_25352_(4, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.0, false));
        this.f_21345_.m_25352_(8, new Summoned.WanderGoal<CarrionMaggot>(this, 1.0, 10, 0.0f));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]).m_26044_(new Class[0]));
    }

    protected float m_6431_(Pose p_32604_, EntityDimensions p_32605_) {
        return 0.13f;
    }

    public static AttributeSupplier.Builder setCustomAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22276_, 8.0).m_22268_(Attributes.f_22279_, 0.25).m_22268_(Attributes.f_22281_, 2.0);
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_FLAGS_ID, (Object)0);
        this.f_19804_.m_135372_(DATA_HOST, (Object)-1);
        this.f_19804_.m_135372_(DATA_COCOON, (Object)false);
    }

    @Override
    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        if (compound.m_128441_("Cocoon")) {
            this.setCocoon(compound.m_128471_("Cocoon"));
        }
        if (compound.m_128441_("CocoonTick")) {
            this.cocoonTick = compound.m_128451_("CocoonTick");
        }
    }

    @Override
    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128379_("Cocoon", this.isCocoon());
        compound.m_128405_("CocoonTick", this.cocoonTick);
    }

    protected void m_7840_(double p_27419_, boolean p_27420_, BlockState p_27421_, BlockPos p_27422_) {
    }

    protected PathNavigation m_6037_(Level p_33802_) {
        return new WallClimberNavigation((Mob)this, p_33802_);
    }

    @Override
    public int xpReward() {
        return 3;
    }

    protected SoundEvent m_7515_() {
        return (SoundEvent)ModSounds.MAGGOT_AMBIENT.get();
    }

    protected SoundEvent m_7975_(DamageSource p_32615_) {
        return (SoundEvent)ModSounds.MAGGOT_HURT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)ModSounds.MAGGOT_DEATH.get();
    }

    protected void m_7355_(BlockPos p_32607_, BlockState p_32608_) {
        this.m_5496_((SoundEvent)ModSounds.MAGGOT_STEP.get(), 0.15f, 1.0f);
    }

    public MobType m_6336_() {
        return MobType.f_21642_;
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return new ClientboundAddEntityPacket((Entity)this, this.m_217003_(Pose.EMERGING) ? 1 : 0);
    }

    public void m_141965_(ClientboundAddEntityPacket p_219420_) {
        super.m_141965_(p_219420_);
        if (p_219420_.m_131509_() == 1) {
            this.m_20124_(Pose.EMERGING);
        }
    }

    @Override
    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor pLevel, DifficultyInstance pDifficulty, MobSpawnType pReason, @Nullable SpawnGroupData pSpawnData, @Nullable CompoundTag pDataTag) {
        if (pReason == MobSpawnType.MOB_SUMMONED) {
            this.m_20124_(Pose.EMERGING);
        }
        if (pReason == MobSpawnType.SPAWN_EGG) {
            this.setHostile(true);
        }
        return super.m_6518_(pLevel, pDifficulty, pReason, pSpawnData, pDataTag);
    }

    @Override
    public boolean m_6469_(DamageSource source, float amount) {
        if (this.m_20159_() && source.m_276093_(DamageTypes.f_268612_)) {
            return false;
        }
        if (this.isCocoon()) {
            amount /= 1.5f;
        }
        return super.m_6469_(source, amount);
    }

    @Override
    public boolean m_7327_(Entity entityIn) {
        boolean flag = super.m_7327_(entityIn);
        if (flag && this.f_19853_.f_46441_.m_188501_() <= 0.25f + this.f_19853_.m_6436_(this.m_20183_()).m_19057_() && this.m_20202_() == null && !entityIn.m_20160_() && entityIn.m_6084_()) {
            this.m_20329_(entityIn);
            this.setHost(entityIn.m_19879_());
        }
        return flag;
    }

    @Override
    public void m_8119_() {
        this.f_20883_ = this.m_146908_();
        super.m_8119_();
        if (this.m_217003_(Pose.EMERGING)) {
            this.m_6478_(MoverType.SELF, new Vec3(0.0, 0.0, 0.0));
            this.emergeAnimationState.m_216982_(this.f_19797_);
            this.idleAnimationState.m_216973_();
            if (this.f_19797_ >= 10) {
                this.m_20124_(Pose.STANDING);
            }
        } else {
            this.idleAnimationState.m_216982_(this.f_19797_);
            this.emergeAnimationState.m_216973_();
        }
        this.setClimbing(this.f_19862_);
        if (!this.f_19853_.f_46443_) {
            Mob mobOwner;
            LivingEntity livingEntity;
            if (this.m_20202_() != null && this.m_5448_() == this.m_20202_() && !this.m_21224_() && this.f_19797_ % 20 == 0) {
                this.m_5496_((SoundEvent)ModSounds.MAGGOT_ATTACK.get(), this.m_6121_(), this.m_6100_());
                this.m_7327_(this.m_20202_());
                if (this.f_19853_.f_46441_.m_188501_() <= 0.25f) {
                    this.m_8127_();
                    this.setHost(-1);
                }
            }
            if (this.m_20202_() == null && this.getHost() != -1) {
                this.setHost(-1);
            }
            if (!this.isCocoon()) {
                if (!this.isClimbing() && this.f_19797_ > 20 && this.m_5448_() != null && this.m_5448_().m_6084_() && !this.m_20159_() && !this.m_21224_() && this.m_5448_().m_20186_() > this.m_20186_() + 4.0 && this.f_19797_ % 100 == 0) {
                    this.setCocoon(true);
                    this.f_19853_.m_7605_((Entity)this, (byte)4);
                }
            } else {
                this.setStaying(true);
                this.setWandering(false);
                this.setBoundPos(null);
                ++this.cocoonTick;
                this.m_21573_().m_26573_();
                this.m_21566_().m_24988_(0.0f, 0.0f);
            }
            if (this.getTrueOwner() != null && (livingEntity = this.getTrueOwner()) instanceof Mob && ((mobOwner = (Mob)livingEntity).m_213877_() || mobOwner.m_21224_())) {
                this.lifeSpanDamage();
            }
        } else if (this.m_20202_() == null && this.getHost() != -1) {
            Entity entity = this.f_19853_.m_6815_(this.getHost());
            if (entity != null) {
                this.m_20329_(entity);
            }
        } else if (this.m_20202_() != null && this.getHost() == -1) {
            this.m_8127_();
        }
    }

    public boolean m_6147_() {
        return this.isClimbing();
    }

    public boolean isClimbing() {
        return ((Byte)this.f_19804_.m_135370_(DATA_FLAGS_ID) & 1) != 0;
    }

    public void setClimbing(boolean p_33820_) {
        byte b0 = (Byte)this.f_19804_.m_135370_(DATA_FLAGS_ID);
        b0 = p_33820_ ? (byte)(b0 | 1) : (byte)(b0 & 0xFFFFFFFE);
        this.f_19804_.m_135381_(DATA_FLAGS_ID, (Object)b0);
    }

    public int getHost() {
        return (Integer)this.f_19804_.m_135370_(DATA_HOST);
    }

    public void setHost(int host) {
        this.f_19804_.m_135381_(DATA_HOST, (Object)host);
    }

    public boolean isCocoon() {
        return (Boolean)this.f_19804_.m_135370_(DATA_COCOON);
    }

    public void setCocoon(boolean cocoon) {
        this.f_19804_.m_135381_(DATA_COCOON, (Object)cocoon);
    }

    public void m_5618_(float p_32621_) {
        this.m_146922_(p_32621_);
        super.m_5618_(p_32621_);
    }

    public double m_6049_() {
        return 0.1;
    }

    public void m_7822_(byte p_21375_) {
        if (p_21375_ == 4) {
            this.setCocoon(true);
            this.m_5496_((SoundEvent)ModSounds.SPIDER_NEST_TRAIN.get(), 1.0f, 0.75f);
        } else {
            super.m_7822_(p_21375_);
        }
    }

    @Override
    public void lifeSpanDamage() {
        if (!this.f_19853_.f_46443_) {
            for (int i = 0; i < this.f_19853_.f_46441_.m_188503_(10) + 10; ++i) {
                ServerParticleUtil.smokeParticles((ParticleOptions)ParticleTypes.f_123762_, this.m_20185_(), this.m_20188_(), this.m_20189_(), this.f_19853_);
            }
        }
        this.m_146870_();
    }

    @Override
    public void setUpgraded(boolean upgraded) {
        super.setUpgraded(upgraded);
        AttributeInstance health = this.m_21051_(Attributes.f_22276_);
        AttributeInstance attack = this.m_21051_(Attributes.f_22281_);
        if (health != null && attack != null) {
            if (upgraded) {
                health.m_22100_(10.64);
                attack.m_22100_(2.2);
            } else {
                health.m_22100_(8.0);
                attack.m_22100_(2.0);
            }
        }
    }

    class CocoonGoal
    extends Goal {
        public CocoonGoal() {
            this.m_7021_(EnumSet.of(Goal.Flag.JUMP, Goal.Flag.LOOK, Goal.Flag.MOVE));
        }

        public boolean m_8036_() {
            return CarrionMaggot.this.isCocoon();
        }

        public boolean m_8045_() {
            return CarrionMaggot.this.cocoonTick <= 100;
        }

        public void m_8037_() {
            CarrionMaggot.this.m_21573_().m_26573_();
            CarrionMaggot.this.m_21566_().m_24988_(0.0f, 0.0f);
        }

        public void m_8041_() {
            Level level;
            CarrionFly carrionFly = new CarrionFly((EntityType<? extends Owned>)((EntityType)ModEntityType.CARRION_FLY.get()), CarrionMaggot.this.f_19853_);
            carrionFly.setUpgraded(CarrionMaggot.this.isUpgraded());
            carrionFly.m_146884_(CarrionMaggot.this.m_20182_());
            if (CarrionMaggot.this.getTrueOwner() != null) {
                carrionFly.setTrueOwner(CarrionMaggot.this.getTrueOwner());
            } else {
                carrionFly.setHostile(CarrionMaggot.this.isHostile());
            }
            if (CarrionMaggot.this.getLifespan() > 0 && CarrionMaggot.this.hasLifespan()) {
                carrionFly.setLifespan(CarrionMaggot.this.getLifespan());
            }
            if (CarrionMaggot.this.m_8077_()) {
                carrionFly.m_6593_(CarrionMaggot.this.m_7770_());
            }
            carrionFly.m_21557_(CarrionMaggot.this.m_21525_());
            if (CarrionMaggot.this.m_21532_()) {
                carrionFly.m_21530_();
            }
            if ((level = CarrionMaggot.this.f_19853_) instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                carrionFly.m_6518_((ServerLevelAccessor)serverLevel, serverLevel.m_6436_(CarrionMaggot.this.m_20183_()), CarrionMaggot.this.getSpawnType() != null ? CarrionMaggot.this.getSpawnType() : MobSpawnType.CONVERSION, null, null);
                ServerParticleUtil.addParticlesAroundMiddleSelf(serverLevel, (ParticleOptions)new ItemParticleOption(ParticleTypes.f_123752_, new ItemStack((ItemLike)Items.f_42521_)), (Entity)CarrionMaggot.this);
            }
            if (CarrionMaggot.this.m_5448_() != null && CarrionMaggot.this.m_5448_().m_6084_()) {
                carrionFly.m_6710_(CarrionMaggot.this.m_5448_());
            }
            if (CarrionMaggot.this.f_19853_.m_7967_((Entity)carrionFly)) {
                CarrionMaggot.this.m_5496_(SoundEvents.f_12385_, 1.5f, 0.5f);
                CarrionMaggot.this.m_146870_();
            }
        }

        public boolean m_183429_() {
            return true;
        }
    }
}

