/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.common.entities.neutral;

import com.Polarice3.Goety.common.entities.neutral.Owned;
import com.Polarice3.Goety.utils.MobUtil;
import com.google.common.collect.ImmutableList;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public abstract class AbstractMonolith
extends Owned {
    protected static final EntityDataAccessor<Integer> AGE = SynchedEntityData.m_135353_(AbstractMonolith.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private boolean activate;
    public int lifeSpan = 6;

    public AbstractMonolith(EntityType<? extends Owned> type, Level worldIn) {
        super(type, worldIn);
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(AGE, (Object)0);
    }

    public void m_7350_(EntityDataAccessor<?> p_33134_) {
        if (AGE.equals(p_33134_)) {
            this.m_6210_();
        }
        super.m_7350_(p_33134_);
    }

    @Override
    public void m_7380_(CompoundTag p_31485_) {
        super.m_7380_(p_31485_);
        p_31485_.m_128405_("Age", this.getAge());
        p_31485_.m_128405_("LifeSpan", this.getLifeSpan());
        p_31485_.m_128379_("Activate", this.isActivate());
    }

    @Override
    public void m_7378_(CompoundTag p_31474_) {
        super.m_7378_(p_31474_);
        if (p_31474_.m_128441_("Age")) {
            this.setAge(p_31474_.m_128451_("Age"));
        }
        if (p_31474_.m_128441_("LifeSpan")) {
            this.setLifeSpan(p_31474_.m_128451_("LifeSpan"));
        }
        if (p_31474_.m_128441_("Activate")) {
            this.setActivate(p_31474_.m_128471_("Activate"));
        }
    }

    @Override
    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor pLevel, DifficultyInstance pDifficulty, MobSpawnType pReason, @Nullable SpawnGroupData pSpawnData, @Nullable CompoundTag pDataTag) {
        pSpawnData = super.m_6518_(pLevel, pDifficulty, pReason, pSpawnData, pDataTag);
        this.initRotate();
        if (pReason == MobSpawnType.MOB_SUMMONED && !this.canSpawn((Level)pLevel.m_6018_())) {
            this.m_146870_();
        }
        return pSpawnData;
    }

    public void initRotate() {
        switch (this.m_217043_().m_188503_(4)) {
            case 1: {
                this.m_146922_(90.0f);
                break;
            }
            case 2: {
                this.m_146922_(180.0f);
                break;
            }
            case 3: {
                this.m_146922_(270.0f);
                break;
            }
            default: {
                this.m_146922_(0.0f);
            }
        }
    }

    public abstract BlockState getState();

    public ParticleOptions getParticles() {
        return new BlockParticleOption(ParticleTypes.f_123794_, this.getState());
    }

    public void setAge(int age) {
        this.f_19804_.m_135381_(AGE, (Object)age);
    }

    public int getAge() {
        return (Integer)this.f_19804_.m_135370_(AGE);
    }

    public void setActivate(boolean activate) {
        this.activate = activate;
    }

    public boolean isActivate() {
        return this.activate;
    }

    public void setLifeSpan(int lifeSpan) {
        this.lifeSpan = lifeSpan;
    }

    public int getLifeSpan() {
        return this.lifeSpan;
    }

    public boolean m_6673_(DamageSource p_219427_) {
        return this.isEmerging() && !p_219427_.m_269533_(DamageTypeTags.f_268738_) || super.m_6673_(p_219427_);
    }

    public static float getEmergingTime() {
        return 60.0f;
    }

    public boolean isEmerging() {
        return (float)this.getAge() < AbstractMonolith.getEmergingTime() && !this.isActivate();
    }

    public boolean m_20164_() {
        return (float)this.getAge() < AbstractMonolith.getEmergingTime() && this.isActivate();
    }

    public boolean m_5829_() {
        return true;
    }

    @Override
    public boolean m_7301_(MobEffectInstance potioneffectIn) {
        return super.m_7301_(potioneffectIn) && this.canHaveEffects();
    }

    public boolean canHaveEffects() {
        return false;
    }

    public boolean m_6094_() {
        return false;
    }

    public boolean canTarget() {
        return false;
    }

    protected void m_6138_() {
        if (this.m_6094_()) {
            super.m_6138_();
        } else if (!this.f_19853_.f_46443_) {
            List list = this.m_9236_().m_45933_((Entity)this, this.m_20191_().m_82400_(0.5));
            for (Entity entity : list) {
                this.m_7324_(entity);
            }
        }
    }

    @Override
    protected void m_7324_(Entity entityIn) {
        Mob mob;
        if (!this.f_19853_.f_46443_ && this.getTrueOwner() != null && entityIn instanceof Mob && (mob = (Mob)entityIn).m_5448_() == this.getTrueOwner() && this.m_142066_()) {
            mob.m_6710_((LivingEntity)this);
        }
    }

    @Override
    public void m_7334_(Entity entityIn) {
    }

    public void m_6478_(MoverType p_213315_1_, Vec3 p_213315_2_) {
    }

    public int getAgeSpeed() {
        return 1;
    }

    public AABB getInitialBB() {
        return this.m_6095_().m_20680_().m_20393_(this.m_20182_());
    }

    public boolean canSpawn(Level level) {
        return level.m_45772_(this.getInitialBB().m_82406_(0.25)) && level.m_183134_((Entity)this, this.getInitialBB().m_82406_(0.25)).isEmpty();
    }

    public void m_7601_(BlockState p_20006_, Vec3 p_20007_) {
        super.m_7601_(p_20006_, Vec3.f_82478_);
    }

    @Override
    public void m_8107_() {
        super.m_8107_();
        if (!this.m_20068_()) {
            MobUtil.moveDownToGround((Entity)this);
        }
        if (this.isEmerging() && !this.f_19853_.f_46443_) {
            this.setAge(this.getAge() + this.getAgeSpeed());
            this.f_19853_.m_7605_((Entity)this, (byte)4);
            for (AbstractMonolith abstractMonolith : this.f_19853_.m_45976_(AbstractMonolith.class, this.m_20191_())) {
                if (abstractMonolith == this) continue;
                this.m_146870_();
            }
        }
    }

    @Override
    public void mobSense() {
        if (this.canTarget()) {
            super.mobSense();
        }
    }

    public void m_7822_(byte pId) {
        if (pId == 4) {
            this.setAge(this.getAge() + this.getAgeSpeed());
        } else if (pId == 5) {
            this.setAge(this.getAge() - this.getAgeSpeed());
        } else {
            super.m_7822_(pId);
        }
    }

    public EntityDimensions m_6972_(Pose p_33113_) {
        float i = (float)this.getAge() / AbstractMonolith.getEmergingTime();
        EntityDimensions entitydimensions = super.m_6972_(p_33113_);
        return entitydimensions.m_20390_(1.0f, i);
    }

    public Crackiness getCrackiness() {
        return Crackiness.byFraction(this.m_21223_() / this.m_21233_());
    }

    public static enum Crackiness {
        NONE(1.0f),
        LOW(0.75f),
        MEDIUM(0.5f),
        HIGH(0.25f);

        private static final List<Crackiness> BY_DAMAGE;
        private final float fraction;

        private Crackiness(float p_28900_) {
            this.fraction = p_28900_;
        }

        public static Crackiness byFraction(float p_28902_) {
            for (Crackiness irongolem$crackiness : BY_DAMAGE) {
                if (!(p_28902_ < irongolem$crackiness.fraction)) continue;
                return irongolem$crackiness;
            }
            return NONE;
        }

        static {
            BY_DAMAGE = (List)Stream.of(Crackiness.values()).sorted(Comparator.comparingDouble(p_28904_ -> p_28904_.fraction)).collect(ImmutableList.toImmutableList());
        }
    }
}

