/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.common.entities.hostile;

import com.Polarice3.Goety.api.entities.ICustomAttributes;
import com.Polarice3.Goety.common.entities.hostile.SkullLord;
import com.Polarice3.Goety.common.entities.projectiles.HauntedSkullProjectile;
import com.Polarice3.Goety.common.items.ModItems;
import com.Polarice3.Goety.config.AttributesConfig;
import com.Polarice3.Goety.utils.EntityFinder;
import com.Polarice3.Goety.utils.MobUtil;
import java.util.EnumSet;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.players.OldUsersConverter;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.monster.AbstractSkeleton;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.phys.Vec3;

public class BoneLord
extends AbstractSkeleton
implements ICustomAttributes {
    private static final EntityDataAccessor<Optional<UUID>> SKULL_LORD = SynchedEntityData.m_135353_(BoneLord.class, (EntityDataSerializer)EntityDataSerializers.f_135041_);
    protected static final EntityDataAccessor<Integer> SKULL_LORD_CLIENT_ID = SynchedEntityData.m_135353_(BoneLord.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);

    public BoneLord(EntityType<? extends AbstractSkeleton> type, Level p_i48555_2_) {
        super(type, p_i48555_2_);
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(8, (Goal)new FollowHeadGoal(this));
    }

    public static AttributeSupplier.Builder setCustomAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, ((Double)AttributesConfig.BoneLordHealth.get()).doubleValue()).m_22268_(Attributes.f_22277_, 35.0).m_22268_(Attributes.f_22279_, 0.25).m_22268_(Attributes.f_22281_, ((Double)AttributesConfig.BoneLordDamage.get()).doubleValue()).m_22268_(Attributes.f_22278_, 0.0);
    }

    @Override
    public void setConfigurableAttributes() {
        MobUtil.setBaseAttributes(this.m_21051_(Attributes.f_22276_), (Double)AttributesConfig.BoneLordHealth.get());
        MobUtil.setBaseAttributes(this.m_21051_(Attributes.f_22281_), (Double)AttributesConfig.BoneLordDamage.get());
    }

    protected void m_213945_(RandomSource randomSource, DifficultyInstance pDifficulty) {
        super.m_213945_(randomSource, pDifficulty);
        if (pDifficulty.m_19049_((float)Difficulty.EASY.ordinal())) {
            this.m_8061_(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)ModItems.FROZEN_BLADE.get()));
        } else {
            this.m_8061_(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)Items.f_42388_));
        }
        this.m_8061_(EquipmentSlot.CHEST, new ItemStack((ItemLike)ModItems.CURSED_PALADIN_CHESTPLATE.get()));
        this.m_8061_(EquipmentSlot.LEGS, new ItemStack((ItemLike)ModItems.CURSED_PALADIN_LEGGINGS.get()));
        this.m_8061_(EquipmentSlot.FEET, new ItemStack((ItemLike)ModItems.CURSED_PALADIN_BOOTS.get()));
        this.m_8061_(EquipmentSlot.HEAD, new ItemStack((ItemLike)ModItems.CURSED_PALADIN_HELMET.get()));
    }

    protected void populateDefaultEquipmentEnchantments(DifficultyInstance pDifficulty) {
        if (pDifficulty.m_19048_() != Difficulty.PEACEFUL && pDifficulty.m_19048_() != Difficulty.EASY) {
            ItemStack itemstack;
            for (EquipmentSlot equipmentslottype : EquipmentSlot.values()) {
                ItemStack itemstack2;
                if (equipmentslottype.m_20743_() != EquipmentSlot.Type.ARMOR || (itemstack2 = this.m_6844_(equipmentslottype)).m_41619_()) continue;
                Map map = EnchantmentHelper.m_44831_((ItemStack)itemstack2);
                switch (pDifficulty.m_19048_()) {
                    case NORMAL: {
                        map.putIfAbsent(Enchantments.f_44965_, 2);
                    }
                    case HARD: {
                        map.putIfAbsent(Enchantments.f_44965_, 3);
                    }
                }
                EnchantmentHelper.m_44865_((Map)map, (ItemStack)itemstack2);
                this.m_8061_(equipmentslottype, itemstack2);
            }
            if (pDifficulty.m_19048_() == Difficulty.HARD && !(itemstack = this.m_6844_(EquipmentSlot.MAINHAND)).m_41619_()) {
                this.m_8061_(EquipmentSlot.MAINHAND, EnchantmentHelper.m_220292_((RandomSource)this.f_19796_, (ItemStack)this.m_21205_(), (int)30, (boolean)false));
            }
        }
    }

    public boolean m_142535_(float p_148711_, float p_148712_, DamageSource p_148713_) {
        return false;
    }

    public void m_8119_() {
        super.m_8119_();
        if (!this.f_19853_.f_46443_) {
            if (this.getSkullLord() == null || this.getSkullLord().m_21224_()) {
                if (this.f_19797_ % 100 == 0 && this.f_19797_ > 100) {
                    this.m_146870_();
                }
            } else {
                AttributeInstance knockResist = this.m_21051_(Attributes.f_22278_);
                if (this.getSkullLord().isHalfHealth()) {
                    if (knockResist != null) {
                        knockResist.m_22100_(1.0);
                    }
                } else if (knockResist != null && knockResist.m_22115_() > 0.0) {
                    knockResist.m_22100_(0.0);
                }
                if (this.m_5830_()) {
                    this.m_20219_(this.getSkullLord().m_20182_());
                }
                if (this.getSkullLord().m_5448_() != null) {
                    this.m_6710_(this.getSkullLord().m_5448_());
                }
            }
        }
    }

    protected boolean m_21527_() {
        return false;
    }

    public boolean m_6469_(DamageSource pSource, float pAmount) {
        if (pSource.m_7639_() == this.getSkullLord() && pSource.m_7640_() instanceof HauntedSkullProjectile) {
            return false;
        }
        return super.m_6469_(pSource, pAmount);
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor pLevel, DifficultyInstance pDifficulty, MobSpawnType pReason, @Nullable SpawnGroupData pSpawnData, @Nullable CompoundTag pDataTag) {
        this.m_213945_(pLevel.m_213780_(), pDifficulty);
        this.populateDefaultEquipmentEnchantments(pDifficulty);
        this.m_21553_(false);
        for (EquipmentSlot equipmentslottype : EquipmentSlot.values()) {
            this.m_21409_(equipmentslottype, 0.0f);
        }
        return super.m_6518_(pLevel, pDifficulty, pReason, pSpawnData, pDataTag);
    }

    public boolean m_7307_(Entity entityIn) {
        if (super.m_7307_(entityIn)) {
            return true;
        }
        if (entityIn instanceof Monster && ((Monster)entityIn).m_6336_() == MobType.f_21641_) {
            return this.m_5647_() == null && entityIn.m_5647_() == null;
        }
        return false;
    }

    public void m_7601_(BlockState pState, Vec3 pMotionMultiplier) {
        if (!pState.m_60713_(Blocks.f_50033_)) {
            super.m_7601_(pState, pMotionMultiplier);
        }
    }

    public boolean m_6128_() {
        return true;
    }

    protected SoundEvent m_7515_() {
        return SoundEvents.f_12423_;
    }

    protected SoundEvent m_7975_(DamageSource pDamageSource) {
        return SoundEvents.f_12381_;
    }

    protected SoundEvent m_5592_() {
        return SoundEvents.f_12424_;
    }

    protected SoundEvent m_7878_() {
        return SoundEvents.f_12383_;
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(SKULL_LORD, Optional.empty());
        this.f_19804_.m_135372_(SKULL_LORD_CLIENT_ID, (Object)-1);
    }

    public void m_7378_(CompoundTag pCompound) {
        UUID uuid;
        super.m_7378_(pCompound);
        if (pCompound.m_128403_("skullLord")) {
            uuid = pCompound.m_128342_("skullLord");
        } else {
            String s = pCompound.m_128461_("skullLord");
            uuid = OldUsersConverter.m_11083_((MinecraftServer)this.m_20194_(), (String)s);
        }
        if (uuid != null) {
            try {
                this.setSkullLordUUID(uuid);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (pCompound.m_128441_("SkullLordClient")) {
            this.setSkullLordClientId(pCompound.m_128451_("SkullLordClient"));
        }
        this.setConfigurableAttributes();
    }

    public void m_7380_(CompoundTag pCompound) {
        super.m_7380_(pCompound);
        if (this.getSkullLordUUID() != null) {
            pCompound.m_128362_("skullLord", this.getSkullLordUUID());
        }
        if (this.getSkullLordClientId() > -1) {
            pCompound.m_128405_("SkullLordClient", this.getSkullLordClientId());
        }
    }

    @Nullable
    public SkullLord getSkullLord() {
        SkullLord skullLord;
        Entity entity;
        if (!this.f_19853_.f_46443_) {
            SkullLord skullLord2;
            UUID uuid = this.getSkullLordUUID();
            LivingEntity livingEntity = EntityFinder.getLivingEntityByUuiD(uuid);
            return livingEntity instanceof SkullLord ? (skullLord2 = (SkullLord)livingEntity) : null;
        }
        int id = this.getSkullLordClientId();
        return id <= -1 ? null : ((entity = this.f_19853_.m_6815_(id)) instanceof SkullLord ? (skullLord = (SkullLord)entity) : null);
    }

    @Nullable
    public UUID getSkullLordUUID() {
        return ((Optional)this.f_19804_.m_135370_(SKULL_LORD)).orElse(null);
    }

    public void setSkullLordUUID(UUID uuid) {
        this.f_19804_.m_135381_(SKULL_LORD, Optional.ofNullable(uuid));
    }

    public int getSkullLordClientId() {
        return (Integer)this.f_19804_.m_135370_(SKULL_LORD_CLIENT_ID);
    }

    public void setSkullLordClientId(int id) {
        this.f_19804_.m_135381_(SKULL_LORD_CLIENT_ID, (Object)id);
    }

    public void setSkullLord(SkullLord skullLord) {
        this.setSkullLordUUID(skullLord.m_20148_());
        this.setSkullLordClientId(skullLord.m_19879_());
    }

    public void m_6667_(DamageSource p_21014_) {
        Mob mob;
        Entity entity;
        if (this.f_19853_ instanceof ServerLevel && this.getSkullLord() != null && (entity = p_21014_.m_7639_()) instanceof Mob && (mob = (Mob)entity).m_5448_() == this) {
            mob.m_6710_((LivingEntity)this.getSkullLord());
        }
        super.m_6667_(p_21014_);
    }

    public static class FollowHeadGoal
    extends Goal {
        private final BoneLord boneLord;
        private LivingEntity owner;
        private final PathNavigation navigation;
        private int timeToRecalcPath;
        private float oldWaterCost;

        public FollowHeadGoal(BoneLord boneLord) {
            this.boneLord = boneLord;
            this.navigation = boneLord.m_21573_();
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        public boolean m_8036_() {
            SkullLord livingentity = this.boneLord.getSkullLord();
            if (livingentity == null) {
                return false;
            }
            if (this.boneLord.m_20280_((Entity)livingentity) < 100.0) {
                return false;
            }
            if (this.boneLord.m_5912_()) {
                return false;
            }
            this.owner = livingentity;
            return true;
        }

        public boolean m_8045_() {
            if (this.navigation.m_26571_()) {
                return false;
            }
            if (this.boneLord.m_5912_()) {
                return false;
            }
            return !(this.boneLord.m_20280_((Entity)this.owner) <= 4.0);
        }

        public void m_8056_() {
            this.timeToRecalcPath = 0;
            this.oldWaterCost = this.boneLord.m_21439_(BlockPathTypes.WATER);
            this.boneLord.m_21441_(BlockPathTypes.WATER, 0.0f);
        }

        public void m_8041_() {
            this.owner = null;
            this.navigation.m_26573_();
            this.boneLord.m_21441_(BlockPathTypes.WATER, this.oldWaterCost);
        }

        public void m_8037_() {
            this.boneLord.m_21563_().m_24960_((Entity)this.owner, 10.0f, (float)this.boneLord.m_8132_());
            if (--this.timeToRecalcPath <= 0) {
                this.timeToRecalcPath = 10;
                if (!this.boneLord.m_20159_()) {
                    this.navigation.m_5624_((Entity)this.owner, 1.0);
                }
            }
        }
    }
}

