/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.common.entities.ally.illager;

import com.Polarice3.Goety.common.entities.ai.IllagerChestGoal;
import com.Polarice3.Goety.common.entities.ally.illager.AbstractIllagerServant;
import com.Polarice3.Goety.common.entities.ally.illager.VindicatorServant;
import com.Polarice3.Goety.common.entities.neutral.Owned;
import com.Polarice3.Goety.utils.BlockFinder;
import java.util.EnumSet;
import java.util.List;
import java.util.Optional;
import net.minecraft.commands.arguments.EntityAnchorArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.FurnaceBlock;
import net.minecraft.world.level.block.SmokerBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class VindicatorChefServant
extends VindicatorServant {
    protected static final EntityDataAccessor<Optional<BlockPos>> FURNACE_POS = SynchedEntityData.m_135353_(VindicatorChefServant.class, (EntityDataSerializer)EntityDataSerializers.f_135039_);
    protected static final EntityDataAccessor<Boolean> COOKING = SynchedEntityData.m_135353_(VindicatorChefServant.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);

    public VindicatorChefServant(EntityType<? extends Owned> type, Level worldIn) {
        super(type, worldIn);
    }

    @Override
    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(2, (Goal)new CookingGoal(this));
    }

    @Override
    public void throwGoal() {
        this.f_21345_.m_25352_(3, (Goal)new ChefThrowExcessFoodGoal(this));
        this.f_21345_.m_25352_(3, (Goal)new AbstractIllagerServant.ThrowRottenFleshGoal(this));
        this.f_21345_.m_25352_(4, (Goal)new AbstractIllagerServant.FeedRottenFleshGoal(this));
        this.f_21345_.m_25352_(5, (Goal)new AbstractIllagerServant.ThrowLootGoal(this));
    }

    @Override
    public void chestGoal() {
        super.chestGoal();
        this.f_21345_.m_25352_(6, (Goal)new LootUncookedFoodGoal(this));
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(FURNACE_POS, Optional.empty());
        this.f_19804_.m_135372_(COOKING, (Object)false);
    }

    @Override
    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        if (this.getFurnacePos().isPresent()) {
            compound.m_128365_("FurnacePos", (Tag)NbtUtils.m_129224_((BlockPos)this.getFurnacePos().get()));
        }
    }

    @Override
    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        if (compound.m_128441_("FurnacePos")) {
            this.setFurnacePos(NbtUtils.m_129239_((CompoundTag)compound.m_128469_("FurnacePos")));
        }
    }

    public Optional<BlockPos> getFurnacePos() {
        return (Optional)this.f_19804_.m_135370_(FURNACE_POS);
    }

    public void setFurnacePos(@Nullable BlockPos trainPos) {
        this.f_19804_.m_135381_(FURNACE_POS, Optional.ofNullable(trainPos));
    }

    public void setCooking(boolean cooking) {
        this.f_19804_.m_135381_(COOKING, (Object)cooking);
    }

    public boolean isCooking() {
        return (Boolean)this.f_19804_.m_135370_(COOKING);
    }

    @Override
    public AbstractIllagerServant.IllagerServantArmPose getArmPose() {
        if (this.m_5912_() || this.isCooking()) {
            return AbstractIllagerServant.IllagerServantArmPose.ATTACKING;
        }
        return this.isCelebrating() ? AbstractIllagerServant.IllagerServantArmPose.CELEBRATING : AbstractIllagerServant.IllagerServantArmPose.CROSSED;
    }

    @Override
    public boolean validFood(ItemStack itemStack) {
        FoodProperties foodProperties = itemStack.getFoodProperties((LivingEntity)this);
        if (foodProperties == null) {
            return false;
        }
        return foodProperties.m_38749_().isEmpty() || foodProperties.m_38746_() || itemStack.m_150930_(Items.f_42583_);
    }

    @Override
    public boolean canEat(ItemStack itemStack) {
        FoodProperties foodProperties = itemStack.getFoodProperties((LivingEntity)this);
        if (foodProperties == null) {
            return false;
        }
        if (foodProperties.m_38746_() && foodProperties.m_38744_() <= 3) {
            return false;
        }
        return super.canEat(itemStack);
    }

    public static ItemStack canCook(ItemStack stack, ServerLevel level) {
        return level.m_7465_().m_44015_(RecipeType.f_44108_, (Container)new SimpleContainer(new ItemStack[]{stack}), (Level)level).map(smeltingRecipe -> smeltingRecipe.m_8043_(level.m_9598_())).filter(itemStack -> !itemStack.m_41619_()).orElse(ItemStack.f_41583_);
    }

    @Override
    public InteractionResult m_6071_(Player pPlayer, InteractionHand pHand) {
        Optional optional;
        if (this.getTrueOwner() != null && pPlayer == this.getTrueOwner() && this.countFoodPointsInInventory() != 0 && pHand == InteractionHand.MAIN_HAND && pPlayer.m_21205_().m_41619_() && (pPlayer.m_6144_() || pPlayer.m_6047_()) && (optional = this.itemsInInv(this::canEat).stream().findFirst()).isPresent()) {
            pPlayer.m_21008_(pHand, ((ItemStack)optional.get()).m_278832_());
            this.m_35311_().m_6596_();
            if (this.m_7515_() != null) {
                this.m_5496_(this.m_7515_(), 1.0f, 1.25f);
            }
            this.f_19853_.m_6269_(pPlayer, (Entity)pPlayer, SoundEvents.f_12019_, SoundSource.PLAYERS, 1.0f, 1.0f);
            return InteractionResult.SUCCESS;
        }
        return super.m_6071_(pPlayer, pHand);
    }

    public static class CookingGoal
    extends Goal {
        public static int COOK_TIME = 100;
        public VindicatorChefServant illager;
        protected int tryTicks;
        @Nullable
        public BlockPos furnace;
        public int workTick;
        public boolean playSound = false;

        public CookingGoal(VindicatorChefServant illager) {
            this.illager = illager;
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        public boolean m_8036_() {
            ServerLevel serverLevel;
            Level level = this.illager.f_19853_;
            if (level instanceof ServerLevel && !this.illager.itemsInInv(arg_0 -> CookingGoal.lambda$canUse$0(serverLevel = (ServerLevel)level, arg_0)).isEmpty()) {
                this.furnace = this.findFurnace();
                if (this.furnace != null) {
                    this.illager.setFurnacePos(this.furnace);
                }
                return this.furnace != null && this.illager.m_5448_() == null;
            }
            return false;
        }

        public boolean m_8045_() {
            ServerLevel serverLevel;
            Level level = this.illager.f_19853_;
            if (level instanceof ServerLevel && !this.illager.itemsInInv(arg_0 -> CookingGoal.lambda$canContinueToUse$1(serverLevel = (ServerLevel)level, arg_0)).isEmpty() && this.furnace != null && this.getNearbyChefs((Level)serverLevel, new AABB(this.furnace).m_82400_(4.0), this.furnace).isEmpty() && this.tryTicks <= 1200) {
                BlockState blockState = this.illager.f_19853_.m_8055_(this.furnace);
                return (blockState.m_60734_() instanceof FurnaceBlock || blockState.m_60734_() instanceof SmokerBlock) && super.m_8045_();
            }
            return false;
        }

        public void m_8056_() {
            this.moveMobToBlock();
            this.tryTicks = 0;
        }

        protected void moveMobToBlock() {
            if (this.furnace == null) {
                this.m_8041_();
                return;
            }
            this.illager.m_21573_().m_26519_((double)this.furnace.m_123341_() + 0.5, (double)(this.furnace.m_123342_() + 1), (double)this.furnace.m_123343_() + 0.5, 0.75);
        }

        public boolean m_183429_() {
            return true;
        }

        public void m_8041_() {
            this.furnace = null;
            this.illager.setFurnacePos(null);
            this.tryTicks = 0;
            this.workTick = 0;
            this.illager.setCooking(false);
        }

        public void m_8037_() {
            if (this.furnace == null) {
                this.m_8041_();
                return;
            }
            Level level = this.illager.f_19853_;
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                if (this.illager.m_20238_(Vec3.m_82512_((Vec3i)this.furnace)) > (double)Mth.m_144944_((int)2)) {
                    ++this.tryTicks;
                    if (this.shouldRecalculatePath()) {
                        this.illager.m_21573_().m_26519_((double)this.furnace.m_123341_() + 0.5, (double)this.furnace.m_123342_(), (double)this.furnace.m_123343_() + 0.5, 0.75);
                    }
                    if (this.illager.isCooking()) {
                        this.illager.setCooking(false);
                    }
                } else {
                    this.illager.m_21573_().m_26573_();
                    this.illager.m_7618_(EntityAnchorArgument.Anchor.EYES, Vec3.m_82512_((Vec3i)this.furnace));
                    this.tryTicks = 0;
                    ++this.workTick;
                    if (!this.illager.isCooking()) {
                        this.illager.setCooking(true);
                    }
                    if (!this.playSound) {
                        try {
                            BlockState blockState = this.illager.f_19853_.m_8055_(this.furnace);
                            if (blockState.m_60734_() instanceof FurnaceBlock) {
                                this.illager.f_19853_.m_6263_(null, (double)((float)this.furnace.m_123341_() + 0.5f), (double)this.furnace.m_123342_(), (double)((float)this.furnace.m_123343_() + 0.5f), SoundEvents.f_11907_, SoundSource.BLOCKS, 1.0f, 1.0f);
                            } else if (blockState.m_60734_() instanceof SmokerBlock) {
                                this.illager.f_19853_.m_6263_(null, (double)((float)this.furnace.m_123341_() + 0.5f), (double)this.furnace.m_123342_(), (double)((float)this.furnace.m_123343_() + 0.5f), SoundEvents.f_12472_, SoundSource.BLOCKS, 1.0f, 1.0f);
                            }
                        }
                        catch (NullPointerException exception) {
                            this.m_8041_();
                            return;
                        }
                        this.playSound = true;
                    }
                    if (this.workTick > COOK_TIME) {
                        Optional optional = this.illager.itemsInInv(itemStack -> VindicatorChefServant.canCook(itemStack, serverLevel).m_41614_()).stream().findFirst();
                        if (optional.isPresent()) {
                            ItemStack itemStack2 = CookingGoal.smelt(((ItemStack)optional.get()).m_41620_(1), serverLevel);
                            if (this.illager.m_35311_().m_19183_(itemStack2)) {
                                this.illager.m_35311_().m_19173_(itemStack2);
                            }
                        }
                        this.playSound = false;
                        this.workTick = 0;
                    }
                }
            }
        }

        public boolean shouldRecalculatePath() {
            return this.tryTicks % 40 == 0;
        }

        public static ItemStack smelt(ItemStack stack, ServerLevel level) {
            return level.m_7465_().m_44015_(RecipeType.f_44108_, (Container)new SimpleContainer(new ItemStack[]{stack}), (Level)level).map(smeltingRecipe -> smeltingRecipe.m_8043_(level.m_9598_())).filter(itemStack -> !itemStack.m_41619_()).map(itemStack -> {
                ItemStack copy = itemStack.m_41777_();
                copy.m_41764_(stack.m_41613_() * itemStack.m_41613_());
                return copy;
            }).orElse(stack);
        }

        public List<VindicatorChefServant> getNearbyChefs(Level level, AABB aabb, BlockPos blockPos) {
            return level.m_6443_(VindicatorChefServant.class, aabb, chef -> chef.getFurnacePos().isPresent() && BlockFinder.samePos(chef.getFurnacePos().get(), blockPos) && chef.isCooking() && chef != this.illager);
        }

        public BlockPos findFurnace() {
            int i = 8;
            int j = 1;
            int k = 0;
            while (k <= j) {
                for (int l = 0; l < i; ++l) {
                    int i1 = 0;
                    while (i1 <= l) {
                        int j1;
                        int n = j1 = i1 < l && i1 > -l ? l : 0;
                        while (j1 <= l) {
                            BlockPos blockPos1 = this.illager.m_20183_().m_7918_(i1, k - 1, j1);
                            BlockState blockState = this.illager.f_19853_.m_8055_(blockPos1);
                            if ((blockState.m_60734_() instanceof FurnaceBlock || blockState.m_60734_() instanceof SmokerBlock) && this.getNearbyChefs(this.illager.f_19853_, new AABB(blockPos1).m_82400_(4.0), blockPos1).isEmpty()) {
                                return blockPos1;
                            }
                            j1 = j1 > 0 ? -j1 : 1 - j1;
                        }
                        i1 = i1 > 0 ? -i1 : 1 - i1;
                    }
                }
                k = k > 0 ? -k : 1 - k;
            }
            return null;
        }

        private static /* synthetic */ boolean lambda$canContinueToUse$1(ServerLevel serverLevel, ItemStack itemStack) {
            return VindicatorChefServant.canCook(itemStack, serverLevel).m_41614_();
        }

        private static /* synthetic */ boolean lambda$canUse$0(ServerLevel serverLevel, ItemStack itemStack) {
            return VindicatorChefServant.canCook(itemStack, serverLevel).m_41614_();
        }
    }

    public static class ChefThrowExcessFoodGoal
    extends AbstractIllagerServant.GiveExcessFoodGoal {
        public ChefThrowExcessFoodGoal(AbstractIllagerServant illager) {
            super(illager);
            this.predicate = itemStack -> {
                ServerLevel serverLevel;
                Level patt14863$temp = illager.f_19853_;
                return patt14863$temp instanceof ServerLevel && !VindicatorChefServant.canCook(itemStack, serverLevel = (ServerLevel)patt14863$temp).m_41614_();
            };
        }
    }

    public static class LootUncookedFoodGoal
    extends IllagerChestGoal {
        public LootUncookedFoodGoal(AbstractIllagerServant illager) {
            super(illager);
            this.chestPredicate = itemStack -> {
                ServerLevel serverLevel;
                Level patt15253$temp = illager.f_19853_;
                return patt15253$temp instanceof ServerLevel && VindicatorChefServant.canCook(itemStack, serverLevel = (ServerLevel)patt15253$temp).m_41614_();
            };
        }

        @Override
        public boolean m_8036_() {
            if (this.illager.getChestPos() == null) {
                return false;
            }
            if (this.illager.getBoundPos() != null && this.illager.getChestPos() != null && !this.illager.isWithinGuard(this.illager.getChestPos())) {
                return false;
            }
            if (this.illager.getChestLevel() != this.illager.f_19853_.m_46472_()) {
                return false;
            }
            if (!this.isChestRaidable((LevelReader)this.illager.f_19853_, this.illager.getChestPos())) {
                return false;
            }
            if (this.illager.itemsInInv(itemStack -> {
                ServerLevel serverLevel;
                Level patt16173$temp = this.illager.f_19853_;
                return patt16173$temp instanceof ServerLevel && VindicatorChefServant.canCook(itemStack, serverLevel = (ServerLevel)patt16173$temp).m_41614_();
            }).size() >= 24) {
                return false;
            }
            return super.m_8036_();
        }

        @Override
        public void chestInteract(Container container) {
            for (ItemStack itemStack : this.getItems(container)) {
                if (!this.illager.m_35311_().m_19183_(itemStack)) continue;
                this.illager.m_35311_().m_19173_(itemStack.m_278832_());
                container.m_6596_();
                break;
            }
        }
    }
}

