/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.common.entities.ally.illager;

import com.Polarice3.Goety.api.entities.IGolem;
import com.Polarice3.Goety.common.entities.ModEntityType;
import com.Polarice3.Goety.common.entities.ally.Summoned;
import com.Polarice3.Goety.common.entities.ally.illager.RaiderServant;
import com.Polarice3.Goety.init.ModSounds;
import com.Polarice3.Goety.utils.MobUtil;
import java.util.EnumSet;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LeapAtTargetGoal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.AbstractIllager;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.raid.Raider;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeMod;

public class Ravaged
extends RaiderServant {
    private static final UUID SPEED_BOOST_UUID = UUID.fromString("B9766B59-9566-4402-BC1F-2EE2A276D836");
    private static final AttributeModifier SPEED_BOOST = new AttributeModifier(SPEED_BOOST_UUID, "Aggressive speed boost", 0.5, AttributeModifier.Operation.MULTIPLY_BASE);
    private static final EntityDataAccessor<Integer> ID_SIZE = SynchedEntityData.m_135353_(Ravaged.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Boolean> DATA_CONVERSION_ID = SynchedEntityData.m_135353_(Ravaged.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private int bitingTick;
    private int excessFood = 0;
    private int conversionTime;

    public Ravaged(EntityType<? extends Summoned> type, Level worldIn) {
        super(type, worldIn);
    }

    @Override
    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(8, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(8, (Goal)new RandomLookAroundGoal((Mob)this));
        this.applyEntityAI();
    }

    protected void applyEntityAI() {
        this.f_21345_.m_25352_(2, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.0, false));
        this.f_21345_.m_25352_(2, (Goal)new LeapAtTargetGoal((Mob)this, 0.6f));
        this.f_21345_.m_25352_(3, (Goal)new FeedGoal());
        this.f_21346_.m_25352_(4, new VillagerAttackGoal(this));
    }

    public static AttributeSupplier.Builder setCustomAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 20.0).m_22268_(Attributes.f_22277_, 35.0).m_22268_(Attributes.f_22279_, (double)0.23f).m_22268_(Attributes.f_22281_, 3.0).m_22268_((Attribute)ForgeMod.STEP_HEIGHT_ADDITION.get(), 1.0).m_22268_(Attributes.f_22284_, 2.0);
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(ID_SIZE, (Object)0);
        this.m_20088_().m_135372_(DATA_CONVERSION_ID, (Object)false);
    }

    public void setRavagedSize(int p_33109_) {
        this.f_19804_.m_135381_(ID_SIZE, (Object)Mth.m_14045_((int)p_33109_, (int)0, (int)64));
        this.excessFood = 0;
    }

    private void updateSizeInfo() {
        this.m_6210_();
        this.m_21051_(Attributes.f_22281_).m_22100_(3.0 + (double)this.getRavagedSize());
    }

    public int getRavagedSize() {
        return (Integer)this.f_19804_.m_135370_(ID_SIZE);
    }

    public void m_7350_(EntityDataAccessor<?> p_33134_) {
        if (ID_SIZE.equals(p_33134_)) {
            this.updateSizeInfo();
        }
        super.m_7350_(p_33134_);
    }

    @Override
    public void m_7380_(CompoundTag p_33353_) {
        super.m_7380_(p_33353_);
        p_33353_.m_128405_("BitingTick", this.bitingTick);
        p_33353_.m_128405_("ExcessFood", this.excessFood);
        p_33353_.m_128405_("ConversionTime", this.isConverting() ? this.conversionTime : -1);
        p_33353_.m_128405_("Size", this.getRavagedSize());
    }

    @Override
    public void m_7378_(CompoundTag p_33344_) {
        super.m_7378_(p_33344_);
        this.bitingTick = p_33344_.m_128451_("BitingTick");
        this.excessFood = p_33344_.m_128451_("ExcessFood");
        if (p_33344_.m_128425_("ConversionTime", 99) && p_33344_.m_128451_("ConversionTime") > -1) {
            this.startConversion(p_33344_.m_128451_("StrayConversionTime"));
        }
        this.setRavagedSize(p_33344_.m_128451_("Size"));
    }

    public boolean isConverting() {
        return (Boolean)this.m_20088_().m_135370_(DATA_CONVERSION_ID);
    }

    public SoundEvent m_7515_() {
        return (SoundEvent)ModSounds.RAVAGED_AMBIENT.get();
    }

    public SoundEvent m_7975_(DamageSource damageSourceIn) {
        return (SoundEvent)ModSounds.RAVAGED_HURT.get();
    }

    public SoundEvent m_5592_() {
        return (SoundEvent)ModSounds.RAVAGED_DEATH.get();
    }

    public SoundEvent getStepSound() {
        if (this.getRavagedSize() < 4) {
            return (SoundEvent)ModSounds.RAVAGED_STEP.get();
        }
        return (SoundEvent)ModSounds.RAVAGED_BIG_STEP.get();
    }

    protected void m_7355_(BlockPos p_34316_, BlockState p_34317_) {
        this.m_5496_(this.getStepSound(), 0.15f + (float)this.getRavagedSize() / 5.0f, this.m_6100_());
    }

    @Override
    public SoundEvent getCelebrateSound() {
        return (SoundEvent)ModSounds.RAVAGED_AMBIENT.get();
    }

    protected float m_6121_() {
        return Math.min(10.0f, super.m_6121_() + (float)this.getRavagedSize() / 2.0f);
    }

    public float m_6100_() {
        return Math.max(0.2f, super.m_6100_() - (float)this.getRavagedSize() / 10.0f);
    }

    public int m_8085_() {
        return 45;
    }

    @Override
    public void convertNewEquipment(Entity entity) {
        for (EquipmentSlot equipmentSlot : EquipmentSlot.values()) {
            this.dropEquipment(equipmentSlot, this.m_6844_(equipmentSlot));
            this.m_8061_(equipmentSlot, ItemStack.f_41583_);
        }
    }

    @Override
    public boolean canJoinPatrol() {
        return false;
    }

    @Override
    public void m_8107_() {
        super.m_8107_();
        if (this.m_6084_()) {
            int k;
            int j;
            int i;
            BlockPos pos;
            BlockState blockstate;
            AttributeInstance speed = this.m_21051_(Attributes.f_22279_);
            if (speed != null) {
                if (this.m_5448_() != null) {
                    if (!speed.m_22109_(SPEED_BOOST)) {
                        speed.m_22125_(SPEED_BOOST);
                    }
                } else if (speed.m_22109_(SPEED_BOOST)) {
                    speed.m_22130_(SPEED_BOOST);
                }
            }
            if (this.bitingTick > 0) {
                --this.bitingTick;
            }
            if (!this.f_19853_.f_46443_ && this.m_6084_() && !this.m_21525_()) {
                if (this.isConverting()) {
                    --this.conversionTime;
                    if (this.conversionTime < 0) {
                        this.doRavagerConversion();
                    }
                } else if (this.m_21133_(Attributes.f_22276_) >= 75.0) {
                    this.startConversion(300);
                }
            }
            if (this.f_19853_.f_46443_ && this.getRavagedSize() >= 4 && this.m_20184_().m_165925_() > 2.500000277905201E-7 && this.f_19796_.m_188503_(5) == 0 && !(blockstate = this.f_19853_.m_8055_(pos = new BlockPos(i = Mth.m_14107_((double)this.m_20185_()), j = Mth.m_14107_((double)(this.m_20186_() - (double)0.2f)), k = Mth.m_14107_((double)this.m_20189_())))).m_60795_()) {
                this.f_19853_.m_7106_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, blockstate).setPos(pos), this.m_20185_() + ((double)this.f_19796_.m_188501_() - 0.5) * (double)this.m_20205_(), this.m_20186_() + 0.1, this.m_20189_() + ((double)this.f_19796_.m_188501_() - 0.5) * (double)this.m_20205_(), 4.0 * ((double)this.f_19796_.m_188501_() - 0.5), 0.5, ((double)this.f_19796_.m_188501_() - 0.5) * 4.0);
            }
        }
    }

    private void startConversion(int p_149831_) {
        this.conversionTime = p_149831_;
        this.f_19804_.m_135381_(DATA_CONVERSION_ID, (Object)true);
    }

    public boolean isShaking() {
        return this.isConverting();
    }

    protected void doRavagerConversion() {
        LivingEntity livingEntity = this.getTrueOwner();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            MobUtil.convertTo((Entity)this, (EntityType)ModEntityType.MOD_RAVAGER.get(), false, player);
        } else {
            this.m_21406_((EntityType)ModEntityType.MOD_RAVAGER.get(), false);
        }
        if (!this.m_20067_()) {
            this.f_19853_.m_5898_(null, 1027, this.m_20183_(), 0);
        }
    }

    public int getBitingTick() {
        return this.bitingTick;
    }

    public int attackTotalTick() {
        return 10;
    }

    @Override
    public boolean m_7327_(Entity entityIn) {
        boolean flag = super.m_7327_(entityIn);
        if (flag) {
            this.bitingTick = this.attackTotalTick();
            if (entityIn instanceof AbstractVillager) {
                this.f_19853_.m_7605_((Entity)this, (byte)11);
                this.m_5496_((SoundEvent)ModSounds.RAVAGED_EAT.get(), this.m_6121_(), this.m_6100_());
            }
            this.f_19853_.m_7605_((Entity)this, (byte)4);
            this.m_5496_((SoundEvent)ModSounds.RAVAGED_BITE.get(), this.m_6121_(), this.m_6100_());
            float f = this.f_19853_.m_6436_(this.m_20183_()).m_19056_();
            if (this.m_6060_() && this.f_19796_.m_188501_() < f * 0.3f) {
                entityIn.m_20254_(2 * (int)f);
            }
        }
        return flag;
    }

    @Override
    public SpawnGroupData m_6518_(ServerLevelAccessor worldIn, DifficultyInstance difficultyIn, MobSpawnType reason, @Nullable SpawnGroupData spawnDataIn, @Nullable CompoundTag dataTag) {
        spawnDataIn = super.m_6518_(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
        return spawnDataIn;
    }

    public void m_7822_(byte p_33335_) {
        if (p_33335_ == 4) {
            this.bitingTick = this.attackTotalTick();
            this.m_5496_((SoundEvent)ModSounds.RAVAGED_BITE.get(), this.m_6121_(), this.m_6100_() * 2.0f);
        } else if (p_33335_ == 10) {
            this.bitingTick = this.attackTotalTick();
            this.m_5496_((SoundEvent)ModSounds.RAVAGED_EAT.get(), this.m_6121_(), this.m_6100_());
        } else if (p_33335_ == 11) {
            this.m_5496_((SoundEvent)ModSounds.RAVAGED_EAT.get(), this.m_6121_(), this.m_6100_());
        }
        super.m_7822_(p_33335_);
    }

    public boolean m_214076_(ServerLevel p_219160_, LivingEntity p_219161_) {
        boolean flag = super.m_214076_(p_219160_, p_219161_);
        if (p_219161_ instanceof AbstractVillager) {
            this.cannibalize(this.f_19796_.m_188503_(5) + 1);
        }
        if ((p_219161_ instanceof Raider || p_219161_ instanceof RaiderServant) && !(p_219161_ instanceof IGolem)) {
            this.cannibalize(this.f_19796_.m_188503_(2) + 1);
        }
        return flag;
    }

    @Override
    public boolean m_6469_(DamageSource p_34288_, float p_34289_) {
        LivingEntity living;
        Entity entity = p_34288_.m_7639_();
        if (entity instanceof LivingEntity && this.m_21040_(living = (LivingEntity)entity, TargetingConditions.f_26872_)) {
            this.m_6710_(living);
        }
        return super.m_6469_(p_34288_, p_34289_);
    }

    public EntityDimensions m_6972_(Pose p_33113_) {
        int i = this.getRavagedSize();
        EntityDimensions entitydimensions = super.m_6972_(p_33113_);
        float f = (entitydimensions.f_20377_ + 0.2f * (float)i) / entitydimensions.f_20377_;
        return entitydimensions.m_20388_(f);
    }

    public void cannibalize(int amount) {
        this.m_8035_();
        float heal = (float)amount * (10.0f / (float)this.getRavagedSize() + 1.0f);
        float excess = Mth.m_14036_((float)(this.m_21223_() + heal - this.m_21233_()), (float)0.0f, (float)12.0f);
        if ((double)(this.m_21223_() + heal) > (double)this.m_21233_() * 1.25 || (float)this.excessFood > this.m_21233_() && this.m_21223_() + heal > this.m_21233_()) {
            AttributeInstance maxHealth = this.m_21051_(Attributes.f_22276_);
            if (maxHealth != null && maxHealth.m_22135_() < 75.0) {
                this.setRavagedSize(this.getRavagedSize() + 1);
                maxHealth.m_22100_(Math.min(this.m_21133_(Attributes.f_22276_) + (double)excess, 75.0));
            }
        } else {
            this.excessFood += Mth.m_14143_((float)excess);
        }
        this.m_5634_(heal);
        this.m_5496_(SoundEvents.f_12321_, this.m_6121_(), this.m_6100_());
    }

    public class FeedGoal
    extends Goal {
        public ItemEntity food;
        public int feedingTime;

        public FeedGoal() {
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean m_8036_() {
            for (ItemEntity itemEntity : Ravaged.this.f_19853_.m_45976_(ItemEntity.class, Ravaged.this.m_20191_().m_82400_(32.0))) {
                if (!itemEntity.m_32055_().m_150930_(Items.f_42583_)) continue;
                this.food = itemEntity;
            }
            return this.food != null && !this.food.m_213877_() && Ravaged.this.f_20916_ <= 0;
        }

        public boolean m_8045_() {
            return this.food != null && Ravaged.this.f_20916_ <= 0 && this.feedingTime > 0 && !this.food.m_213877_();
        }

        private boolean hasEatenLongEnough() {
            return this.feedingTime <= 0;
        }

        public void m_8056_() {
            Ravaged.this.m_6710_(null);
            this.feedingTime = 40;
        }

        public void m_8041_() {
            this.feedingTime = 0;
            Ravaged.this.f_21344_.m_26573_();
        }

        public void m_8037_() {
            if (this.food != null && !this.food.m_213877_()) {
                if (Ravaged.this.m_20191_().m_82400_(0.85).m_82381_(this.food.m_20191_())) {
                    Level level;
                    Ravaged.this.f_21365_.m_148051_((Entity)this.food);
                    --this.feedingTime;
                    if (this.feedingTime % 5 == 0) {
                        Ravaged.this.m_5496_((SoundEvent)ModSounds.RAVAGED_EAT.get(), Ravaged.this.m_6121_(), Ravaged.this.m_6100_());
                        Ravaged.this.f_19853_.m_7605_((Entity)Ravaged.this, (byte)10);
                    }
                    if ((level = Ravaged.this.f_19853_) instanceof ServerLevel) {
                        ServerLevel serverLevel = (ServerLevel)level;
                        for (int i = 0; i < 5; ++i) {
                            Vec3 vec3 = new Vec3(((double)Ravaged.this.f_19796_.m_188501_() - 0.5) * 0.1, Math.random() * 0.1 + 0.1, 0.0);
                            vec3 = vec3.m_82496_(-Ravaged.this.m_146909_() * ((float)Math.PI / 180));
                            vec3 = vec3.m_82524_(-Ravaged.this.m_146908_() * ((float)Math.PI / 180));
                            serverLevel.m_8767_((ParticleOptions)new ItemParticleOption(ParticleTypes.f_123752_, this.food.m_32055_()), this.food.m_20185_(), this.food.m_20186_() + 0.25, this.food.m_20189_(), 1, vec3.f_82479_, vec3.f_82480_ + 0.05, vec3.f_82481_, 0.0);
                        }
                    }
                } else {
                    PathNavigation pathnavigation = Ravaged.this.m_21573_();
                    Path path = pathnavigation.m_148218_(BlockPos.m_274446_((Position)this.food.m_20182_()), 0, 8);
                    Ravaged.this.m_21573_().m_26536_(path, 1.5);
                }
            }
            if (this.hasEatenLongEnough() && this.food != null) {
                Ravaged.this.cannibalize(this.food.m_32055_().m_41613_());
                this.food.m_146870_();
            }
        }
    }

    public static class VillagerAttackGoal<T extends LivingEntity>
    extends NearestAttackableTargetGoal<AbstractVillager> {
        protected Ravaged ravaged;

        public VillagerAttackGoal(Ravaged ravaged) {
            super((Mob)ravaged, AbstractVillager.class, true);
            this.ravaged = ravaged;
        }

        public boolean m_8036_() {
            return super.m_8036_() && this.ravaged.isNatural() && (this.ravaged.getTrueOwner() == null || this.ravaged.getTrueOwner() instanceof AbstractIllager) && this.f_26050_ != null && !this.f_26050_.m_6162_();
        }
    }
}

