/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.common.entities.ally.illager;

import com.Polarice3.Goety.api.entities.IAutoRideable;
import com.Polarice3.Goety.api.entities.ally.IServant;
import com.Polarice3.Goety.api.items.magic.IWand;
import com.Polarice3.Goety.common.entities.ModEntityType;
import com.Polarice3.Goety.common.entities.ally.Summoned;
import com.Polarice3.Goety.common.entities.ally.illager.RaiderServant;
import com.Polarice3.Goety.common.entities.ally.undead.zombie.ZombieRavager;
import com.Polarice3.Goety.common.entities.hostile.ArmoredRavager;
import com.Polarice3.Goety.common.entities.neutral.IRavager;
import com.Polarice3.Goety.common.items.ModItems;
import com.Polarice3.Goety.common.items.RavagerArmorItem;
import com.Polarice3.Goety.config.AttributesConfig;
import com.Polarice3.Goety.config.MobsConfig;
import com.Polarice3.Goety.utils.CuriosFinder;
import com.Polarice3.Goety.utils.EntityFinder;
import com.Polarice3.Goety.utils.MobUtil;
import java.util.UUID;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.PlayerRideable;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fluids.FluidType;
import org.jetbrains.annotations.NotNull;

public class ModRavager
extends RaiderServant
implements PlayerRideable,
IAutoRideable,
IRavager {
    private static final UUID ARMOR_MODIFIER_UUID = UUID.fromString("d404309f-25d3-4837-8828-e2b7b0ea79fd");
    private static final EntityDataAccessor<Boolean> DATA_SADDLE_ID = SynchedEntityData.m_135353_(ModRavager.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> AUTO_MODE = SynchedEntityData.m_135353_(ModRavager.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final Predicate<Entity> NO_RAVAGER_AND_ALIVE = p_33346_ -> p_33346_.m_6084_() && !(p_33346_ instanceof ModRavager);
    private int attackTick;
    private int stunnedTick;
    private int roarTick;
    private int roarCool;

    public ModRavager(EntityType<? extends Summoned> type, Level worldIn) {
        super(type, worldIn);
        this.m_21441_(BlockPathTypes.LEAVES, 0.0f);
    }

    @Override
    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this){

            public boolean m_8036_() {
                return super.m_8036_() && ModRavager.this.m_6336_() != MobType.f_21641_;
            }
        });
        this.f_21345_.m_25352_(4, (Goal)new RavagerMeleeAttackGoal());
        this.f_21345_.m_25352_(5, new RaiderServant.RaiderWanderGoal<ModRavager>(this, 0.4));
        this.f_21345_.m_25352_(6, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.f_21345_.m_25352_(10, (Goal)new LookAtPlayerGoal((Mob)this, Mob.class, 8.0f));
    }

    @Override
    public void targetSelectGoal() {
        super.targetSelectGoal();
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal(this, new Class[]{RaiderServant.class}){

            public boolean m_8036_() {
                return super.m_8036_() && (ModRavager.this.isHostile() || ModRavager.this.isNatural());
            }
        }.m_26044_(new Class[0]));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, AbstractVillager.class, false, livingEntity -> this.isHostile() && !livingEntity.m_6162_()).m_26146_(300));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, IronGolem.class, false, livingEntity -> this.isHostile()));
    }

    @Override
    protected void m_8022_() {
        boolean flag = !(this.m_6688_() instanceof Mob) || this.m_6688_() instanceof RaiderServant;
        boolean flag1 = !(this.m_20202_() instanceof Boat);
        this.f_21345_.m_25360_(Goal.Flag.MOVE, flag);
        this.f_21345_.m_25360_(Goal.Flag.JUMP, flag && flag1);
        this.f_21345_.m_25360_(Goal.Flag.LOOK, flag);
        this.f_21345_.m_25360_(Goal.Flag.TARGET, flag);
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_SADDLE_ID, (Object)false);
        this.f_19804_.m_135372_(AUTO_MODE, (Object)false);
    }

    public float getStepHeight() {
        return 1.0f;
    }

    public static AttributeSupplier.Builder setCustomAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22276_, 75.0).m_22268_(Attributes.f_22279_, 0.3).m_22268_(Attributes.f_22278_, 0.75).m_22268_(Attributes.f_22281_, ((Double)AttributesConfig.RavagerDamage.get()).doubleValue()).m_22268_(Attributes.f_22282_, 1.5).m_22268_(Attributes.f_22284_, ((Double)AttributesConfig.RavagerArmor.get()).doubleValue()).m_22268_(Attributes.f_22277_, 32.0);
    }

    @Override
    public void setConfigurableAttributes() {
        MobUtil.setBaseAttributes(this.m_21051_(Attributes.f_22284_), (Double)AttributesConfig.RavagerArmor.get());
        MobUtil.setBaseAttributes(this.m_21051_(Attributes.f_22281_), (Double)AttributesConfig.RavagerDamage.get());
    }

    @Override
    public void m_7380_(CompoundTag p_33353_) {
        super.m_7380_(p_33353_);
        p_33353_.m_128405_("AttackTick", this.attackTick);
        p_33353_.m_128405_("StunTick", this.stunnedTick);
        p_33353_.m_128405_("RoarTick", this.roarTick);
        p_33353_.m_128405_("RoarCool", this.roarCool);
        p_33353_.m_128379_("Saddle", this.hasSaddle());
        p_33353_.m_128379_("AutoMode", this.isAutonomous());
        ItemStack itemStack = this.m_6844_(EquipmentSlot.CHEST);
        if (!itemStack.m_41619_()) {
            CompoundTag compoundTag = new CompoundTag();
            itemStack.m_41739_(compoundTag);
            p_33353_.m_128365_("ArmorItem", (Tag)compoundTag);
        }
    }

    @Override
    public void m_7378_(CompoundTag p_33344_) {
        CompoundTag armorItem;
        super.m_7378_(p_33344_);
        this.attackTick = p_33344_.m_128451_("AttackTick");
        this.stunnedTick = p_33344_.m_128451_("StunTick");
        this.roarTick = p_33344_.m_128451_("RoarTick");
        this.roarCool = p_33344_.m_128451_("RoarCool");
        if (p_33344_.m_128441_("Saddle")) {
            this.setSaddle(p_33344_.m_128471_("Saddle"));
        }
        if (p_33344_.m_128441_("AutoMode")) {
            this.setAutonomous(p_33344_.m_128471_("AutoMode"));
        }
        if (p_33344_.m_128441_("ArmorItem") && !(armorItem = p_33344_.m_128469_("ArmorItem")).m_128456_()) {
            this.setArmorEquipment(ItemStack.m_41712_((CompoundTag)armorItem), false);
        }
    }

    @Override
    public boolean canSpawnArmor() {
        return false;
    }

    public void setSaddle(boolean p_20850_) {
        this.f_19804_.m_135381_(DATA_SADDLE_ID, (Object)p_20850_);
    }

    public boolean hasSaddle() {
        return (Boolean)this.f_19804_.m_135370_(DATA_SADDLE_ID);
    }

    @Override
    public void setAutonomous(boolean autonomous) {
        this.f_19804_.m_135381_(AUTO_MODE, (Object)autonomous);
        if (autonomous) {
            this.m_216990_(SoundEvents.f_11686_);
            if (!this.isWandering()) {
                this.setWandering(true);
                this.setStaying(false);
            }
        }
    }

    @Override
    public boolean isAutonomous() {
        return (Boolean)this.f_19804_.m_135370_(AUTO_MODE);
    }

    public int m_8085_() {
        return 45;
    }

    public double m_6048_() {
        return 2.1;
    }

    @Nullable
    public LivingEntity m_6688_() {
        if (!this.m_21525_()) {
            Entity entity = this.m_146895_();
            if (entity instanceof Mob) {
                Mob mob = (Mob)entity;
                if (((Boolean)MobsConfig.ServantRideAutonomous.get()).booleanValue()) {
                    return null;
                }
                return mob;
            }
            if (entity instanceof LivingEntity && !this.isAutonomous()) {
                return (LivingEntity)entity;
            }
        }
        return null;
    }

    public boolean m_6109_() {
        return this.m_21515_();
    }

    @Override
    public ItemStack getArmor() {
        return this.m_6844_(EquipmentSlot.CHEST);
    }

    public void setArmorEquipment(ItemStack armor, boolean sound) {
        if (!this.f_19853_.f_46443_) {
            this.m_8061_(EquipmentSlot.CHEST, armor);
            this.m_21409_(EquipmentSlot.CHEST, 0.0f);
            this.updateArmor();
            if (sound) {
                this.m_5496_(SoundEvents.f_11973_, 0.5f, 1.0f);
            }
        }
    }

    public void updateArmor() {
        AttributeInstance attribute = this.m_21051_(Attributes.f_22284_);
        if (attribute != null) {
            int i;
            attribute.m_22120_(ARMOR_MODIFIER_UUID);
            if (this.isArmor(this.getArmor()) && (i = ((RavagerArmorItem)this.getArmor().m_41720_()).getProtection()) != 0) {
                attribute.m_22118_(new AttributeModifier(ARMOR_MODIFIER_UUID, "Ravager armor bonus", (double)i, AttributeModifier.Operation.ADDITION));
            }
        }
    }

    public boolean isArmor(ItemStack p_30731_) {
        return p_30731_.m_41720_() instanceof RavagerArmorItem;
    }

    public double regularSpeed() {
        return 0.3;
    }

    public double aggressiveSpeed() {
        return 0.35;
    }

    @Override
    public void m_8107_() {
        super.m_8107_();
        if (this.isHostile() && this.m_6336_() != MobType.f_21641_ && this.f_19797_ % 20 == 0 && this.hasSaddle()) {
            if (!this.getArmor().m_41619_()) {
                ArmoredRavager armoredRavager = (ArmoredRavager)this.m_21406_((EntityType)ModEntityType.ARMORED_RAVAGER.get(), false);
                if (armoredRavager != null) {
                    armoredRavager.setArmorEquipment(this.getArmor());
                }
            } else {
                this.m_21406_(EntityType.f_20518_, false);
            }
        }
        if (this.m_6084_()) {
            IServant summoned;
            LivingEntity livingEntity;
            AttributeInstance attribute = this.m_21051_(Attributes.f_22279_);
            if (attribute != null) {
                if (this.m_6107_()) {
                    attribute.m_22100_(0.0);
                } else {
                    double d0 = this.m_5448_() != null ? this.aggressiveSpeed() : this.regularSpeed();
                    double d1 = attribute.m_22115_();
                    attribute.m_22100_(Mth.m_14139_((double)0.1, (double)d1, (double)d0));
                }
            }
            if (!this.f_19853_.f_46443_ && ForgeEventFactory.getMobGriefingEvent((Level)this.f_19853_, (Entity)this)) {
                boolean flag = false;
                AABB aabb = this.m_20191_().m_82400_(0.2);
                for (BlockPos blockpos : BlockPos.m_121976_((int)Mth.m_14107_((double)aabb.f_82288_), (int)Mth.m_14107_((double)aabb.f_82289_), (int)Mth.m_14107_((double)aabb.f_82290_), (int)Mth.m_14107_((double)aabb.f_82291_), (int)Mth.m_14107_((double)aabb.f_82292_), (int)Mth.m_14107_((double)aabb.f_82293_))) {
                    BlockState blockstate = this.f_19853_.m_8055_(blockpos);
                    Block block = blockstate.m_60734_();
                    if (!(block instanceof LeavesBlock)) continue;
                    flag = this.f_19853_.m_46953_(blockpos, true, (Entity)this) || flag;
                }
            }
            if (this.roarCool > 0) {
                --this.roarCool;
            }
            if (this.roarTick > 0) {
                --this.roarTick;
                if (this.roarTick == 10) {
                    this.roar();
                }
            }
            if (this.attackTick > 0) {
                --this.attackTick;
            }
            if (this.stunnedTick > 0) {
                --this.stunnedTick;
                this.stunEffect();
                if (this.stunnedTick == 0) {
                    this.m_5496_(this.getRoarSound(), 1.0f, 1.0f);
                    this.roarTick = 20;
                }
            }
            if ((livingEntity = this.m_6688_()) instanceof IServant && (summoned = (IServant)livingEntity) instanceof Mob) {
                Mob mob = (Mob)summoned;
                this.m_6710_(mob.m_5448_());
            }
        }
    }

    protected void m_5907_() {
        super.m_5907_();
        if (this.hasSaddle()) {
            this.m_19998_((ItemLike)Items.f_42450_);
        }
    }

    private void stunEffect() {
        if (this.f_19796_.m_188503_(6) == 0) {
            double d0 = this.m_20185_() - (double)this.m_20205_() * Math.sin(this.f_20883_ * ((float)Math.PI / 180)) + (this.f_19796_.m_188500_() * 0.6 - 0.3);
            double d1 = this.m_20186_() + (double)this.m_20206_() - 0.3;
            double d2 = this.m_20189_() + (double)this.m_20205_() * Math.cos(this.f_20883_ * ((float)Math.PI / 180)) + (this.f_19796_.m_188500_() * 0.6 - 0.3);
            this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123811_, d0, d1, d2, 0.4980392156862745, 0.5137254901960784, 0.5725490196078431);
        }
    }

    protected boolean m_6107_() {
        return super.m_6107_() || this.attackTick > 0 || this.stunnedTick > 0 || this.roarTick > 0;
    }

    public boolean m_142582_(Entity p_149755_) {
        return this.stunnedTick <= 0 && this.roarTick <= 0 && super.m_142582_(p_149755_);
    }

    protected void m_6731_(LivingEntity p_33361_) {
        if (this.roarTick == 0) {
            if (this.f_19796_.m_188500_() < 0.5) {
                this.stunnedTick = 40;
                this.roarCool = this.getRoarCoolMax();
                this.m_5496_(this.getStunnedSound(), 1.0f, 1.0f);
                this.f_19853_.m_7605_((Entity)this, (byte)39);
                p_33361_.m_7334_((Entity)this);
            } else {
                this.strongKnockback((Entity)p_33361_);
            }
            p_33361_.f_19864_ = true;
        }
    }

    @Override
    public void forceRoar() {
        if (this.roarCool <= 0) {
            this.roarTick = 20;
            this.m_5496_(this.getRoarSound(), 1.0f, 1.0f);
            this.roarCool = this.getRoarCoolMax();
            this.f_19853_.m_7605_((Entity)this, (byte)40);
        }
    }

    private void roar() {
        if (this.m_6084_()) {
            for (LivingEntity livingentity : this.f_19853_.m_6443_(LivingEntity.class, this.m_20191_().m_82400_(4.0), NO_RAVAGER_AND_ALIVE)) {
                if (!MobUtil.areAllies((Entity)this, (Entity)livingentity)) {
                    livingentity.m_6469_(this.getServantAttack(), 6.0f);
                }
                this.strongKnockback((Entity)livingentity);
            }
            Vec3 vec3 = this.m_20191_().m_82399_();
            for (int i = 0; i < 40; ++i) {
                double d0 = this.f_19796_.m_188583_() * 0.2;
                double d1 = this.f_19796_.m_188583_() * 0.2;
                double d2 = this.f_19796_.m_188583_() * 0.2;
                this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123759_, vec3.f_82479_, vec3.f_82480_, vec3.f_82481_, d0, d1, d2);
            }
            this.m_146850_(GameEvent.f_223709_);
        }
    }

    private void strongKnockback(Entity p_33340_) {
        double d0 = p_33340_.m_20185_() - this.m_20185_();
        double d1 = p_33340_.m_20189_() - this.m_20189_();
        double d2 = Math.max(d0 * d0 + d1 * d1, 0.001);
        p_33340_.m_5997_(d0 / d2 * 4.0, 0.2, d1 / d2 * 4.0);
    }

    public void m_7822_(byte p_33335_) {
        if (p_33335_ == 4) {
            this.attackTick = 10;
            this.m_5496_(this.getAttackSound(), 1.0f, 1.0f);
        } else if (p_33335_ == 39) {
            this.stunnedTick = 40;
            this.roarCool = this.getRoarCoolMax();
        } else if (p_33335_ == 40) {
            this.roarTick = 20;
            this.m_5496_(this.getRoarSound(), 1.0f, 1.0f);
            this.roarCool = this.getRoarCoolMax();
        }
        super.m_7822_(p_33335_);
    }

    public int getAttackTick() {
        return this.attackTick;
    }

    public int getStunnedTick() {
        return this.stunnedTick;
    }

    public int getRoarTick() {
        return this.roarTick;
    }

    @Override
    public int getRoarCool() {
        return this.roarCool;
    }

    @Override
    public boolean m_7327_(Entity p_33328_) {
        this.attackTick = 10;
        this.f_19853_.m_7605_((Entity)this, (byte)4);
        this.m_5496_(this.getAttackSound(), 1.0f, 1.0f);
        return super.m_7327_(p_33328_);
    }

    @Nullable
    protected SoundEvent m_7515_() {
        return SoundEvents.f_12356_;
    }

    protected SoundEvent m_7975_(DamageSource p_33359_) {
        return SoundEvents.f_12360_;
    }

    protected SoundEvent m_5592_() {
        return SoundEvents.f_12359_;
    }

    protected SoundEvent getStepSound() {
        if (this.hasSaddle()) {
            return SoundEvents.f_12361_;
        }
        return SoundEvents.f_12284_;
    }

    protected SoundEvent getAttackSound() {
        return SoundEvents.f_12357_;
    }

    protected SoundEvent getStunnedSound() {
        return SoundEvents.f_12362_;
    }

    protected SoundEvent getRoarSound() {
        return SoundEvents.f_12363_;
    }

    protected void m_7355_(BlockPos p_33350_, BlockState p_33351_) {
        this.m_5496_(this.getStepSound(), 0.15f, 1.0f);
        if (!this.getArmor().m_41619_()) {
            this.m_5496_(SoundEvents.f_11746_, 0.15f, 1.0f);
        }
    }

    @Override
    public SoundEvent getCelebrateSound() {
        return SoundEvents.f_12358_;
    }

    public boolean m_6914_(LevelReader p_33342_) {
        return !p_33342_.m_46855_(this.m_20191_());
    }

    protected void doPlayerRide(Player player) {
        if (!this.f_19853_.f_46443_) {
            player.m_146922_(this.m_146908_());
            player.m_146926_(this.m_146909_());
            player.m_20329_((Entity)this);
        }
    }

    public void m_7023_(@NotNull Vec3 pTravelVector) {
        if (this.m_6084_()) {
            LivingEntity rider = this.m_6688_();
            if (this.m_20160_() && this.hasSaddle() && rider instanceof Player && !this.isAutonomous()) {
                this.m_146922_(rider.m_146908_());
                this.f_19859_ = this.m_146908_();
                this.m_146926_(rider.m_146909_() * 0.5f);
                this.m_19915_(this.m_146908_(), this.m_146909_());
                this.f_20885_ = this.f_20883_ = this.m_146908_();
                float speed = 0.35f;
                if (this.m_6336_() == MobType.f_21641_) {
                    speed = 0.325f;
                }
                float f = rider.f_20900_ * speed;
                float f1 = rider.f_20902_ * speed;
                if (f1 <= 0.0f) {
                    f1 *= 0.25f;
                }
                if (this.m_6336_() != MobType.f_21641_ && (this.m_20069_() && this.getFluidTypeHeight((FluidType)ForgeMod.WATER_TYPE.get()) > this.m_20204_() || this.m_20077_() || this.isInFluidType((fluidType, height) -> this.canSwimInFluidType((FluidType)fluidType) && height > this.m_20204_()))) {
                    Vec3 vector3d = this.m_20184_();
                    this.m_20334_(vector3d.f_82479_, 0.04f, vector3d.f_82481_);
                    this.f_19812_ = true;
                    if (f1 > 0.0f) {
                        float f2 = Mth.m_14031_((float)(this.m_146908_() * ((float)Math.PI / 180)));
                        float f3 = Mth.m_14089_((float)(this.m_146908_() * ((float)Math.PI / 180)));
                        this.m_20256_(this.m_20184_().m_82520_((double)(-0.4f * f2 * 0.04f), 0.0, (double)(0.4f * f3 * 0.04f)));
                    }
                }
                this.m_7910_((float)this.m_21133_(Attributes.f_22279_));
                super.m_7023_(new Vec3((double)f, pTravelVector.f_82480_, (double)f1));
                this.f_20903_ = 0;
                this.m_267651_(false);
            } else {
                super.m_7023_(pTravelVector);
            }
        }
    }

    @Override
    public boolean canUpdateMove() {
        return !(this.m_6688_() instanceof Mob);
    }

    @Override
    public void m_6667_(DamageSource pCause) {
        ZombieRavager servant;
        if (!this.f_19853_.f_46443_ && this.getTrueOwner() != null && this.m_6336_() != MobType.f_21641_ && CuriosFinder.hasNamelessSet(this.getTrueOwner()) && (servant = (ZombieRavager)this.m_21406_((EntityType)ModEntityType.ZOMBIE_RAVAGER.get(), true)) != null) {
            servant.setTrueOwner(this.getTrueOwner());
            if (this.hasSaddle()) {
                servant.equipSaddle(false);
            }
            servant.updateArmor();
            ForgeEventFactory.onLivingConvert((LivingEntity)this, (LivingEntity)servant);
            if (!this.m_20067_()) {
                this.f_19853_.m_5898_((Player)null, 1026, this.m_20183_(), 0);
            }
        }
        super.m_6667_(pCause);
    }

    @Override
    public void tryKill(Player player) {
        if (this.killChance <= 0) {
            this.warnKill(player);
        } else {
            super.tryKill(player);
        }
    }

    @Override
    public InteractionResult m_6071_(Player pPlayer, InteractionHand pHand) {
        if (!pPlayer.f_19853_.f_46443_ && pPlayer == this.getTrueOwner()) {
            if (this.hasSaddle() && !pPlayer.m_6047_()) {
                if (this.m_146895_() != null && this.m_146895_() != pPlayer) {
                    this.m_146895_().m_8127_();
                    return InteractionResult.SUCCESS;
                }
                if (!(pPlayer.m_21120_(pHand).m_41720_() instanceof IWand)) {
                    this.doPlayerRide(pPlayer);
                    return InteractionResult.SUCCESS;
                }
            } else {
                if (pPlayer.m_21120_(pHand).m_150930_((Item)ModItems.OMINOUS_SADDLE.get()) && !this.hasSaddle()) {
                    if (!pPlayer.m_150110_().f_35937_) {
                        pPlayer.m_21120_(pHand).m_41774_(1);
                    }
                    this.equipSaddle(true);
                    return InteractionResult.SUCCESS;
                }
                if (this.isArmor(pPlayer.m_21120_(pHand)) && this.hasSaddle()) {
                    if (!this.getArmor().m_41619_()) {
                        if (this.m_19983_(this.getArmor()) != null) {
                            this.setArmorEquipment(pPlayer.m_21205_().m_41777_(), true);
                            if (!pPlayer.m_150110_().f_35937_) {
                                pPlayer.m_21205_().m_41774_(1);
                            }
                        }
                    } else {
                        this.setArmorEquipment(pPlayer.m_21205_().m_41777_(), true);
                        if (!pPlayer.m_150110_().f_35937_) {
                            pPlayer.m_21205_().m_41774_(1);
                        }
                    }
                    EntityFinder.sendEntityUpdatePacket(pPlayer, (LivingEntity)this);
                    return InteractionResult.SUCCESS;
                }
                if (this.isFood(pPlayer.m_21120_(pHand)) && this.m_21223_() < this.m_21233_()) {
                    FoodProperties foodProperties = pPlayer.m_21205_().getFoodProperties((LivingEntity)this);
                    if (foodProperties != null) {
                        this.m_5634_(foodProperties.m_38744_());
                        if (!pPlayer.m_150110_().f_35937_) {
                            pPlayer.m_21205_().m_41774_(1);
                        }
                        this.m_5496_(SoundEvents.f_11912_, this.m_6121_(), 0.5f);
                        this.m_146852_(GameEvent.f_157806_, (Entity)this);
                        return InteractionResult.SUCCESS;
                    }
                    return InteractionResult.PASS;
                }
                if (pPlayer.m_21120_(pHand).m_150930_(Items.f_42398_) && !this.getArmor().m_41619_() && this.m_19983_(this.getArmor()) != null) {
                    this.setArmorEquipment(ItemStack.f_41583_, true);
                    return InteractionResult.SUCCESS;
                }
            }
        }
        return super.m_6071_(pPlayer, pHand);
    }

    public boolean isFood(ItemStack p_30440_) {
        Item item = p_30440_.m_41720_();
        FoodProperties foodProperties = p_30440_.getFoodProperties((LivingEntity)this);
        return item.m_41472_() && foodProperties != null && foodProperties.m_38746_();
    }

    public void equipSaddle(boolean playSound) {
        AttributeInstance attributeInstance;
        if (playSound) {
            this.f_19853_.m_6269_(null, (Entity)this, SoundEvents.f_12034_, SoundSource.PLAYERS, 1.0f, 1.0f);
        }
        if ((attributeInstance = this.m_21051_(Attributes.f_22276_)) != null) {
            attributeInstance.m_22100_(((Double)AttributesConfig.RavagerSaddleHealth.get()).doubleValue());
        }
        this.setSaddle(true);
    }

    class RavagerMeleeAttackGoal
    extends MeleeAttackGoal {
        public RavagerMeleeAttackGoal() {
            super((PathfinderMob)ModRavager.this, 1.0, true);
        }

        protected double m_6639_(LivingEntity p_33377_) {
            float f = ModRavager.this.m_20205_() - 0.1f;
            return f * 2.0f * f * 2.0f + p_33377_.m_20205_();
        }
    }
}

