/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.common.entities.ally;

import com.Polarice3.Goety.api.entities.IAutoRideable;
import com.Polarice3.Goety.api.items.magic.IWand;
import com.Polarice3.Goety.client.particles.ModParticleTypes;
import com.Polarice3.Goety.common.entities.ModEntityType;
import com.Polarice3.Goety.common.entities.ai.ModMeleeAttackGoal;
import com.Polarice3.Goety.common.entities.ally.AnimalSummon;
import com.Polarice3.Goety.common.entities.ally.Summoned;
import com.Polarice3.Goety.common.entities.neutral.Owned;
import com.Polarice3.Goety.config.AttributesConfig;
import com.Polarice3.Goety.config.MobsConfig;
import com.Polarice3.Goety.init.ModMobType;
import com.Polarice3.Goety.utils.CuriosFinder;
import com.Polarice3.Goety.utils.MobUtil;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.TimeUtil;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.PlayerRideable;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.util.DefaultRandomPos;
import net.minecraft.world.entity.ai.util.LandRandomPos;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.Zoglin;
import net.minecraft.world.entity.monster.hoglin.HoglinBase;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.ForgeEventFactory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HoglinServant
extends AnimalSummon
implements HoglinBase,
PlayerRideable,
IAutoRideable {
    private static final EntityDataAccessor<Boolean> DATA_IMMUNE_TO_ZOMBIFICATION = SynchedEntityData.m_135353_(HoglinServant.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> AUTO_MODE = SynchedEntityData.m_135353_(HoglinServant.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private int attackAnimationRemainingTicks;
    private int timeInOverworld;
    private int retreatTime;
    private int avoidTime;
    public BlockPos nearestRepellent;
    private static final UniformInt RETREAT_DURATION = TimeUtil.m_145020_((int)5, (int)20);
    @Nullable
    private LivingEntity toAvoid;

    public HoglinServant(EntityType<? extends Owned> type, Level worldIn) {
        super(type, worldIn);
    }

    @Override
    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(1, (Goal)new HoglinMeleeAttackGoal());
        this.f_21345_.m_25352_(2, (Goal)new AnimalSummon.BreedGoal(this, 1.0));
        this.f_21345_.m_25352_(5, new Summoned.WanderGoal<HoglinServant>(this, 0.4));
        this.f_21345_.m_25352_(6, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.f_21345_.m_25352_(7, (Goal)new RandomLookAroundGoal((Mob)this));
    }

    public static AttributeSupplier.Builder setCustomAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22276_, ((Double)AttributesConfig.HoglinServantHealth.get()).doubleValue()).m_22268_(Attributes.f_22279_, (double)0.3f).m_22268_(Attributes.f_22278_, (double)0.6f).m_22268_(Attributes.f_22282_, 1.0).m_22268_(Attributes.f_22284_, ((Double)AttributesConfig.HoglinServantArmor.get()).doubleValue()).m_22268_(Attributes.f_22281_, ((Double)AttributesConfig.HoglinServantDamage.get()).doubleValue());
    }

    @Override
    public void setConfigurableAttributes() {
        MobUtil.setBaseAttributes(this.m_21051_(Attributes.f_22276_), (Double)AttributesConfig.HoglinServantHealth.get());
        MobUtil.setBaseAttributes(this.m_21051_(Attributes.f_22284_), (Double)AttributesConfig.HoglinServantArmor.get());
        if (this.m_6162_()) {
            MobUtil.setBaseAttributes(this.m_21051_(Attributes.f_22281_), 0.5);
        } else {
            MobUtil.setBaseAttributes(this.m_21051_(Attributes.f_22281_), (Double)AttributesConfig.HoglinServantDamage.get());
        }
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_IMMUNE_TO_ZOMBIFICATION, (Object)false);
        this.f_19804_.m_135372_(AUTO_MODE, (Object)false);
    }

    @Override
    public void m_7380_(CompoundTag p_33353_) {
        super.m_7380_(p_33353_);
        p_33353_.m_128379_("IsImmuneToZombification", this.isImmuneToZombification());
        p_33353_.m_128379_("AutoMode", this.isAutonomous());
        p_33353_.m_128405_("TimeInOverworld", this.timeInOverworld);
    }

    @Override
    public void m_7378_(CompoundTag p_33344_) {
        super.m_7378_(p_33344_);
        if (p_33344_.m_128441_("IsImmuneToZombification")) {
            this.setImmuneToZombification(p_33344_.m_128471_("IsImmuneToZombification"));
        }
        if (p_33344_.m_128441_("TimeInOverworld")) {
            this.timeInOverworld = p_33344_.m_128451_("TimeInOverworld");
        }
        if (p_33344_.m_128441_("AutoMode")) {
            this.setAutonomous(p_33344_.m_128471_("AutoMode"));
        }
    }

    protected SoundEvent m_7515_() {
        return HoglinServant.isRetreating(this) ? SoundEvents.f_11962_ : (this.m_5912_() ? SoundEvents.f_11957_ : SoundEvents.f_11956_);
    }

    protected SoundEvent m_7975_(DamageSource p_34548_) {
        return SoundEvents.f_11961_;
    }

    protected SoundEvent m_5592_() {
        return SoundEvents.f_11960_;
    }

    protected void m_7355_(BlockPos p_34526_, BlockState p_34527_) {
        this.m_5496_(SoundEvents.f_11963_, 0.15f, 1.0f);
    }

    @Override
    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor p_34508_, DifficultyInstance p_34509_, MobSpawnType p_34510_, @javax.annotation.Nullable SpawnGroupData p_34511_, @javax.annotation.Nullable CompoundTag p_34512_) {
        if (p_34508_.m_213780_().m_188501_() < 0.2f) {
            this.m_6863_(true);
        }
        return super.m_6518_(p_34508_, p_34509_, p_34510_, p_34511_, p_34512_);
    }

    @Override
    public boolean m_6469_(DamageSource p_27567_, float p_27568_) {
        LivingEntity attacker;
        Entity entity;
        boolean flag = super.m_6469_(p_27567_, p_27568_);
        if (this.m_6162_() && (entity = p_27567_.m_7639_()) instanceof LivingEntity && !MobUtil.areAllies((Entity)this, (Entity)(attacker = (LivingEntity)entity))) {
            this.toAvoid = attacker;
            this.m_21573_().m_26573_();
            this.avoidTime = RETREAT_DURATION.m_214085_(this.f_19796_);
        }
        return flag;
    }

    @Override
    public boolean m_7327_(Entity p_34491_) {
        if (!(p_34491_ instanceof LivingEntity)) {
            return false;
        }
        this.attackAnimationRemainingTicks = 10;
        this.f_19853_.m_7605_((Entity)this, (byte)4);
        this.m_5496_(SoundEvents.f_11958_, 1.0f, this.m_6100_());
        return HoglinBase.m_34642_((LivingEntity)this, (LivingEntity)((LivingEntity)p_34491_));
    }

    protected void m_6731_(LivingEntity p_34550_) {
        if (!this.m_6162_()) {
            HoglinBase.m_34645_((LivingEntity)this, (LivingEntity)p_34550_);
        }
    }

    @Override
    protected void ageBoundaryReached() {
        AttributeInstance attack = this.m_21051_(Attributes.f_22281_);
        if (attack != null) {
            if (this.m_6162_()) {
                attack.m_22100_(0.5);
            } else {
                attack.m_22100_(((Double)AttributesConfig.HoglinServantDamage.get()).doubleValue());
            }
        }
    }

    public MobType m_6336_() {
        return ModMobType.NATURAL;
    }

    @Override
    public void setAutonomous(boolean autonomous) {
        this.f_19804_.m_135381_(AUTO_MODE, (Object)autonomous);
        if (autonomous) {
            this.m_216990_(SoundEvents.f_11686_);
            if (!this.isWandering()) {
                this.setWandering(true);
                this.setStaying(false);
            }
        }
    }

    @Override
    public boolean isAutonomous() {
        return (Boolean)this.f_19804_.m_135370_(AUTO_MODE);
    }

    public void setImmuneToZombification(boolean p_34565_) {
        this.m_20088_().m_135381_(DATA_IMMUNE_TO_ZOMBIFICATION, (Object)p_34565_);
    }

    private boolean isImmuneToZombification() {
        return (Boolean)this.m_20088_().m_135370_(DATA_IMMUNE_TO_ZOMBIFICATION);
    }

    public boolean isConverting() {
        return !this.f_19853_.m_6042_().m_63960_() && !this.isImmuneToZombification() && !this.m_21525_() && (this.getTrueOwner() == null || !CuriosFinder.hasNetherRobe(this.getTrueOwner()));
    }

    private void finishConversion() {
        Zoglin zoglin = (Zoglin)this.m_21406_(EntityType.f_20500_, true);
        if (zoglin != null) {
            zoglin.m_7292_(new MobEffectInstance(MobEffects.f_19604_, 200, 0));
            ForgeEventFactory.onLivingConvert((LivingEntity)this, (LivingEntity)zoglin);
        }
    }

    @Override
    @Nullable
    public AnimalSummon getBreedOffspring(ServerLevel p_146743_, AnimalSummon p_146744_) {
        HoglinServant hoglin = (HoglinServant)((EntityType)ModEntityType.HOGLIN_SERVANT.get()).m_20615_((Level)p_146743_);
        if (hoglin != null) {
            hoglin.m_21530_();
            hoglin.setImmuneToZombification(this.isImmuneToZombification());
        }
        return hoglin;
    }

    @Override
    public boolean canFallInLove() {
        return !this.m_5912_() && super.canFallInLove();
    }

    @Override
    public void m_7822_(byte p_34496_) {
        if (p_34496_ == 4) {
            this.attackAnimationRemainingTicks = 10;
            this.m_5496_(SoundEvents.f_11958_, 1.0f, this.m_6100_());
        } else {
            super.m_7822_(p_34496_);
        }
    }

    public int m_7575_() {
        return this.attackAnimationRemainingTicks;
    }

    public double m_6048_() {
        return (double)this.m_20206_() - (this.m_6162_() ? 0.2 : 0.15);
    }

    @Nullable
    public LivingEntity m_6688_() {
        if (!this.m_21525_()) {
            Entity entity = this.m_146895_();
            if (entity instanceof Mob) {
                Mob mob = (Mob)entity;
                if (((Boolean)MobsConfig.ServantRideAutonomous.get()).booleanValue()) {
                    return null;
                }
                return mob;
            }
            if (entity instanceof LivingEntity && !this.isAutonomous()) {
                return (LivingEntity)entity;
            }
        }
        return null;
    }

    public boolean m_6109_() {
        return this.m_21515_();
    }

    protected void doPlayerRide(Player player) {
        if (!this.f_19853_.f_46443_) {
            player.m_146922_(this.m_146908_());
            player.m_146926_(this.m_146909_());
            player.m_20329_((Entity)this);
        }
    }

    @Override
    protected void m_8024_() {
        super.m_8024_();
        if (this.isConverting()) {
            ++this.timeInOverworld;
            if (this.timeInOverworld > 300 && ForgeEventFactory.canLivingConvert((LivingEntity)this, (EntityType)EntityType.f_20500_, timer -> {
                this.timeInOverworld = timer;
            })) {
                this.m_216990_(SoundEvents.f_11959_);
                this.finishConversion();
            }
        } else {
            this.timeInOverworld = 0;
        }
    }

    @Override
    public void m_8107_() {
        Level level;
        if (this.attackAnimationRemainingTicks > 0) {
            --this.attackAnimationRemainingTicks;
        }
        if ((level = this.f_19853_) instanceof ServerLevel) {
            Path path;
            Vec3 vector3d2;
            int i;
            Vec3 vec31;
            ServerLevel serverLevel = (ServerLevel)level;
            if (this.findNearestRepellent(serverLevel, this).isPresent()) {
                if (this.nearestRepellent == null) {
                    this.nearestRepellent = this.findNearestRepellent(serverLevel, this).get();
                    this.m_21573_().m_26573_();
                    this.retreatTime = 200;
                }
            } else {
                this.nearestRepellent = null;
            }
            if (this.m_6162_()) {
                if (this.toAvoid != null && !this.toAvoid.m_21224_()) {
                    vec31 = this.toAvoid.m_20182_();
                    if (this.m_20182_().m_82509_((Position)vec31, 8.0) && this.m_21573_().m_26571_()) {
                        for (i = 0; i < 10; ++i) {
                            vector3d2 = DefaultRandomPos.m_148407_((PathfinderMob)this, (int)16, (int)7, (Vec3)vec31);
                            if (vector3d2 == null || (path = this.m_21573_().m_26524_(vector3d2.f_82479_, vector3d2.f_82480_, vector3d2.f_82481_, 0)) == null || !path.m_77403_()) continue;
                            this.m_21573_().m_26536_(path, 1.0);
                            break;
                        }
                    }
                }
            } else {
                this.toAvoid = null;
            }
            if (this.retreatTime > 0) {
                --this.retreatTime;
                this.m_6710_(null);
            }
            if (this.avoidTime > 0) {
                --this.avoidTime;
                this.m_6710_(null);
            } else {
                this.toAvoid = null;
            }
            if (this.nearestRepellent != null) {
                vec31 = this.nearestRepellent.m_252807_();
                if (this.m_20182_().m_82509_((Position)vec31, 8.0) && this.m_21573_().m_26571_()) {
                    for (i = 0; i < 10; ++i) {
                        vector3d2 = LandRandomPos.m_148521_((PathfinderMob)this, (int)16, (int)7, (Vec3)vec31);
                        if (vector3d2 == null || (path = this.m_21573_().m_26524_(vector3d2.f_82479_, vector3d2.f_82480_, vector3d2.f_82481_, 0)) == null || !path.m_77403_()) continue;
                        this.m_21573_().m_26536_(path, 1.0);
                        break;
                    }
                }
            }
        }
        super.m_8107_();
    }

    /*
     * Enabled aggressive block sorting
     */
    public void m_7023_(@NotNull Vec3 pTravelVector) {
        if (!this.m_6084_()) return;
        LivingEntity rider = this.m_6688_();
        if (this.m_20160_() && rider instanceof Player) {
            Player player = (Player)rider;
            if (!this.isAutonomous()) {
                this.m_146922_(rider.m_146908_());
                this.f_19859_ = this.m_146908_();
                this.m_146926_(rider.m_146909_() * 0.5f);
                this.m_19915_(this.m_146908_(), this.m_146909_());
                this.f_20885_ = this.f_20883_ = this.m_146908_();
                float speed = this.m_245547_(player);
                float f = rider.f_20900_ * speed;
                float f1 = rider.f_20902_ * speed;
                if (f1 <= 0.0f) {
                    f1 *= 0.25f;
                }
                this.m_7910_((float)this.m_21133_(Attributes.f_22279_));
                super.m_7023_(new Vec3((double)f, pTravelVector.f_82480_, (double)f1));
                this.f_20903_ = 0;
                this.m_267651_(false);
                return;
            }
        }
        super.m_7023_(pTravelVector);
    }

    @Override
    public boolean isFood(ItemStack p_27600_) {
        return p_27600_.m_150930_(Items.f_41954_);
    }

    @Override
    public InteractionResult m_6071_(Player pPlayer, InteractionHand pHand) {
        ItemStack itemstack = pPlayer.m_21120_(pHand);
        if (this.getTrueOwner() != null && pPlayer == this.getTrueOwner()) {
            if ((itemstack.m_150930_(Items.f_41956_) || itemstack.m_150930_(Items.f_41907_)) && this.m_21223_() < this.m_21233_()) {
                this.m_5634_(2.0f);
                if (!pPlayer.m_150110_().f_35937_) {
                    itemstack.m_41774_(1);
                }
                this.m_146852_(GameEvent.f_157806_, (Entity)this);
                this.m_5584_(this.f_19853_, itemstack);
                Level level = this.f_19853_;
                if (level instanceof ServerLevel) {
                    ServerLevel serverLevel = (ServerLevel)level;
                    for (int i = 0; i < 7; ++i) {
                        double d0 = this.f_19796_.m_188583_() * 0.02;
                        double d1 = this.f_19796_.m_188583_() * 0.02;
                        double d2 = this.f_19796_.m_188583_() * 0.02;
                        serverLevel.m_8767_((ParticleOptions)((SimpleParticleType)ModParticleTypes.HEAL_EFFECT.get()), this.m_20208_(1.0), this.m_20187_() + 0.5, this.m_20262_(1.0), 0, d0, d1, d2, 0.5);
                    }
                }
                pPlayer.m_6674_(pHand);
                return InteractionResult.SUCCESS;
            }
            if (!pPlayer.m_6047_() && !this.m_6162_()) {
                if (this.m_146895_() != null && this.m_146895_() != pPlayer) {
                    this.m_146895_().m_8127_();
                    return InteractionResult.SUCCESS;
                }
                if (!(pPlayer.m_21120_(pHand).m_41720_() instanceof IWand)) {
                    this.doPlayerRide(pPlayer);
                    return InteractionResult.SUCCESS;
                }
            }
        }
        return super.m_6071_(pPlayer, pHand);
    }

    private static boolean isRetreating(HoglinServant p_34633_) {
        return p_34633_.nearestRepellent != null || p_34633_.toAvoid != null;
    }

    @Override
    public float m_5610_(BlockPos p_34516_, LevelReader p_34517_) {
        if (HoglinServant.isPosNearNearestRepellent(this, p_34516_)) {
            return -1.0f;
        }
        return p_34517_.m_8055_(p_34516_.m_7495_()).m_60713_(Blocks.f_50699_) ? 10.0f : 0.0f;
    }

    static boolean isPosNearNearestRepellent(HoglinServant p_34586_, BlockPos p_34587_) {
        return p_34586_.nearestRepellent != null && p_34586_.nearestRepellent.m_123314_((Vec3i)p_34587_, 8.0);
    }

    private Optional<BlockPos> findNearestRepellent(ServerLevel p_26665_, HoglinServant p_26666_) {
        return BlockPos.m_121930_((BlockPos)p_26666_.m_20183_(), (int)8, (int)4, p_186148_ -> p_26665_.m_8055_(p_186148_).m_204336_(BlockTags.f_13084_));
    }

    class HoglinMeleeAttackGoal
    extends ModMeleeAttackGoal {
        public HoglinMeleeAttackGoal() {
            super(HoglinServant.this, 1.0, true);
        }

        @Override
        protected int getAttackInterval() {
            return this.m_183277_(40);
        }
    }
}

