/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.common.entities.ally;

import com.Polarice3.Goety.client.particles.ModParticleTypes;
import com.Polarice3.Goety.common.entities.ai.CreatureBowAttackGoal;
import com.Polarice3.Goety.common.entities.ally.Summoned;
import com.Polarice3.Goety.common.entities.projectiles.NecroBolt;
import com.Polarice3.Goety.common.items.ModItems;
import com.Polarice3.Goety.init.ModSounds;
import com.Polarice3.Goety.utils.LichdomHelper;
import com.Polarice3.Goety.utils.ServerParticleUtil;
import com.Polarice3.Goety.utils.SoundUtil;
import java.util.EnumSet;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.PlayerInfo;
import net.minecraft.client.resources.DefaultPlayerSkin;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.player.PlayerModelPart;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.ProjectileWeaponItem;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.phys.Vec3;

public class Doppelganger
extends Summoned
implements RangedAttackMob {
    private static final EntityDataAccessor<Byte> DOPPELGANGER_FLAGS = SynchedEntityData.m_135353_(Doppelganger.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    protected static final EntityDataAccessor<Byte> DATA_PLAYER_MODE_CUSTOMISATION = SynchedEntityData.m_135353_(Doppelganger.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    public float oBob;
    public float bob;
    public double xCloakO;
    public double yCloakO;
    public double zCloakO;
    public double xCloak;
    public double yCloak;
    public double zCloak;
    @Nullable
    private PlayerInfo playerInfo;

    public Doppelganger(EntityType<? extends Doppelganger> type, Level worldIn) {
        super(type, worldIn);
    }

    @Override
    public void m_8119_() {
        for (Mob mob : this.f_19853_.m_45976_(Mob.class, this.m_20191_().m_82400_(16.0))) {
            if (this.getTrueOwner() != null) {
                if (mob.m_5448_() != this.getTrueOwner()) continue;
                if (this.m_5448_() != mob) {
                    this.m_6710_((LivingEntity)mob);
                }
                mob.m_6710_((LivingEntity)this);
                continue;
            }
            mob.m_6710_((LivingEntity)this);
        }
        this.oBob = this.bob;
        float f = Math.min(0.1f, Mth.m_14116_((float)((float)Doppelganger.getHorizontalDistanceSqr(this.m_20184_()))));
        this.bob += (f - this.bob) * 0.4f;
        this.moveCloak();
        if (this.getTrueOwner() != null) {
            AttributeInstance attributeInstance;
            if (!this.isUndeadClone() && this.getTrueOwner().f_20916_ == this.getTrueOwner().f_20917_ - 1) {
                this.m_6667_(this.m_269291_().m_269064_());
            }
            this.m_6593_(this.getTrueOwner().m_5446_());
            if (this.getTrueOwner().m_21233_() != this.m_21233_() && (attributeInstance = this.m_21051_(Attributes.f_22276_)) != null) {
                attributeInstance.m_22100_((double)this.getTrueOwner().m_21233_());
            }
        }
        if (this.isUndeadClone()) {
            this.m_21573_().m_26573_();
            if (this.m_5448_() != null) {
                this.m_21563_().m_148051_((Entity)this.m_5448_());
            }
            if (this.getTrueOwner() == null || this.getTrueOwner() != null && this.getTrueOwner().m_21224_()) {
                this.m_6667_(this.m_269291_().m_269064_());
            }
        }
        if (this.hasShot() && (this.f_19797_ % 40 == 0 && this.f_19796_.m_188501_() <= 0.25f || this.f_19797_ % 100 == 0)) {
            this.m_6667_(this.m_269291_().m_269064_());
        }
        if (LichdomHelper.isInLichMode(this.getTrueOwner()) && this.f_19797_ % 5 == 0 && this.f_19853_.f_46443_) {
            this.f_19853_.m_7106_((ParticleOptions)ModParticleTypes.LICH.get(), this.m_20208_(0.5), this.m_20186_(), this.m_20262_(0.5), 0.0, 0.0, 0.0);
        }
        super.m_8119_();
    }

    private void moveCloak() {
        this.xCloakO = this.xCloak;
        this.yCloakO = this.yCloak;
        this.zCloakO = this.zCloak;
        double d0 = this.m_20185_() - this.xCloak;
        double d1 = this.m_20186_() - this.yCloak;
        double d2 = this.m_20189_() - this.zCloak;
        double d3 = 10.0;
        if (d0 > d3) {
            this.xCloakO = this.xCloak = this.m_20185_();
        }
        if (d2 > d3) {
            this.zCloakO = this.zCloak = this.m_20189_();
        }
        if (d1 > d3) {
            this.yCloakO = this.yCloak = this.m_20186_();
        }
        if (d0 < -d3) {
            this.xCloakO = this.xCloak = this.m_20185_();
        }
        if (d2 < -d3) {
            this.zCloakO = this.zCloak = this.m_20189_();
        }
        if (d1 < -d3) {
            this.yCloakO = this.yCloak = this.m_20186_();
        }
        this.xCloak += d0 * 0.25;
        this.zCloak += d2 * 0.25;
        this.yCloak += d1 * 0.25;
    }

    public static double getHorizontalDistanceSqr(Vec3 pVector) {
        return pVector.f_82479_ * pVector.f_82479_ + pVector.f_82481_ * pVector.f_82481_;
    }

    @Override
    public void lifeSpanDamage() {
        this.m_6667_(this.m_269291_().m_269064_());
    }

    @Override
    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new NecroBoltGoal(this));
        this.f_21345_.m_25352_(4, new CreatureBowAttackGoal<Doppelganger>(this, 1.0, 20, 20.0f));
        this.f_21345_.m_25352_(8, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0, 10.0f));
        this.f_21345_.m_25352_(9, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 3.0f, 1.0f));
        this.f_21345_.m_25352_(10, (Goal)new LookAtPlayerGoal((Mob)this, Mob.class, 8.0f));
    }

    public static AttributeSupplier.Builder setCustomAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22277_, 18.0).m_22268_(Attributes.f_22279_, 0.35).m_22268_(Attributes.f_22281_, 0.0).m_22268_(Attributes.f_22278_, 1.0).m_22268_(Attributes.f_22276_, 20.0);
    }

    @Override
    public boolean m_7327_(Entity entityIn) {
        return this.isUndeadClone();
    }

    protected SoundEvent m_7515_() {
        return null;
    }

    protected SoundEvent m_7975_(DamageSource damageSourceIn) {
        return SoundEvents.f_11915_;
    }

    protected SoundEvent m_5592_() {
        return SoundEvents.f_11910_;
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DOPPELGANGER_FLAGS, (Object)0);
        this.f_19804_.m_135372_(DATA_PLAYER_MODE_CUSTOMISATION, (Object)0);
    }

    @Override
    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        if (compound.m_128441_("UndeadClone")) {
            this.setUndeadClone(compound.m_128471_("UndeadClone"));
        }
        if (compound.m_128441_("Shot")) {
            this.setShot(compound.m_128471_("Shot"));
        }
        if (compound.m_128441_("TickCount")) {
            this.f_19797_ = compound.m_128451_("TickCount");
        }
    }

    @Override
    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128379_("UndeadClone", this.isUndeadClone());
        compound.m_128379_("Shot", this.hasShot());
        compound.m_128405_("TickCount", this.f_19797_);
    }

    private boolean getDoppelgangerFlags(int mask) {
        byte i = (Byte)this.f_19804_.m_135370_(DOPPELGANGER_FLAGS);
        return (i & mask) != 0;
    }

    private void setDoppelgangerFlags(int mask, boolean value) {
        int i = ((Byte)this.f_19804_.m_135370_(DOPPELGANGER_FLAGS)).byteValue();
        i = value ? (i |= mask) : (i &= ~mask);
        this.f_19804_.m_135381_(DOPPELGANGER_FLAGS, (Object)((byte)(i & 0xFF)));
    }

    public boolean isUndeadClone() {
        return this.getDoppelgangerFlags(1);
    }

    public void setUndeadClone(boolean undeadClone) {
        this.setDoppelgangerFlags(1, undeadClone);
    }

    public boolean hasShot() {
        return this.getDoppelgangerFlags(2);
    }

    public void setShot(boolean undeadClone) {
        this.setDoppelgangerFlags(2, undeadClone);
    }

    public boolean isCapeLoaded() {
        return this.getPlayerInfo() != null;
    }

    public boolean isModelPartShown(PlayerModelPart p_36171_) {
        return ((Byte)this.m_20088_().m_135370_(DATA_PLAYER_MODE_CUSTOMISATION) & p_36171_.m_36445_()) == p_36171_.m_36445_();
    }

    public ResourceLocation getSkinTextureLocation() {
        PlayerInfo playerinfo = this.getPlayerInfo();
        return playerinfo == null ? DefaultPlayerSkin.m_118627_((UUID)this.m_20148_()) : playerinfo.m_105337_();
    }

    public String getModelName() {
        PlayerInfo playerinfo = this.getPlayerInfo();
        return playerinfo == null ? DefaultPlayerSkin.m_118629_((UUID)this.m_20148_()) : playerinfo.m_105336_();
    }

    @Nullable
    public ResourceLocation getCloakTextureLocation() {
        PlayerInfo playerinfo = this.getPlayerInfo();
        return playerinfo == null ? null : playerinfo.m_105338_();
    }

    @Nullable
    protected PlayerInfo getPlayerInfo() {
        if (this.playerInfo == null && this.getOwnerId() != null) {
            this.playerInfo = Minecraft.m_91087_().m_91403_().m_104949_(this.getOwnerId());
        }
        return this.playerInfo;
    }

    public boolean m_21526_() {
        LivingEntity livingEntity = this.getTrueOwner();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            return player.m_5737_() == HumanoidArm.RIGHT;
        }
        return super.m_21526_();
    }

    @Override
    public boolean m_6469_(DamageSource source, float amount) {
        boolean flag = super.m_6469_(source, amount);
        if (this.isUndeadClone()) {
            return source.m_269533_(DamageTypeTags.f_268738_) || source.m_269533_(DamageTypeTags.f_268490_) && source.m_269533_(DamageTypeTags.f_268437_);
        }
        if (flag && !this.f_19853_.f_46443_) {
            this.m_6667_(source);
        }
        return flag;
    }

    @Override
    public void m_6667_(DamageSource cause) {
        if (!this.f_19853_.f_46443_) {
            for (int i = 0; i < this.f_19853_.f_46441_.m_188503_(10) + 10; ++i) {
                SimpleParticleType particleOptions = ParticleTypes.f_123759_;
                if (this.isUndeadClone()) {
                    particleOptions = (ParticleOptions)ModParticleTypes.LICH.get();
                }
                ServerParticleUtil.smokeParticles((ParticleOptions)particleOptions, this.m_20185_(), this.m_20186_(), this.m_20189_(), this.f_19853_);
            }
        }
        SoundEvent soundEvent = SoundEvents.f_12052_;
        if (this.isUndeadClone()) {
            soundEvent = (SoundEvent)ModSounds.LICH_TELEPORT_OUT.get();
        }
        this.m_5496_(soundEvent, 1.0f, 1.0f);
        this.m_146870_();
    }

    @Override
    protected void m_213945_(RandomSource randomSource, DifficultyInstance difficulty) {
        if (this.getTrueOwner() != null) {
            for (EquipmentSlot equipmentSlotType : EquipmentSlot.values()) {
                if (equipmentSlotType == EquipmentSlot.MAINHAND) continue;
                this.m_8061_(equipmentSlotType, this.getTrueOwner().m_6844_(equipmentSlotType).m_41777_());
                this.m_21409_(equipmentSlotType, 0.0f);
            }
        }
        if (this.isUndeadClone()) {
            this.m_8061_(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)ModItems.NAMELESS_STAFF.get()));
        } else {
            this.m_8061_(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)Items.f_42411_));
        }
        this.m_21409_(EquipmentSlot.MAINHAND, 0.0f);
    }

    public void m_8061_(EquipmentSlot p_21416_, ItemStack p_21417_) {
        super.m_8061_(p_21416_, p_21417_);
        this.m_21409_(p_21416_, 0.0f);
    }

    @Override
    public boolean m_7301_(MobEffectInstance potioneffectIn) {
        return potioneffectIn.m_19544_() == MobEffects.f_19619_;
    }

    @Override
    public SpawnGroupData m_6518_(ServerLevelAccessor pLevel, DifficultyInstance pDifficulty, MobSpawnType pReason, @Nullable SpawnGroupData pSpawnData, @Nullable CompoundTag pDataTag) {
        pSpawnData = super.m_6518_(pLevel, pDifficulty, pReason, pSpawnData, pDataTag);
        this.m_213945_(pLevel.m_213780_(), pDifficulty);
        this.m_213946_(pLevel.m_213780_(), pDifficulty);
        return pSpawnData;
    }

    public void m_6504_(LivingEntity target, float distanceFactor) {
        if (!this.isUndeadClone()) {
            ItemStack itemstack = this.m_6298_(this.m_21120_(ProjectileUtil.getWeaponHoldingHand((LivingEntity)this, item -> item instanceof BowItem)));
            AbstractArrow abstractarrowentity = this.getMobArrow(itemstack, distanceFactor);
            abstractarrowentity = ((BowItem)this.m_21205_().m_41720_()).customArrow(abstractarrowentity);
            double d0 = target.m_20185_() - this.m_20185_();
            double d1 = target.m_20227_(0.3333333333333333) - abstractarrowentity.m_20186_();
            double d2 = target.m_20189_() - this.m_20189_();
            double d3 = Mth.m_14116_((float)((float)(d0 * d0 + d2 * d2)));
            abstractarrowentity.m_6686_(d0, d1 + d3 * (double)0.2f, d2, 1.6f, (float)(14 - this.f_19853_.m_46791_().m_19028_() * 4));
            this.m_5496_(SoundEvents.f_11687_, 1.0f, 1.0f / (this.m_217043_().m_188501_() * 0.4f + 0.8f));
            this.f_19853_.m_7967_((Entity)abstractarrowentity);
        } else {
            double d3 = target.m_20185_() - this.m_20185_();
            double d4 = target.m_20186_() + 0.5 - (this.m_20186_() + 0.5);
            double d5 = target.m_20189_() - this.m_20189_();
            NecroBolt soulBolt = new NecroBolt((LivingEntity)this, d3, d4, d5, this.f_19853_);
            soulBolt.m_6034_(this.m_20185_(), this.m_20188_() - (double)0.2f, this.m_20189_());
            soulBolt.m_5602_((Entity)this);
            if (this.f_19853_.m_7967_((Entity)soulBolt)) {
                SoundUtil.playNecroBoltIllusion((LivingEntity)this);
                this.setShot(true);
            }
            this.m_6674_(InteractionHand.MAIN_HAND);
        }
    }

    protected AbstractArrow getMobArrow(ItemStack arrowStack, float distanceFactor) {
        AbstractArrow abstractarrowentity = ProjectileUtil.m_37300_((LivingEntity)this, (ItemStack)arrowStack, (float)distanceFactor);
        if (!this.isUpgraded()) {
            abstractarrowentity.m_36781_(0.0);
        } else {
            abstractarrowentity.m_36781_(0.5);
        }
        return abstractarrowentity;
    }

    public boolean m_5886_(ProjectileWeaponItem p_230280_1_) {
        return p_230280_1_ == Items.f_42411_;
    }

    public static class NecroBoltGoal
    extends Goal {
        private final Doppelganger rangedAttackMob;
        @Nullable
        private LivingEntity target;

        public NecroBoltGoal(Doppelganger p_25773_) {
            this.rangedAttackMob = p_25773_;
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        public boolean m_8036_() {
            LivingEntity livingentity = this.rangedAttackMob.m_5448_();
            if (livingentity != null && livingentity.m_6084_()) {
                this.target = livingentity;
                return this.rangedAttackMob.isUndeadClone() && !this.rangedAttackMob.hasShot();
            }
            return false;
        }

        public boolean m_8045_() {
            return this.m_8036_() || this.target != null && this.target.m_6084_() && !this.rangedAttackMob.m_21573_().m_26571_() && !this.rangedAttackMob.hasShot();
        }

        public void m_8041_() {
            this.target = null;
        }

        public boolean m_183429_() {
            return true;
        }

        public void m_8037_() {
            if (this.target != null) {
                this.rangedAttackMob.m_21563_().m_148051_((Entity)this.target);
                if (this.rangedAttackMob.f_19797_ % 20 == 0) {
                    this.rangedAttackMob.m_6504_(this.target, 0.0f);
                }
            }
        }
    }
}

