/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.common.blocks.fluids;

import com.Polarice3.Goety.Goety;
import com.Polarice3.Goety.common.blocks.fluids.ModFluids;
import com.Polarice3.Goety.utils.CuriosFinder;
import com.mojang.blaze3d.shaders.FogShape;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.function.Consumer;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.FogRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.client.extensions.common.IClientFluidTypeExtensions;
import net.minecraftforge.common.SoundActions;
import net.minecraftforge.fluids.FluidType;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector3f;

public class VoidFluidType
extends FluidType {
    public static final ResourceLocation FLUID_STILL = Goety.location("block/void_still");
    public static final ResourceLocation FLUID_FLOWING = Goety.location("block/void_flow");
    public static final ResourceLocation OVERLAY = Goety.location("textures/gui/under_void.png");

    public VoidFluidType() {
        super(FluidType.Properties.create().descriptionId("block.goety.void_fluid").canSwim(false).canDrown(false).sound(SoundActions.BUCKET_FILL, SoundEvents.f_11783_).sound(SoundActions.BUCKET_EMPTY, SoundEvents.f_11780_).pathType(BlockPathTypes.LAVA).adjacentPathType(BlockPathTypes.DANGER_OTHER).density(3000).viscosity(6000).temperature(1300));
    }

    public double motionScale(Entity entity) {
        return entity.m_9236_().m_46472_() == Level.f_46430_ ? 0.007 : 0.0023333333333333335;
    }

    public boolean move(FluidState state, LivingEntity entity, Vec3 movementVector, double gravity) {
        boolean flag = entity.m_20184_().f_82480_ <= 0.0;
        double d8 = entity.m_20186_();
        entity.m_19920_(0.02f, movementVector);
        entity.m_6478_(MoverType.SELF, entity.m_20184_());
        if (entity.getFluidTypeHeight((FluidType)ModFluids.VOID_FLUID_TYPE.get()) <= entity.m_20204_()) {
            entity.m_20256_(entity.m_20184_().m_82542_(0.5, (double)0.8f, 0.5));
            Vec3 vec33 = entity.m_20994_(gravity, flag, entity.m_20184_());
            entity.m_20256_(vec33);
        } else {
            entity.m_20256_(entity.m_20184_().m_82490_(0.5));
        }
        if (!entity.m_20068_()) {
            entity.m_20256_(entity.m_20184_().m_82520_(0.0, -gravity / 4.0, 0.0));
        }
        Vec3 vec34 = entity.m_20184_();
        if (entity.f_19862_ && entity.m_20229_(vec34.f_82479_, vec34.f_82480_ + (double)0.6f - entity.m_20186_() + d8, vec34.f_82481_)) {
            entity.m_20334_(vec34.f_82479_, (double)0.3f, vec34.f_82481_);
        }
        return true;
    }

    public void setItemMovement(ItemEntity entity) {
        Vec3 vec3 = entity.m_20184_();
        entity.m_20334_(vec3.f_82479_ * (double)0.95f, vec3.f_82480_ + (double)(vec3.f_82480_ < (double)0.06f ? 5.0E-4f : 0.0f), vec3.f_82481_ * (double)0.95f);
    }

    public void initializeClient(Consumer<IClientFluidTypeExtensions> consumer) {
        consumer.accept(new IClientFluidTypeExtensions(){

            public ResourceLocation getStillTexture() {
                return FLUID_STILL;
            }

            public ResourceLocation getFlowingTexture() {
                return FLUID_FLOWING;
            }

            public ResourceLocation getRenderOverlayTexture(Minecraft mc) {
                return OVERLAY;
            }

            @NotNull
            public Vector3f modifyFogColor(Camera camera, float partialTick, ClientLevel level, int renderDistance, float darkenWorldAmount, Vector3f fluidFogColor) {
                return new Vector3f(0.0627451f, 0.0f, 0.09411765f);
            }

            public void modifyFogRender(Camera camera, FogRenderer.FogMode mode, float renderDistance, float partialTick, float nearDistance, float farDistance, FogShape shape) {
                LivingEntity livingEntity;
                Entity entity = camera.m_90592_();
                if (entity.m_5833_()) {
                    nearDistance = -8.0f;
                    farDistance = renderDistance * 0.5f;
                } else if (entity instanceof LivingEntity && CuriosFinder.hasVoidRobe(livingEntity = (LivingEntity)entity)) {
                    nearDistance = 0.0f;
                    farDistance = 3.0f;
                } else {
                    nearDistance = 0.25f;
                    farDistance = 1.0f;
                }
                RenderSystem.setShaderFogStart((float)nearDistance);
                RenderSystem.setShaderFogEnd((float)farDistance);
                RenderSystem.setShaderFogShape((FogShape)shape);
            }
        });
    }
}

