/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.common.blocks;

import com.Polarice3.Goety.common.blocks.entities.ForbiddenGrassBlockEntity;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.BaseFireBlock;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.SnowLayerBlock;
import net.minecraft.world.level.block.SnowyDirtBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.lighting.BlockLightEngine;
import net.minecraft.world.level.material.MapColor;

public class ForbiddenGrassBlock
extends SnowyDirtBlock
implements EntityBlock {
    public ForbiddenGrassBlock() {
        super(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283889_).m_60977_().m_60978_(0.6f).m_60918_(SoundType.f_56740_));
    }

    private static boolean canBeGrass(BlockState pState, WorldGenLevel pLevelReader, BlockPos pPos) {
        BlockPos blockpos = pPos.m_7494_();
        BlockState blockstate = pLevelReader.m_8055_(blockpos);
        if (blockstate.m_60713_(Blocks.f_50125_) && (Integer)blockstate.m_61143_((Property)SnowLayerBlock.f_56581_) == 1) {
            return true;
        }
        if (blockstate.m_60819_().m_76186_() == 8) {
            return false;
        }
        int i = BlockLightEngine.m_284282_((BlockGetter)pLevelReader, (BlockState)pState, (BlockPos)pPos, (BlockState)blockstate, (BlockPos)blockpos, (Direction)Direction.UP, (int)blockstate.m_60739_((BlockGetter)pLevelReader, blockpos));
        return i < pLevelReader.m_7469_();
    }

    private static boolean canPropagate(WorldGenLevel pLevel, BlockPos pPos) {
        BlockPos blockpos = pPos.m_7494_();
        return pLevel.m_8055_(blockpos).m_60795_() && !pLevel.m_6425_(blockpos).m_205070_(FluidTags.f_13131_);
    }

    public void m_213898_(BlockState pState, ServerLevel pLevel, BlockPos pPos, RandomSource pRandom) {
        if (pLevel.m_8055_(pPos.m_7494_()).m_60734_() instanceof BaseFireBlock || !ForbiddenGrassBlock.canBeGrass(pState, (WorldGenLevel)pLevel, pPos)) {
            if (!pLevel.m_46749_(pPos)) {
                return;
            }
            pLevel.m_46597_(pPos, Blocks.f_50493_.m_49966_());
        } else {
            BlockState blockstate = this.m_49966_();
            for (int i = 0; i < 4; ++i) {
                BlockPos blockpos = pPos.m_7918_(pRandom.m_188503_(3) - 1, pRandom.m_188503_(5) - 3, pRandom.m_188503_(3) - 1);
                if (!pLevel.m_8055_(blockpos).m_60713_(Blocks.f_50493_) && !pLevel.m_8055_(blockpos).m_60713_(Blocks.f_50440_) || !ForbiddenGrassBlock.canPropagate((WorldGenLevel)pLevel, blockpos)) continue;
                pLevel.m_46597_(blockpos, (BlockState)blockstate.m_61124_((Property)f_56637_, (Comparable)Boolean.valueOf(pLevel.m_8055_(blockpos.m_7494_()).m_60713_(Blocks.f_50125_))));
            }
        }
    }

    public void m_214162_(BlockState pState, Level pLevel, BlockPos pPos, RandomSource pRand) {
        if (pLevel.m_8055_(pPos.m_7494_()).m_60795_() && pRand.m_188501_() <= 0.25f) {
            double d0 = (double)pPos.m_123341_() + 0.5;
            double d1 = (double)pPos.m_123342_() + 0.6;
            double d2 = (double)pPos.m_123343_() + 0.5;
            pLevel.m_7106_((ParticleOptions)ParticleTypes.f_123771_, d0, d1, d2, 0.0, 0.0, 0.0);
        }
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos p_153215_, BlockState p_153216_) {
        return new ForbiddenGrassBlockEntity(p_153215_, p_153216_);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level p_152755_, BlockState p_152756_, BlockEntityType<T> p_152757_) {
        return (world, pos, state, blockEntity) -> {
            if (blockEntity instanceof ForbiddenGrassBlockEntity) {
                ForbiddenGrassBlockEntity arcaBlock = (ForbiddenGrassBlockEntity)blockEntity;
                arcaBlock.tick();
            }
        };
    }
}

