/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.client.render.model;

import com.Polarice3.Goety.client.render.animation.CrusherAnimations;
import com.Polarice3.Goety.client.render.layer.HierarchicalArmor;
import com.Polarice3.Goety.common.entities.ally.illager.CrusherServant;
import com.Polarice3.Goety.common.entities.hostile.illagers.Crusher;
import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.model.HeadedModel;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.item.ArmorItem;

public class CrusherModel<T extends Mob>
extends HierarchicalModel<T>
implements HeadedModel,
HierarchicalArmor {
    private final ModelPart root;
    private final ModelPart head;
    private final ModelPart body;
    private final ModelPart clothes;
    private final ModelPart right_leg;
    private final ModelPart left_leg;
    private final ModelPart right_arm;
    private final ModelPart left_arm;

    public CrusherModel(ModelPart root) {
        this.root = root;
        this.head = root.m_171324_("head");
        this.body = root.m_171324_("body");
        this.clothes = this.body.m_171324_("clothes");
        this.right_leg = root.m_171324_("right_leg");
        this.left_leg = root.m_171324_("left_leg");
        this.right_arm = root.m_171324_("right_arm");
        this.left_arm = root.m_171324_("left_arm");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition head = partdefinition.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-4.0f, -10.0f, -4.0f, 8.0f, 10.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition nose = head.m_171599_("nose", CubeListBuilder.m_171558_().m_171514_(24, 0).m_171488_(-1.0f, -1.0f, -6.0f, 2.0f, 4.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-2.0f, (float)0.0f));
        PartDefinition body = partdefinition.m_171599_("body", CubeListBuilder.m_171558_().m_171514_(16, 20).m_171488_(-4.0f, 0.0f, -3.0f, 8.0f, 12.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition clothes = body.m_171599_("clothes", CubeListBuilder.m_171558_().m_171514_(0, 38).m_171488_(-4.0f, -24.0f, -3.0f, 8.0f, 20.0f, 6.0f, new CubeDeformation(0.5f)), PartPose.m_171419_((float)0.0f, (float)24.0f, (float)0.0f));
        PartDefinition right_leg = partdefinition.m_171599_("right_leg", CubeListBuilder.m_171558_().m_171514_(0, 22).m_171488_(-2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-2.0f, (float)12.0f, (float)0.0f, (float)0.0611f, (float)0.384f, (float)0.1396f));
        PartDefinition left_leg = partdefinition.m_171599_("left_leg", CubeListBuilder.m_171558_().m_171514_(0, 22).m_171480_().m_171488_(-2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171423_((float)2.0f, (float)12.0f, (float)0.0f, (float)-0.1309f, (float)-0.1309f, (float)0.0f));
        PartDefinition right_arm = partdefinition.m_171599_("right_arm", CubeListBuilder.m_171558_().m_171514_(40, 46).m_171488_(-3.0f, -2.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-5.0f, (float)2.0f, (float)0.0f, (float)-1.526f, (float)-0.5664f, (float)1.5249f));
        PartDefinition hammer = right_arm.m_171599_("hammer", CubeListBuilder.m_171558_(), PartPose.m_171423_((float)-2.0f, (float)8.0f, (float)-6.0f, (float)1.5708f, (float)0.7854f, (float)1.5708f));
        PartDefinition handle = hammer.m_171599_("handle", CubeListBuilder.m_171558_().m_171514_(58, 3).m_171488_(-7.0f, 5.25f, 0.0f, 2.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(58, 19).m_171488_(-6.0f, 4.25f, 0.0f, 2.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(58, 22).m_171488_(-5.0f, 3.25f, 0.0f, 2.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(58, 25).m_171488_(-4.0f, 2.25f, 0.0f, 2.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(58, 25).m_171488_(-3.0f, 1.25f, 0.0f, 2.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(58, 0).m_171488_(-2.0f, 0.25f, 0.0f, 2.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(58, 0).m_171488_(-1.0f, -0.75f, 0.0f, 2.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(58, 0).m_171488_(0.0f, -1.75f, 0.0f, 2.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(58, 0).m_171488_(1.0f, -2.75f, 0.0f, 2.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(58, 0).m_171488_(1.0f, -2.75f, 0.0f, 2.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(58, 0).m_171488_(2.0f, -3.75f, 0.0f, 2.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(58, 0).m_171488_(3.0f, -4.75f, 0.0f, 2.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-1.0f, (float)1.0f, (float)0.0f));
        PartDefinition head2 = hammer.m_171599_("head2", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition cube_r1 = head2.m_171599_("cube_r1", CubeListBuilder.m_171558_().m_171514_(36, 0).m_171488_(-3.5f, -5.5f, -3.5f, 7.0f, 12.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)4.5f, (float)-5.0f, (float)0.5f, (float)0.0f, (float)0.0f, (float)-0.7854f));
        PartDefinition left_arm = partdefinition.m_171599_("left_arm", CubeListBuilder.m_171558_().m_171514_(40, 46).m_171480_().m_171488_(-1.0f, -2.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171423_((float)5.0f, (float)2.0f, (float)0.0f, (float)-0.6545f, (float)0.0f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        CrusherServant servant;
        Crusher crusher;
        this.m_142109_().m_171331_().forEach(ModelPart::m_233569_);
        if (!entity.m_21224_()) {
            this.animateHeadLookTarget(netHeadYaw, headPitch);
        }
        if (this.f_102609_) {
            this.right_leg.f_104203_ = -1.4137167f;
            this.right_leg.f_104204_ = 0.31415927f;
            this.right_leg.f_104205_ = 0.07853982f;
            this.left_leg.f_104203_ = -1.4137167f;
            this.left_leg.f_104204_ = -0.31415927f;
            this.left_leg.f_104205_ = -0.07853982f;
        } else if (entity instanceof Crusher) {
            crusher = (Crusher)entity;
            this.m_267799_(crusher.isRunning ? CrusherAnimations.RUN : CrusherAnimations.WALK, limbSwing, limbSwingAmount, crusher.isRunning ? 1.0f : 2.5f, 20.0f);
        } else if (entity instanceof CrusherServant) {
            servant = (CrusherServant)entity;
            this.m_267799_(servant.isRunning ? CrusherAnimations.RUN : CrusherAnimations.WALK, limbSwing, limbSwingAmount, servant.isRunning ? 1.0f : 2.5f, 20.0f);
        }
        if (entity instanceof Crusher) {
            crusher = (Crusher)entity;
            this.m_233381_(crusher.idleAnimationState, CrusherAnimations.IDLE, ageInTicks);
            this.m_233381_(crusher.attackAnimationState, CrusherAnimations.SMASH, ageInTicks);
        } else if (entity instanceof CrusherServant) {
            servant = (CrusherServant)entity;
            this.m_233381_(servant.idleAnimationState, CrusherAnimations.IDLE, ageInTicks);
            this.m_233381_(servant.attackAnimationState, CrusherAnimations.SMASH, ageInTicks);
        }
        boolean flag2 = entity.m_6844_(EquipmentSlot.CHEST).m_41720_() instanceof ArmorItem || entity.m_6844_(EquipmentSlot.LEGS).m_41720_() instanceof ArmorItem;
        this.clothes.f_104207_ = !flag2;
    }

    private void animateHeadLookTarget(float netHeadYaw, float headPitch) {
        this.head.f_104204_ = netHeadYaw * ((float)Math.PI / 180);
        this.head.f_104203_ = headPitch * ((float)Math.PI / 180);
    }

    public ModelPart m_5585_() {
        return this.head;
    }

    public ModelPart m_142109_() {
        return this.root;
    }

    @Override
    public void translateToHead(ModelPart modelPart, PoseStack poseStack) {
        modelPart.m_104299_(poseStack);
        poseStack.m_252880_(0.0f, -0.1f, 0.0f);
    }

    @Override
    public void translateToChest(ModelPart modelPart, PoseStack poseStack) {
        modelPart.m_104299_(poseStack);
        poseStack.m_252880_(0.0f, 0.0f, 0.0f);
        poseStack.m_85841_(1.05f, 1.05f, 1.05f);
    }

    @Override
    public void translateToLeg(ModelPart modelPart, PoseStack poseStack) {
        modelPart.m_104299_(poseStack);
    }

    @Override
    public void translateToArms(ModelPart modelPart, PoseStack poseStack) {
        modelPart.m_104299_(poseStack);
        poseStack.m_85841_(1.05f, 1.05f, 1.05f);
    }

    @Override
    public Iterable<ModelPart> rightHandArmors() {
        return ImmutableList.of((Object)this.right_arm);
    }

    @Override
    public Iterable<ModelPart> leftHandArmors() {
        return ImmutableList.of((Object)this.left_arm);
    }

    @Override
    public Iterable<ModelPart> rightLegPartArmors() {
        return ImmutableList.of((Object)this.right_leg);
    }

    @Override
    public Iterable<ModelPart> leftLegPartArmors() {
        return ImmutableList.of((Object)this.left_leg);
    }

    @Override
    public Iterable<ModelPart> bodyPartArmors() {
        return ImmutableList.of((Object)this.body);
    }

    @Override
    public Iterable<ModelPart> headPartArmors() {
        return ImmutableList.of((Object)this.head);
    }
}

