/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.client.render;

import com.Polarice3.Goety.Goety;
import com.Polarice3.Goety.common.entities.projectiles.NecroBolt;
import com.Polarice3.Goety.utils.ColorUtil;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.Camera;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix3f;
import org.joml.Matrix4f;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;

public class NecroBoltRenderer<T extends NecroBolt>
extends EntityRenderer<T> {
    public static final ResourceLocation BASE = Goety.location("textures/particle/necro_bolt_base.png");
    public static final ResourceLocation MID = Goety.location("textures/particle/necro_bolt_mid.png");
    public static final ResourceLocation TOP = Goety.location("textures/particle/necro_bolt_top.png");
    private static final ResourceLocation TRAIL = Goety.location("textures/entity/projectiles/trail.png");

    public NecroBoltRenderer(EntityRendererProvider.Context renderManagerIn) {
        super(renderManagerIn);
    }

    protected int getBlockLightLevel(T entityIn, BlockPos partialTicks) {
        return 15;
    }

    public void render(T entityIn, float entityYaw, float partialTicks, PoseStack matrixStackIn, MultiBufferSource bufferIn, int packedLightIn) {
        matrixStackIn.m_85836_();
        PoseStack.Pose matrixstack$entry = matrixStackIn.m_85850_();
        Matrix4f matrix4f = matrixstack$entry.m_252922_();
        Matrix3f matrix3f = matrixstack$entry.m_252943_();
        RenderType renderType = RenderType.m_110473_((ResourceLocation)this.getTextureLocation(entityIn));
        VertexConsumer ivertexbuilder = bufferIn.m_6299_(renderType);
        matrixStackIn.m_85837_(0.0, 0.5, 0.0);
        this.render(ivertexbuilder, this.f_114476_.f_114358_, (NecroBolt)((Object)entityIn), partialTicks, packedLightIn, matrix4f, matrix3f, 0);
        RenderType renderType2 = RenderType.m_110473_((ResourceLocation)MID);
        VertexConsumer ivertexbuilder2 = bufferIn.m_6299_(renderType2);
        this.render(ivertexbuilder2, this.f_114476_.f_114358_, (NecroBolt)((Object)entityIn), partialTicks, packedLightIn, matrix4f, matrix3f, 0);
        RenderType renderType3 = RenderType.m_110473_((ResourceLocation)TOP);
        VertexConsumer ivertexbuilder3 = bufferIn.m_6299_(renderType3);
        this.render(ivertexbuilder3, this.f_114476_.f_114358_, (NecroBolt)((Object)entityIn), partialTicks, packedLightIn, matrix4f, matrix3f, 1);
        matrixStackIn.m_85849_();
        if (((NecroBolt)((Object)entityIn)).hasTrail()) {
            double x = Mth.m_14139_((double)partialTicks, (double)((NecroBolt)((Object)entityIn)).f_19790_, (double)entityIn.m_20185_());
            double y = Mth.m_14139_((double)partialTicks, (double)((NecroBolt)((Object)entityIn)).f_19791_, (double)entityIn.m_20186_());
            double z = Mth.m_14139_((double)partialTicks, (double)((NecroBolt)((Object)entityIn)).f_19792_, (double)entityIn.m_20189_());
            matrixStackIn.m_85836_();
            matrixStackIn.m_85837_(-x, -y, -z);
            ColorUtil colorUtil = new ColorUtil(10351920);
            this.renderTrail((NecroBolt)((Object)entityIn), partialTicks, matrixStackIn, bufferIn, colorUtil.red, colorUtil.green, colorUtil.blue, 0.6f, packedLightIn);
            matrixStackIn.m_85849_();
        }
        super.m_7392_(entityIn, entityYaw, partialTicks, matrixStackIn, bufferIn, packedLightIn);
    }

    public void render(VertexConsumer vertexConsumer, Camera camera, NecroBolt projectile, float partialTicks, int packedLightIn, Matrix4f matrix4f, Matrix3f matrix3f, int mode) {
        Quaternionf quaternionf = new Quaternionf((Quaternionfc)camera.m_253121_());
        float f3 = Mth.m_14179_((float)partialTicks, (float)projectile.oRoll, (float)projectile.roll);
        float f4 = 0.5f;
        if (mode == 1) {
            f3 *= 0.5f;
            f4 *= projectile.getGlow;
        }
        quaternionf.rotateZ(f3);
        Vector3f[] avector3f = new Vector3f[]{new Vector3f(-1.0f, -1.0f, 0.0f), new Vector3f(-1.0f, 1.0f, 0.0f), new Vector3f(1.0f, 1.0f, 0.0f), new Vector3f(1.0f, -1.0f, 0.0f)};
        for (int i = 0; i < 4; ++i) {
            Vector3f vector3f = avector3f[i];
            vector3f.rotate((Quaternionfc)quaternionf);
            vector3f.mul(f4);
        }
        vertexConsumer.m_252986_(matrix4f, avector3f[0].x, avector3f[0].y, avector3f[0].z).m_6122_(255, 255, 255, 255).m_7421_(0.0f, 1.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLightIn).m_252939_(matrix3f, 0.0f, 1.0f, 0.0f).m_5752_();
        vertexConsumer.m_252986_(matrix4f, avector3f[1].x, avector3f[1].y, avector3f[1].z).m_6122_(255, 255, 255, 255).m_7421_(1.0f, 1.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLightIn).m_252939_(matrix3f, 0.0f, 1.0f, 0.0f).m_5752_();
        vertexConsumer.m_252986_(matrix4f, avector3f[2].x, avector3f[2].y, avector3f[2].z).m_6122_(255, 255, 255, 255).m_7421_(1.0f, 0.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLightIn).m_252939_(matrix3f, 0.0f, 1.0f, 0.0f).m_5752_();
        vertexConsumer.m_252986_(matrix4f, avector3f[3].x, avector3f[3].y, avector3f[3].z).m_6122_(255, 255, 255, 255).m_7421_(0.0f, 0.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLightIn).m_252939_(matrix3f, 0.0f, 1.0f, 0.0f).m_5752_();
    }

    private void renderTrail(NecroBolt entityIn, float partialTicks, PoseStack matrixStackIn, MultiBufferSource bufferIn, float red, float green, float blue, float alpha, int packedLightIn) {
        int sampleSize = 1;
        double trailHeight = 0.5;
        float trailZRot = 0.0f;
        Vec3 topAngleVec = new Vec3(0.0, trailHeight, 0.0).m_82535_(trailZRot);
        Vec3 bottomAngleVec = new Vec3(0.0, -trailHeight, 0.0).m_82535_(trailZRot);
        Vec3 drawFrom = entityIn.getTrailPosition(0, partialTicks);
        VertexConsumer vertexconsumer = bufferIn.m_6299_(RenderType.m_110473_((ResourceLocation)TRAIL));
        for (int samples = 0; samples < sampleSize; ++samples) {
            Vec3 sample = entityIn.getTrailPosition(samples + 8, partialTicks);
            Vec3 draw1 = drawFrom;
            PoseStack.Pose posestack$pose = matrixStackIn.m_85850_();
            Matrix4f matrix4f = posestack$pose.m_252922_();
            Matrix3f matrix3f = posestack$pose.m_252943_();
            float f2 = (float)(entityIn.f_19797_ % 8) / 8.0f;
            float f3 = f2 + 0.5f;
            vertexconsumer.m_252986_(matrix4f, (float)draw1.f_82479_ + (float)bottomAngleVec.f_82479_, (float)draw1.f_82480_ + (float)bottomAngleVec.f_82480_, (float)draw1.f_82481_ + (float)bottomAngleVec.f_82481_).m_85950_(red, green, blue, alpha).m_7421_(f2, 1.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLightIn).m_252939_(matrix3f, 0.0f, 1.0f, 0.0f).m_5752_();
            vertexconsumer.m_252986_(matrix4f, (float)sample.f_82479_ + (float)bottomAngleVec.f_82479_, (float)sample.f_82480_ + (float)bottomAngleVec.f_82480_, (float)sample.f_82481_ + (float)bottomAngleVec.f_82481_).m_85950_(red, green, blue, alpha).m_7421_(f3, 1.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLightIn).m_252939_(matrix3f, 0.0f, 1.0f, 0.0f).m_5752_();
            vertexconsumer.m_252986_(matrix4f, (float)sample.f_82479_ + (float)topAngleVec.f_82479_, (float)sample.f_82480_ + (float)topAngleVec.f_82480_, (float)sample.f_82481_ + (float)topAngleVec.f_82481_).m_85950_(red, green, blue, alpha).m_7421_(f3, 0.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLightIn).m_252939_(matrix3f, 0.0f, 1.0f, 0.0f).m_5752_();
            vertexconsumer.m_252986_(matrix4f, (float)draw1.f_82479_ + (float)topAngleVec.f_82479_, (float)draw1.f_82480_ + (float)topAngleVec.f_82480_, (float)draw1.f_82481_ + (float)topAngleVec.f_82481_).m_85950_(red, green, blue, alpha).m_7421_(f2, 0.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLightIn).m_252939_(matrix3f, 0.0f, 1.0f, 0.0f).m_5752_();
            drawFrom = sample;
        }
    }

    public ResourceLocation getTextureLocation(T entity) {
        return BASE;
    }
}

