/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.client.events;

import com.Polarice3.Goety.api.entities.IRM;
import com.Polarice3.Goety.common.entities.boss.Apostle;
import com.Polarice3.Goety.common.entities.boss.Vizier;
import com.Polarice3.Goety.config.MainConfig;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Mob;
import net.minecraftforge.client.event.CustomizeGuiOverlayEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class BossBarEvent {
    protected static final ResourceLocation TEXTURE = new ResourceLocation("goety", "textures/gui/boss_bar.png");
    protected static final ResourceLocation BOSS_BAR_1 = new ResourceLocation("goety", "textures/gui/boss_bar_1.png");
    protected static final ResourceLocation MINI_BOSS_BAR = new ResourceLocation("goety", "textures/gui/miniboss_bar.png");
    public static Map<UUID, Mob> BOSS_BARS = new HashMap<UUID, Mob>();

    @SubscribeEvent
    public static void renderBossBar(CustomizeGuiOverlayEvent.BossEventProgress event) {
        Minecraft minecraft = Minecraft.m_91087_();
        if (((Boolean)MainConfig.SpecialBossBar.get()).booleanValue()) {
            int i = minecraft.m_91268_().m_85445_();
            if (BOSS_BARS.containsKey(event.getBossEvent().m_18860_())) {
                Mob boss = BOSS_BARS.get(event.getBossEvent().m_18860_());
                event.setCanceled(true);
                int k = i / 2 - 100;
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                BossBarEvent.drawBar(event.getGuiGraphics(), k, event.getY(), event.getPartialTick(), boss);
                Component itextcomponent = boss.m_5446_();
                int l = minecraft.f_91062_.m_92852_((FormattedText)itextcomponent);
                int i1 = i / 2 - l / 2;
                event.getGuiGraphics().m_280430_(minecraft.f_91062_, itextcomponent, i1, event.getY() - 9, 0xFFFFFF);
                if (event.getY() >= minecraft.m_91268_().m_85446_() / 3) {
                    return;
                }
                Objects.requireNonNull(minecraft.f_91062_);
                event.setIncrement(12 + 9);
            }
        }
    }

    private static void drawBar(GuiGraphics guiGraphics, int pX, int pY, float partialTicks, Mob pEntity) {
        float percent = pEntity.m_21223_() / pEntity.m_21233_();
        int i = (int)(percent * 182.0f);
        int pX2 = pX + 9;
        int pY2 = pY + 4;
        int offset = (int)(((float)pEntity.f_19797_ + partialTicks) % 364.0f);
        if (percent <= 0.25f) {
            offset = (int)(((float)pEntity.f_19797_ + partialTicks) * 4.0f % 364.0f);
        } else if (percent <= 0.5f) {
            offset = (int)(((float)pEntity.f_19797_ + partialTicks) * 2.0f % 364.0f);
        }
        if (pEntity instanceof Apostle) {
            Apostle apostleEntity = (Apostle)pEntity;
            boolean flag = apostleEntity.isSecondPhase();
            int shake = 0;
            int damage = 36;
            if (i > 0) {
                guiGraphics.m_280163_(BOSS_BAR_1, pX2, pY2, (float)offset, 0.0f, i, 8, 364, 64);
                if (pEntity.f_20916_ >= 5) {
                    damage = 32 + pEntity.m_217043_().m_188503_(pEntity.f_20916_);
                    shake = pEntity.m_217043_().m_188503_(pEntity.f_20916_);
                    RenderSystem.setShaderTexture((int)0, (ResourceLocation)TEXTURE);
                    guiGraphics.m_280163_(TEXTURE, pX2, pY2, (float)shake, (float)damage, i, 8, 256, 256);
                }
                if (apostleEntity.isSmited()) {
                    float smite = 1.0f - (float)apostleEntity.getAntiRegen() / (float)apostleEntity.getAntiRegenTotal();
                    guiGraphics.m_280163_(BOSS_BAR_1, pX2, pY2, (float)offset, 16.0f, i, 8, 364, 64);
                    guiGraphics.m_280163_(BOSS_BAR_1, pX2, pY2, (float)offset, 0.0f, (int)(smite * (float)i), 8, 364, 64);
                }
            }
            guiGraphics.m_280163_(TEXTURE, pX, pY, 0.0f, flag ? 16.0f : 0.0f, 200, 16, 256, 256);
        } else if (pEntity instanceof Vizier) {
            int shake = 0;
            int damage = 100;
            if (i > 0) {
                guiGraphics.m_280163_(BOSS_BAR_1, pX2, pY2, (float)offset, 8.0f, i, 8, 364, 64);
                if (pEntity.f_20916_ >= 5) {
                    damage = 64 + pEntity.m_217043_().m_188503_(pEntity.f_20916_);
                    shake = pEntity.m_217043_().m_188503_(pEntity.f_20916_);
                    guiGraphics.m_280163_(TEXTURE, pX2, pY2, (float)shake, (float)damage, i, 8, 256, 256);
                }
            }
            guiGraphics.m_280163_(TEXTURE, pX, pY, 0.0f, 48.0f, 200, 16, 256, 256);
        } else if (pEntity instanceof IRM) {
            if (i > 0) {
                guiGraphics.m_280163_(BOSS_BAR_1, pX2, pY2, (float)offset, 24.0f, i, 8, 364, 64);
                if (pEntity.f_20916_ >= 5) {
                    int damage = 96 + pEntity.m_217043_().m_188503_(pEntity.f_20916_);
                    int shake = pEntity.m_217043_().m_188503_(pEntity.f_20916_);
                    guiGraphics.m_280163_(TEXTURE, pX2, pY2, (float)shake, (float)damage, i, 8, 256, 256);
                }
            }
            guiGraphics.m_280163_(TEXTURE, pX, pY, 0.0f, 80.0f, 200, 16, 256, 256);
        } else {
            BossBarEvent.drawMiniBossBar(guiGraphics, pX, pY, pEntity);
        }
    }

    private static void drawMiniBossBar(GuiGraphics guiGraphics, int pX, int pY, Mob pEntity) {
        float percent = pEntity.m_21223_() / pEntity.m_21233_();
        int i = (int)(percent * 128.0f);
        int j = Minecraft.m_91087_().m_91268_().m_85445_();
        int j1 = j / 2 - 62;
        if (i > 0) {
            if (pEntity.m_20147_() && !pEntity.m_20145_()) {
                guiGraphics.m_280163_(MINI_BOSS_BAR, j1, pY, 0.0f, 24.0f, i, 8, 128, 128);
            } else {
                guiGraphics.m_280163_(MINI_BOSS_BAR, j1, pY, 0.0f, 8.0f, i, 8, 128, 128);
            }
        }
        guiGraphics.m_280163_(MINI_BOSS_BAR, j1 - 11, pY, 0.0f, 16.0f, 9, 8, 128, 128);
        guiGraphics.m_280163_(MINI_BOSS_BAR, j1, pY, 0.0f, 0.0f, 128, 8, 128, 128);
    }

    public static void addBossBar(UUID id, Mob mob) {
        BOSS_BARS.put(id, mob);
    }

    public static void removeBossBar(UUID id, Mob mob) {
        BOSS_BARS.remove(id, mob);
    }
}

