/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.api.entities;

import com.Polarice3.Goety.api.blocks.entities.IBarrack;
import com.Polarice3.Goety.api.entities.IOwned;
import com.Polarice3.Goety.api.entities.ally.IServant;
import com.Polarice3.Goety.common.blocks.entities.OwnedBlockEntity;
import com.Polarice3.Goety.utils.MathHelper;
import com.Polarice3.Goety.utils.SEHelper;
import com.Polarice3.Goety.utils.ServerParticleUtil;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.ForgeEventFactory;

public interface ITrainable {
    default public int getTotalTrainTime() {
        return MathHelper.minutesToTicks(20);
    }

    default public int getTrainTime() {
        return 0;
    }

    default public void setTrainTime(int time) {
    }

    default public int getTrainCheck() {
        return 0;
    }

    default public void setTrainCheck(int check) {
    }

    default public boolean canTrain(Level level, BlockPos blockPos, EntityType<? extends Mob> entityType) {
        return true;
    }

    default public boolean isTraining() {
        return this.getTrainPos().isPresent();
    }

    default public Optional<BlockPos> getTrainPos() {
        return Optional.empty();
    }

    default public Optional<BlockPos> getStoredTrainPos() {
        return Optional.empty();
    }

    default public Vec3 vec3TrainPos() {
        if (this.getTrainPos().isPresent()) {
            return Vec3.m_82539_((Vec3i)((Vec3i)this.getTrainPos().get()));
        }
        return null;
    }

    default public void setTrainPos(@Nullable BlockPos blockPos) {
    }

    default public void setStoredTrainPos(@Nullable BlockPos blockPos) {
    }

    default public String getCurrentTrain() {
        return "None";
    }

    default public void setCurrentTrain(String train) {
    }

    default public void trainTick() {
        ITrainable iTrainable = this;
        if (iTrainable instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)iTrainable;
            if (livingEntity.m_6084_() && livingEntity.f_19797_ >= 100) {
                if (this.getTrainCheck() > 0) {
                    if (livingEntity.f_19797_ % 2 == 0) {
                        this.setTrainCheck(this.getTrainCheck() - 1);
                    }
                } else if (this.getTrainTime() > 0) {
                    if (livingEntity.f_19797_ % 2 == 0) {
                        this.setTrainTime(this.getTrainTime() - 1);
                    }
                    if (this.isTraining()) {
                        this.setTrainPos(null);
                    }
                }
            }
            if (livingEntity instanceof Mob) {
                Object owned2;
                Mob mob = (Mob)livingEntity;
                if (this.isTraining() && this.getTrainPos().isPresent()) {
                    int range = 8;
                    BlockEntity blockEntity = mob.f_19853_.m_7702_(this.getTrainPos().get());
                    if (blockEntity instanceof IBarrack) {
                        IBarrack barrack = (IBarrack)blockEntity;
                        range = barrack.getRange();
                    }
                    try {
                        if (this.vec3TrainPos() != null) {
                            if (mob.m_20238_(this.vec3TrainPos()) > (double)Mth.m_144944_((int)(range + 2))) {
                                blockEntity = mob.f_19853_;
                                if (blockEntity instanceof ServerLevel) {
                                    ServerLevel serverLevel = (ServerLevel)blockEntity;
                                    ServerParticleUtil.addParticlesAroundMiddleSelf(serverLevel, (ParticleOptions)ParticleTypes.f_123792_, (Entity)mob);
                                }
                                this.setTrainPos(null);
                            }
                            if (mob instanceof IServant && !(owned2 = (IServant)mob).isFollowing() && !owned2.isStaying() && !owned2.isCommanded() && mob.m_20238_(this.vec3TrainPos()) >= (double)Mth.m_144944_((int)range)) {
                                mob.m_6710_(null);
                                BlockPos blockPos = this.getTrainPos().get();
                                mob.m_21573_().m_26519_((double)blockPos.m_123341_(), (double)blockPos.m_123342_(), (double)blockPos.m_123343_(), 1.0);
                            }
                        }
                    }
                    catch (NullPointerException owned2) {
                        // empty catch block
                    }
                }
                if (this.getStoredTrainPos().isPresent()) {
                    owned2 = mob.f_19853_.m_7702_(this.getStoredTrainPos().get());
                    if (owned2 instanceof IBarrack) {
                        IBarrack barrack = (IBarrack)owned2;
                        if (barrack instanceof OwnedBlockEntity) {
                            OwnedBlockEntity ownedBlock = (OwnedBlockEntity)((Object)barrack);
                            if (mob instanceof IServant) {
                                IServant owned3 = (IServant)mob;
                                if (ownedBlock.getTrueOwner() != owned3.getTrueOwner()) {
                                    this.setStoredTrainPos(null);
                                }
                            }
                        }
                        if (this.getStoredTrainPos().isPresent()) {
                            if (!barrack.getTrainableList(mob.f_19853_, this.getStoredTrainPos().get()).contains(this)) {
                                if (barrack.checkEligibility(mob, mob.f_19853_, this.getStoredTrainPos().get())) {
                                    barrack.addTrainable(mob, mob.f_19853_, this.getStoredTrainPos().get());
                                }
                            } else if (mob.m_20238_(Vec3.m_82539_((Vec3i)((Vec3i)this.getStoredTrainPos().get()))) > (double)Mth.m_144944_((int)(barrack.getRange() + 2))) {
                                this.setStoredTrainPos(null);
                            }
                        }
                    } else {
                        this.setStoredTrainPos(null);
                    }
                }
            }
        }
    }

    default public int trainSpeed(EntityType<? extends Mob> entityType) {
        return 1;
    }

    default public void train(EntityType<? extends Mob> entityType) {
        if (Objects.equals(this.getCurrentTrain(), entityType.m_20675_())) {
            if (this.getTrainTime() < this.getTotalTrainTime()) {
                this.setTrainTime(this.getTrainTime() + this.trainSpeed(entityType));
            } else {
                this.completeTraining(entityType);
            }
        } else {
            this.setTrainTime(0);
            this.setCurrentTrain(entityType.m_20675_());
        }
        this.setTrainCheck(10);
    }

    default public boolean isTrained() {
        return false;
    }

    default public void completeTraining(EntityType<? extends Mob> entityType) {
        Mob converted;
        Mob mob;
        ITrainable iTrainable = this;
        if (iTrainable instanceof Mob && ForgeEventFactory.canLivingConvert((LivingEntity)(mob = (Mob)iTrainable), entityType, timer -> {}) && (converted = mob.m_21406_(entityType, true)) != null) {
            Object ownable1;
            if (mob instanceof IOwned) {
                IOwned ownable = (IOwned)mob;
                if (converted instanceof IOwned) {
                    ownable1 = (IOwned)converted;
                    if (ownable.getTrueOwner() != null) {
                        Player player;
                        ownable1.setTrueOwner(ownable.getTrueOwner());
                        LivingEntity livingEntity = ownable.getTrueOwner();
                        if (livingEntity instanceof Player && SEHelper.isGrounded(player = (Player)livingEntity, (LivingEntity)mob)) {
                            SEHelper.removeGroundedEntity(player, (LivingEntity)mob);
                            SEHelper.addGroundedEntity(player, (LivingEntity)converted);
                        }
                    }
                }
            }
            if ((ownable1 = mob.f_19853_) instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)ownable1;
                ForgeEventFactory.onFinalizeSpawn((Mob)converted, (ServerLevelAccessor)serverLevel, (DifficultyInstance)serverLevel.m_6436_(converted.m_20183_()), (MobSpawnType)MobSpawnType.CONVERSION, null, null);
            }
            if (mob instanceof IServant) {
                IServant servant = (IServant)mob;
                if (converted instanceof IServant) {
                    IServant servant1 = (IServant)converted;
                    if (servant.isWandering() && !servant.isStaying() && !servant.isGuardingArea() && servant1.canWander()) {
                        servant1.setBoundPos(null);
                        servant1.setWandering(true);
                        servant1.setStaying(false);
                    } else if (servant.isStaying() && !servant.isGuardingArea() && servant1.canStay()) {
                        servant1.setBoundPos(null);
                        servant1.setWandering(false);
                        servant1.setStaying(true);
                    } else if (servant.isGuardingArea() && servant1.canGuardArea()) {
                        servant1.setBoundPos(servant.getBoundPos());
                        servant1.setWandering(false);
                        servant1.setStaying(false);
                    } else {
                        servant1.setBoundPos(null);
                        servant1.setWandering(false);
                        servant1.setStaying(false);
                    }
                }
            }
            converted.m_8032_();
            ForgeEventFactory.onLivingConvert((LivingEntity)mob, (LivingEntity)converted);
        }
    }

    default public void readTrainableData(CompoundTag compound) {
        if (compound.m_128441_("TrainTime")) {
            this.setTrainTime(compound.m_128451_("TrainTime"));
        }
        if (compound.m_128441_("TrainPos")) {
            this.setTrainPos(NbtUtils.m_129239_((CompoundTag)compound.m_128469_("TrainPos")));
        }
        if (compound.m_128441_("StoredTrainPos")) {
            this.setStoredTrainPos(NbtUtils.m_129239_((CompoundTag)compound.m_128469_("StoredTrainPos")));
        }
        if (compound.m_128441_("CurrentTrain")) {
            this.setCurrentTrain(compound.m_128461_("CurrentTrain"));
        }
    }

    default public void saveTrainableData(CompoundTag compound) {
        compound.m_128405_("TrainTime", this.getTrainTime());
        if (this.getTrainPos().isPresent()) {
            compound.m_128365_("TrainPos", (Tag)NbtUtils.m_129224_((BlockPos)this.getTrainPos().get()));
        }
        if (this.getStoredTrainPos().isPresent()) {
            compound.m_128365_("StoredTrainPos", (Tag)NbtUtils.m_129224_((BlockPos)this.getStoredTrainPos().get()));
        }
        compound.m_128359_("CurrentTrain", this.getCurrentTrain());
    }
}

