/*
 * Decompiled with CFR 0.152.
 */
package com.chaosthedude.explorerscompass.client;

import com.chaosthedude.explorerscompass.ExplorersCompass;
import com.chaosthedude.explorerscompass.config.ConfigHandler;
import com.chaosthedude.explorerscompass.connect.NewWayPoint;
import com.chaosthedude.explorerscompass.items.ExplorersCompassItem;
import com.chaosthedude.explorerscompass.util.CompassState;
import com.chaosthedude.explorerscompass.util.ItemUtils;
import com.chaosthedude.explorerscompass.util.RenderUtils;
import com.chaosthedude.explorerscompass.util.StructureUtils;
import com.mojang.datafixers.util.Pair;
import java.util.HashMap;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.ChatScreen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.RenderGuiOverlayEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;

@OnlyIn(value=Dist.CLIENT)
public class ClientEventHandler {
    private static final Minecraft mc = Minecraft.m_91087_();
    private static CompassState state = CompassState.INACTIVE;
    public static int isFound = 0;
    public static HashMap<Integer, Pair<String, String>> HaveFound = new HashMap();

    @SubscribeEvent
    public void onPlayerLoggedOut(PlayerEvent.PlayerLoggedOutEvent event) {
        HaveFound.clear();
        isFound = 0;
    }

    @SubscribeEvent
    public void onTick(TickEvent.PlayerTickEvent event) {
        Player player;
        ItemStack itemStack;
        if (ClientEventHandler.mc.f_91073_ != null && !ClientEventHandler.mc.f_91066_.f_92062_ && !ClientEventHandler.mc.f_91066_.f_92063_ && (ClientEventHandler.mc.f_91080_ == null || ((Boolean)ConfigHandler.CLIENT.displayWithChatOpen.get()).booleanValue() && ClientEventHandler.mc.f_91080_ instanceof ChatScreen) && (itemStack = ItemUtils.getHeldItem(player = event.player, ExplorersCompass.explorersCompass)) != null && itemStack.m_41720_() instanceof ExplorersCompassItem) {
            ExplorersCompassItem compass = (ExplorersCompassItem)itemStack.m_41720_();
            CompassState nowState = compass.getState(itemStack);
            if (nowState != state && nowState.equals((Object)CompassState.FOUND)) {
                HaveFound.put(isFound, (Pair<String, String>)new Pair((Object)StructureUtils.getPrettyStructureName(compass.getStructureKey(itemStack)), (Object)(compass.getFoundStructureX(itemStack) + ", " + compass.getFoundStructureZ(itemStack))));
                ++isFound;
                if (ModList.get().isLoaded("xaerominimap") && ((Boolean)ConfigHandler.CLIENT.newWayPoint.get()).booleanValue()) {
                    NewWayPoint.addPoint(compass.getFoundStructureX(itemStack), compass.getFoundStructureZ(itemStack), player, StructureUtils.getPrettyStructureName(compass.getStructureKey(itemStack)), player.m_9236_());
                }
            }
            state = nowState;
        }
    }

    @SubscribeEvent
    public void onRenderTick(RenderGuiOverlayEvent.Post event) {
        LocalPlayer player;
        ItemStack stack;
        if (ClientEventHandler.mc.f_91074_ != null && ClientEventHandler.mc.f_91073_ != null && !ClientEventHandler.mc.f_91066_.f_92062_ && !ClientEventHandler.mc.f_91066_.f_92063_ && (ClientEventHandler.mc.f_91080_ == null || ((Boolean)ConfigHandler.CLIENT.displayWithChatOpen.get()).booleanValue() && ClientEventHandler.mc.f_91080_ instanceof ChatScreen) && (stack = ItemUtils.getHeldItem((Player)(player = ClientEventHandler.mc.f_91074_), ExplorersCompass.explorersCompass)) != null && stack.m_41720_() instanceof ExplorersCompassItem) {
            ExplorersCompassItem compass = (ExplorersCompassItem)stack.m_41720_();
            if (compass.getState(stack) == CompassState.SEARCHING) {
                RenderUtils.drawConfiguredStringOnHUD(event.getGuiGraphics(), I18n.m_118938_((String)"string.explorerscompass.status", (Object[])new Object[0]), 5, 5, 0xFFFFFF, 0);
                RenderUtils.drawConfiguredStringOnHUD(event.getGuiGraphics(), I18n.m_118938_((String)"string.explorerscompass.searching", (Object[])new Object[0]), 5, 5, 0xAAAAAA, 1);
                RenderUtils.drawConfiguredStringOnHUD(event.getGuiGraphics(), I18n.m_118938_((String)"string.explorerscompass.structure", (Object[])new Object[0]), 5, 5, 0xFFFFFF, 3);
                RenderUtils.drawConfiguredStringOnHUD(event.getGuiGraphics(), StructureUtils.getPrettyStructureName(compass.getStructureKey(stack)), 5, 5, 0xAAAAAA, 4);
                RenderUtils.drawConfiguredStringOnHUD(event.getGuiGraphics(), I18n.m_118938_((String)"string.explorerscompass.radius", (Object[])new Object[0]), 5, 5, 0xFFFFFF, 6);
                RenderUtils.drawConfiguredStringOnHUD(event.getGuiGraphics(), String.valueOf(compass.getSearchRadius(stack)), 5, 5, 0xAAAAAA, 7);
            } else if (compass.getState(stack) == CompassState.FOUND) {
                RenderUtils.drawConfiguredStringOnHUD(event.getGuiGraphics(), I18n.m_118938_((String)"string.explorerscompass.status", (Object[])new Object[0]), 5, 5, 0xFFFFFF, 0);
                RenderUtils.drawConfiguredStringOnHUD(event.getGuiGraphics(), I18n.m_118938_((String)"string.explorerscompass.found", (Object[])new Object[0]), 5, 5, 0xAAAAAA, 1);
                RenderUtils.drawConfiguredStringOnHUD(event.getGuiGraphics(), I18n.m_118938_((String)"string.explorerscompass.structure", (Object[])new Object[0]), 5, 5, 0xFFFFFF, 3);
                RenderUtils.drawConfiguredStringOnHUD(event.getGuiGraphics(), StructureUtils.getPrettyStructureName(compass.getStructureKey(stack)), 5, 5, 0xAAAAAA, 4);
                if (compass.shouldDisplayCoordinates(stack)) {
                    RenderUtils.drawConfiguredStringOnHUD(event.getGuiGraphics(), I18n.m_118938_((String)"string.explorerscompass.coordinates", (Object[])new Object[0]), 5, 5, 0xFFFFFF, 6);
                    RenderUtils.drawConfiguredStringOnHUD(event.getGuiGraphics(), compass.getFoundStructureX(stack) + ", " + compass.getFoundStructureZ(stack), 5, 5, 0xAAAAAA, 7);
                    RenderUtils.drawConfiguredStringOnHUD(event.getGuiGraphics(), I18n.m_118938_((String)"string.explorerscompass.distance", (Object[])new Object[0]), 5, 5, 0xFFFFFF, 9);
                    RenderUtils.drawConfiguredStringOnHUD(event.getGuiGraphics(), String.valueOf(StructureUtils.getHorizontalDistanceToLocation((Player)player, compass.getFoundStructureX(stack), compass.getFoundStructureZ(stack))), 5, 5, 0xAAAAAA, 10);
                }
            } else if (compass.getState(stack) == CompassState.NOT_FOUND) {
                RenderUtils.drawConfiguredStringOnHUD(event.getGuiGraphics(), I18n.m_118938_((String)"string.explorerscompass.status", (Object[])new Object[0]), 5, 5, 0xFFFFFF, 0);
                RenderUtils.drawConfiguredStringOnHUD(event.getGuiGraphics(), I18n.m_118938_((String)"string.explorerscompass.notFound", (Object[])new Object[0]), 5, 5, 0xAAAAAA, 1);
                RenderUtils.drawConfiguredStringOnHUD(event.getGuiGraphics(), I18n.m_118938_((String)"string.explorerscompass.structure", (Object[])new Object[0]), 5, 5, 0xFFFFFF, 3);
                RenderUtils.drawConfiguredStringOnHUD(event.getGuiGraphics(), StructureUtils.getPrettyStructureName(compass.getStructureKey(stack)), 5, 5, 0xAAAAAA, 4);
                RenderUtils.drawConfiguredStringOnHUD(event.getGuiGraphics(), I18n.m_118938_((String)"string.explorerscompass.radius", (Object[])new Object[0]), 5, 5, 0xFFFFFF, 6);
                RenderUtils.drawConfiguredStringOnHUD(event.getGuiGraphics(), String.valueOf(compass.getSearchRadius(stack)), 5, 5, 0xAAAAAA, 7);
            }
            if (((Boolean)ConfigHandler.CLIENT.showHaveFound.get()).booleanValue()) {
                if (isFound == 2 && !HaveFound.isEmpty() && HaveFound.get(0) != null) {
                    RenderUtils.drawConfiguredStringOnHUD(event.getGuiGraphics(), I18n.m_118938_((String)"string.explorerscompass.have_searched", (Object[])new Object[0]), 64, 5, 0xFFFFFF, 0);
                    RenderUtils.drawConfiguredStringOnHUD(event.getGuiGraphics(), I18n.m_118938_((String)((String)HaveFound.get(isFound - 2).getFirst()), (Object[])new Object[0]), 64, 5, 0xAAAAAA, 1);
                    RenderUtils.drawConfiguredStringOnHUD(event.getGuiGraphics(), (String)HaveFound.get(isFound - 2).getSecond(), 64, 5, 0xAAAAAA, 2);
                } else if (isFound >= 3 && !HaveFound.isEmpty() && HaveFound.get(isFound - 2) != null && HaveFound.get(isFound - 3) != null) {
                    RenderUtils.drawConfiguredStringOnHUD(event.getGuiGraphics(), I18n.m_118938_((String)"string.explorerscompass.have_searched", (Object[])new Object[0]), 64, 5, 0xFFFFFF, 0);
                    RenderUtils.drawConfiguredStringOnHUD(event.getGuiGraphics(), I18n.m_118938_((String)((String)HaveFound.get(isFound - 2).getFirst()), (Object[])new Object[0]), 64, 5, 0xAAAAAA, 1);
                    RenderUtils.drawConfiguredStringOnHUD(event.getGuiGraphics(), (String)HaveFound.get(isFound - 2).getSecond(), 64, 5, 0xAAAAAA, 2);
                    RenderUtils.drawConfiguredStringOnHUD(event.getGuiGraphics(), I18n.m_118938_((String)((String)HaveFound.get(isFound - 3).getFirst()), (Object[])new Object[0]), 64, 5, 0xAAAAAA, 4);
                    RenderUtils.drawConfiguredStringOnHUD(event.getGuiGraphics(), (String)HaveFound.get(isFound - 3).getSecond(), 64, 5, 0xAAAAAA, 5);
                }
            }
        }
    }
}

