/*
 * Decompiled with CFR 0.152.
 */
package com.aetherteam.aether.recipe.recipes.item;

import com.aetherteam.aether.block.AetherBlocks;
import com.aetherteam.aether.recipe.AetherRecipeSerializers;
import com.aetherteam.aether.recipe.AetherRecipeTypes;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import javax.annotation.Nullable;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.Container;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.crafting.CraftingHelper;

public class IncubationRecipe
implements Recipe<Container> {
    protected final RecipeType<?> type = (RecipeType)AetherRecipeTypes.INCUBATION.get();
    protected final ResourceLocation id;
    protected final String group;
    protected final Ingredient ingredient;
    protected final EntityType<?> entity;
    protected final CompoundTag tag;
    protected final int incubationTime;

    public IncubationRecipe(ResourceLocation id, String group, Ingredient ingredient, EntityType<?> entity, CompoundTag tag, int incubationTime) {
        this.id = id;
        this.group = group;
        this.ingredient = ingredient;
        this.entity = entity;
        this.tag = tag;
        this.incubationTime = incubationTime;
    }

    public boolean m_5818_(Container menu, Level level) {
        return this.ingredient.test(menu.m_8020_(0));
    }

    public ItemStack m_5874_(Container menu, RegistryAccess registryAccess) {
        return ItemStack.f_41583_;
    }

    public ItemStack m_8043_(RegistryAccess registryAccess) {
        return this.ingredient.m_43908_()[0];
    }

    public boolean m_8004_(int width, int height) {
        return true;
    }

    public int getIncubationTime() {
        return this.incubationTime;
    }

    public EntityType<?> getEntity() {
        return this.entity;
    }

    public CompoundTag getTag() {
        return this.tag;
    }

    public NonNullList<Ingredient> m_7527_() {
        NonNullList nonNullList = NonNullList.m_122779_();
        nonNullList.add((Object)this.ingredient);
        return nonNullList;
    }

    public String m_6076_() {
        return this.group;
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }

    public ItemStack m_8042_() {
        return new ItemStack((ItemLike)AetherBlocks.INCUBATOR.get());
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)AetherRecipeSerializers.INCUBATION.get();
    }

    public RecipeType<?> m_6671_() {
        return this.type;
    }

    public static class Serializer
    implements RecipeSerializer<IncubationRecipe> {
        public IncubationRecipe fromJson(ResourceLocation recipeLocation, JsonObject jsonObject) {
            String group = GsonHelper.m_13851_((JsonObject)jsonObject, (String)"group", (String)"");
            Ingredient ingredient = Ingredient.m_43917_((JsonElement)GsonHelper.m_13930_((JsonObject)jsonObject, (String)"ingredient"));
            EntityType entityType = (EntityType)EntityType.m_20632_((String)GsonHelper.m_13906_((JsonObject)jsonObject, (String)"entity")).orElseThrow(() -> new JsonSyntaxException("Entity type cannot be found"));
            CompoundTag tag = null;
            if (jsonObject.has("tag")) {
                tag = CraftingHelper.getNBT((JsonElement)jsonObject.get("tag"));
            }
            int incubationTime = GsonHelper.m_13824_((JsonObject)jsonObject, (String)"incubationtime", (int)2500);
            return new IncubationRecipe(recipeLocation, group, ingredient, entityType, tag, incubationTime);
        }

        @Nullable
        public IncubationRecipe fromNetwork(ResourceLocation recipeLocation, FriendlyByteBuf buffer) {
            String group = buffer.m_130277_();
            Ingredient ingredient = Ingredient.m_43940_((FriendlyByteBuf)buffer);
            EntityType entityType = (EntityType)EntityType.m_20632_((String)buffer.m_130277_()).orElseThrow(() -> new JsonSyntaxException("Entity type cannot be found"));
            CompoundTag tag = null;
            if (buffer.readBoolean()) {
                tag = buffer.m_130260_();
            }
            int incubationTime = buffer.m_130242_();
            return new IncubationRecipe(recipeLocation, group, ingredient, entityType, tag, incubationTime);
        }

        public void toNetwork(FriendlyByteBuf buffer, IncubationRecipe recipe) {
            buffer.m_130070_(recipe.group);
            recipe.ingredient.m_43923_(buffer);
            buffer.m_130070_(EntityType.m_20613_(recipe.getEntity()).toString());
            if (recipe.tag != null) {
                buffer.writeBoolean(true);
                buffer.m_130079_(recipe.tag);
            } else {
                buffer.writeBoolean(false);
            }
            buffer.m_130130_(recipe.getIncubationTime());
        }
    }
}

