/*
 * Decompiled with CFR 0.152.
 */
package com.aetherteam.aether.recipe.builder;

import com.aetherteam.aether.recipe.recipes.item.AltarRepairRecipe;
import com.google.gson.JsonObject;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementRewards;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.RequirementsStrategy;
import net.minecraft.advancements.critereon.RecipeUnlockedTrigger;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.data.recipes.RecipeBuilder;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;

public class AltarRepairBuilder
implements RecipeBuilder {
    private final RecipeCategory category;
    private final Ingredient ingredient;
    private final int repairTime;
    private final Advancement.Builder advancement = Advancement.Builder.m_138353_();
    @Nullable
    private String group;
    private final RecipeSerializer<AltarRepairRecipe> serializer;

    private AltarRepairBuilder(RecipeCategory category, Ingredient ingredient, int repairTime, RecipeSerializer<AltarRepairRecipe> serializer) {
        this.category = category;
        this.ingredient = ingredient;
        this.repairTime = repairTime;
        this.serializer = serializer;
    }

    public static AltarRepairBuilder repair(Ingredient item, RecipeCategory category, int repairTime, RecipeSerializer<AltarRepairRecipe> serializer) {
        return new AltarRepairBuilder(category, item, repairTime, serializer);
    }

    public RecipeBuilder m_126145_(@Nullable String group) {
        this.group = group;
        return this;
    }

    public Item m_142372_() {
        return this.ingredient.m_43908_()[0].m_41720_();
    }

    public AltarRepairBuilder unlockedBy(String criterionName, CriterionTriggerInstance criterionTrigger) {
        this.advancement.m_138386_(criterionName, criterionTrigger);
        return this;
    }

    public void m_126140_(Consumer<FinishedRecipe> finishedRecipeConsumer, ResourceLocation id) {
        this.ensureValid(id);
        this.advancement.m_138396_(new ResourceLocation("recipes/root")).m_138386_("has_the_recipe", (CriterionTriggerInstance)RecipeUnlockedTrigger.m_63728_((ResourceLocation)id)).m_138354_(AdvancementRewards.Builder.m_10009_((ResourceLocation)id)).m_138360_(RequirementsStrategy.f_15979_);
        finishedRecipeConsumer.accept(new Result(id, this.group == null ? "" : this.group, this.ingredient, this.repairTime, this.advancement, id.m_246208_("recipes/" + this.category.m_247710_() + "/"), this.serializer));
    }

    private void ensureValid(ResourceLocation id) {
        if (this.advancement.m_138405_().isEmpty()) {
            throw new IllegalStateException("No way of obtaining recipe " + id);
        }
    }

    public static class Result
    implements FinishedRecipe {
        private final ResourceLocation id;
        private final String group;
        private final Ingredient ingredient;
        private final int repairTime;
        private final Advancement.Builder advancement;
        private final ResourceLocation advancementId;
        private final RecipeSerializer<AltarRepairRecipe> serializer;

        public Result(ResourceLocation id, String group, Ingredient ingredient, int repairTime, Advancement.Builder advancement, ResourceLocation advancementId, RecipeSerializer<AltarRepairRecipe> serializer) {
            this.id = id;
            this.group = group;
            this.ingredient = ingredient;
            this.repairTime = repairTime;
            this.advancement = advancement;
            this.advancementId = advancementId;
            this.serializer = serializer;
        }

        public void m_7917_(JsonObject json) {
            if (!this.group.isEmpty()) {
                json.addProperty("group", this.group);
            }
            json.add("ingredient", this.ingredient.m_43942_());
            json.addProperty("repairTime", (Number)this.repairTime);
        }

        public RecipeSerializer<?> m_6637_() {
            return this.serializer;
        }

        public ResourceLocation m_6445_() {
            return this.id;
        }

        @Nullable
        public JsonObject m_5860_() {
            return this.advancement.m_138400_();
        }

        @Nullable
        public ResourceLocation m_6448_() {
            return this.advancementId;
        }
    }
}

