/*
 * Decompiled with CFR 0.152.
 */
package com.aetherteam.aether.client.gui.screen;

import com.aetherteam.aether.client.gui.component.dialogue.DialogueAnswerComponent;
import com.aetherteam.aether.client.gui.component.dialogue.DialogueChoiceComponent;
import com.aetherteam.aether.entity.monster.dungeon.boss.ValkyrieQueen;
import com.aetherteam.aether.item.AetherItems;
import com.aetherteam.aether.network.AetherPacketHandler;
import com.aetherteam.aether.network.packet.serverbound.NpcPlayerInteractPacket;
import com.aetherteam.nitrogen.network.PacketRelay;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.Item;
import net.minecraftforge.client.event.ScreenEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.network.simple.SimpleChannel;

public class ValkyrieQueenDialogueScreen
extends Screen {
    private final DialogueAnswerComponent dialogueAnswer;
    private final ValkyrieQueen valkyrieQueen;

    public ValkyrieQueenDialogueScreen(ValkyrieQueen valkyrieQueen) {
        super(valkyrieQueen.getBossName());
        this.dialogueAnswer = new DialogueAnswerComponent((Component)this.buildDialogueAnswerName(valkyrieQueen.getBossName()));
        this.valkyrieQueen = valkyrieQueen;
    }

    protected void m_7856_() {
        if (this.getMinecraft().f_91074_ != null) {
            this.setupDialogueChoices(new DialogueChoiceComponent(this.buildDialogueChoice("question"), button -> this.finishChat((byte)0)), new DialogueChoiceComponent(this.buildDialogueChoice("challenge"), button -> {
                this.setDialogueAnswer((Component)Component.m_237115_((String)"gui.aether.queen.dialog.challenge"));
                int medals = this.getMinecraft().f_91074_.m_150109_().m_18947_((Item)AetherItems.VICTORY_MEDAL.get());
                DialogueChoiceComponent startFightChoice = medals >= 10 ? new DialogueChoiceComponent(this.buildDialogueChoice("have_medals"), button1 -> this.finishChat((byte)1)) : new DialogueChoiceComponent(this.buildDialogueChoice("no_medals").m_130946_(" (" + medals + "/10)"), button1 -> this.finishChat((byte)1));
                this.setupDialogueChoices(startFightChoice, new DialogueChoiceComponent(this.buildDialogueChoice("deny_fight"), button1 -> this.finishChat((byte)2)));
            }), new DialogueChoiceComponent(this.buildDialogueChoice("leave"), pButton -> this.finishChat((byte)3)));
            this.positionDialogue();
        }
    }

    public void setupDialogueChoices(DialogueChoiceComponent ... options) {
        this.m_169413_();
        for (DialogueChoiceComponent option : options) {
            this.m_142416_((GuiEventListener)option);
        }
        this.positionDialogue();
    }

    private void positionDialogue() {
        this.dialogueAnswer.reposition(this.f_96543_, this.f_96544_);
        int lineNumber = this.dialogueAnswer.height / 12 + 1;
        for (Renderable renderable : this.f_169369_) {
            if (!(renderable instanceof DialogueChoiceComponent)) continue;
            DialogueChoiceComponent option = (DialogueChoiceComponent)renderable;
            option.m_252865_(this.f_96543_ / 2 - option.m_5711_() / 2);
            option.m_253211_(this.f_96544_ / 2 + 12 * lineNumber);
            ++lineNumber;
        }
    }

    private void setDialogueAnswer(Component component) {
        this.dialogueAnswer.updateDialogue((Component)this.buildDialogueAnswerName(this.valkyrieQueen.getBossName()).m_130946_(": ").m_7220_(component));
    }

    public MutableComponent buildDialogueAnswerName(Component component) {
        return Component.m_237113_((String)"[").m_7220_((Component)component.m_6881_().m_130940_(ChatFormatting.YELLOW)).m_130946_("]");
    }

    public MutableComponent buildDialogueChoice(String key) {
        return Component.m_237115_((String)("gui.aether.player.dialog." + key));
    }

    private void finishChat(byte interactionID) {
        PacketRelay.sendToServer((SimpleChannel)AetherPacketHandler.INSTANCE, (Object)new NpcPlayerInteractPacket(this.valkyrieQueen.m_19879_(), interactionID));
        super.m_7379_();
    }

    public void m_88315_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        this.m_280273_(guiGraphics);
        this.dialogueAnswer.render(guiGraphics);
        super.m_88315_(guiGraphics, mouseX, mouseY, partialTicks);
    }

    public void m_280273_(GuiGraphics guiGraphics) {
        if (this.getMinecraft().f_91073_ != null) {
            MinecraftForge.EVENT_BUS.post((Event)new ScreenEvent.BackgroundRendered((Screen)this, guiGraphics));
        }
    }

    public void m_6574_(Minecraft minecraft, int width, int height) {
        this.f_96543_ = width;
        this.f_96544_ = height;
        this.positionDialogue();
    }

    public boolean m_7043_() {
        return false;
    }

    public void m_7379_() {
        this.finishChat((byte)3);
    }
}

