/*
 * Decompiled with CFR 0.152.
 */
package com.aetherteam.aether.client.event.listeners;

import com.aetherteam.aether.client.event.hooks.MenuHooks;
import com.aetherteam.cumulus.client.CumulusClient;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.TitleScreen;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.ScreenEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="aether", value={Dist.CLIENT})
public class MenuListener {
    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onGuiOpenHighest(ScreenEvent.Opening event) {
        MenuHooks.prepareCustomMenus(CumulusClient.MENU_HELPER);
    }

    @SubscribeEvent
    public static void onGuiInitialize(ScreenEvent.Init.Post event) {
        Screen screen = event.getScreen();
        if (screen instanceof TitleScreen) {
            Button quickLoadButton;
            Button menuSwitchButton;
            TitleScreen titleScreen = (TitleScreen)screen;
            MenuHooks.setCustomSplashText(titleScreen);
            Button toggleWorldButton = MenuHooks.setupToggleWorldButton(screen);
            if (toggleWorldButton != null) {
                event.addListener((GuiEventListener)toggleWorldButton);
            }
            if ((menuSwitchButton = MenuHooks.setupMenuSwitchButton(screen)) != null) {
                event.addListener((GuiEventListener)menuSwitchButton);
            }
            if ((quickLoadButton = MenuHooks.setupQuickLoadButton(screen)) != null) {
                event.addListener((GuiEventListener)quickLoadButton);
            }
        }
    }
}

