/*
 * Decompiled with CFR 0.152.
 */
package me.towdium.pinin.utils;

import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import me.towdium.pinin.elements.Pinyin;

public abstract class PinyinFormat {
    private static final Set<String> OFFSET = Stream.of("ui", "iu", "uan", "uang", "ian", "iang", "ua", "ie", "uo", "iong", "iao", "ve", "ia").collect(Collectors.toSet());
    private static final Map<Character, Character> NONE = Stream.of({Character.valueOf('a'), Character.valueOf('a')}, {Character.valueOf('o'), Character.valueOf('o')}, {Character.valueOf('e'), Character.valueOf('e')}, {Character.valueOf('i'), Character.valueOf('i')}, {Character.valueOf('u'), Character.valueOf('u')}, {Character.valueOf('v'), Character.valueOf('\u00fc')}).collect(Collectors.toMap(d -> d[0], d -> d[1]));
    private static final Map<Character, Character> FIRST = Stream.of({Character.valueOf('a'), Character.valueOf('\u0101')}, {Character.valueOf('o'), Character.valueOf('\u014d')}, {Character.valueOf('e'), Character.valueOf('\u0113')}, {Character.valueOf('i'), Character.valueOf('\u012b')}, {Character.valueOf('u'), Character.valueOf('\u016b')}, {Character.valueOf('v'), Character.valueOf('\u01d6')}).collect(Collectors.toMap(d -> d[0], d -> d[1]));
    private static final Map<Character, Character> SECOND = Stream.of({Character.valueOf('a'), Character.valueOf('\u00e1')}, {Character.valueOf('o'), Character.valueOf('\u00f3')}, {Character.valueOf('e'), Character.valueOf('\u00e9')}, {Character.valueOf('i'), Character.valueOf('\u00ed')}, {Character.valueOf('u'), Character.valueOf('\u00fa')}, {Character.valueOf('v'), Character.valueOf('\u01d8')}).collect(Collectors.toMap(d -> d[0], d -> d[1]));
    private static final Map<Character, Character> THIRD = Stream.of({Character.valueOf('a'), Character.valueOf('\u01ce')}, {Character.valueOf('o'), Character.valueOf('\u01d2')}, {Character.valueOf('e'), Character.valueOf('\u011b')}, {Character.valueOf('i'), Character.valueOf('\u01d0')}, {Character.valueOf('u'), Character.valueOf('\u01d4')}, {Character.valueOf('v'), Character.valueOf('\u01da')}).collect(Collectors.toMap(d -> d[0], d -> d[1]));
    private static final Map<Character, Character> FOURTH = Stream.of({Character.valueOf('a'), Character.valueOf('\u00e0')}, {Character.valueOf('o'), Character.valueOf('\u00f2')}, {Character.valueOf('e'), Character.valueOf('\u00e8')}, {Character.valueOf('i'), Character.valueOf('\u00ec')}, {Character.valueOf('u'), Character.valueOf('\u00f9')}, {Character.valueOf('v'), Character.valueOf('\u01dc')}).collect(Collectors.toMap(d -> d[0], d -> d[1]));
    private static final List<Map<Character, Character>> TONES = Stream.of(NONE, FIRST, SECOND, THIRD, FOURTH).collect(Collectors.toList());
    private static final Map<String, String> SYMBOLS = Stream.of({"a", "\u311a"}, {"o", "\u311b"}, {"e", "\u311c"}, {"er", "\u3126"}, {"ai", "\u311e"}, {"ei", "\u311f"}, {"ao", "\u3120"}, {"ou", "\u3121"}, {"an", "\u3122"}, {"en", "\u3123"}, {"ang", "\u3124"}, {"eng", "\u3125"}, {"ong", "\u3128\u3125"}, {"i", "\u3127"}, {"ia", "\u3127\u311a"}, {"iao", "\u3127\u3120"}, {"ie", "\u3127\u311d"}, {"iu", "\u3127\u3121"}, {"ian", "\u3127\u3122"}, {"in", "\u3127\u3123"}, {"iang", "\u3127\u3124"}, {"ing", "\u3127\u3125"}, {"iong", "\u3129\u3125"}, {"u", "\u3128"}, {"ua", "\u3128\u311a"}, {"uo", "\u3128\u311b"}, {"uai", "\u3128\u311e"}, {"ui", "\u3128\u311f"}, {"uan", "\u3128\u3122"}, {"un", "\u3128\u3123"}, {"uang", "\u3128\u3124"}, {"ueng", "\u3128\u3125"}, {"uen", "\u3129\u3123"}, {"v", "\u3129"}, {"ve", "\u3129\u311d"}, {"van", "\u3129\u3122"}, {"vang", "\u3129\u3124"}, {"vn", "\u3129\u3123"}, {"b", "\u3105"}, {"p", "\u3106"}, {"m", "\u3107"}, {"f", "\u3108"}, {"d", "\u3109"}, {"t", "\u310a"}, {"n", "\u310b"}, {"l", "\u310c"}, {"g", "\u310d"}, {"k", "\u310e"}, {"h", "\u310f"}, {"j", "\u3110"}, {"q", "\u3111"}, {"x", "\u3112"}, {"zh", "\u3113"}, {"ch", "\u3114"}, {"sh", "\u3115"}, {"r", "\u3116"}, {"z", "\u3117"}, {"c", "\u3118"}, {"s", "\u3119"}, {"w", "\u3128"}, {"y", "\u3127"}, {"1", ""}, {"2", "\u02ca"}, {"3", "\u02c7"}, {"4", "\u02cb"}, {"0", "\u02d9"}, {"", ""}).collect(Collectors.toMap(d -> d[0], d -> d[1]));
    private static final Map<String, String> LOCAL = Stream.of({"yi", "i"}, {"you", "iu"}, {"yin", "in"}, {"ye", "ie"}, {"ying", "ing"}, {"wu", "u"}, {"wen", "un"}, {"yu", "v"}, {"yue", "ve"}, {"yuan", "van"}, {"yun", "vn"}, {"ju", "jv"}, {"jue", "jve"}, {"juan", "jvan"}, {"jun", "jvn"}, {"qu", "qv"}, {"que", "qve"}, {"quan", "qvan"}, {"qun", "qvn"}, {"xu", "xv"}, {"xue", "xve"}, {"xuan", "xvan"}, {"xun", "xvn"}, {"shi", "sh"}, {"si", "s"}, {"chi", "ch"}, {"ci", "c"}, {"zhi", "zh"}, {"zi", "z"}, {"ri", "r"}).collect(Collectors.toMap(d -> d[0], d -> d[1]));
    public static final PinyinFormat RAW = new PinyinFormat(){

        @Override
        public String format(Pinyin p) {
            return p.toString().substring(0, p.toString().length() - 1);
        }
    };
    public static final PinyinFormat NUMBER = new PinyinFormat(){

        @Override
        public String format(Pinyin p) {
            return p.toString();
        }
    };
    public static final PinyinFormat PHONETIC = new PinyinFormat(){

        @Override
        public String format(Pinyin p) {
            String[] split;
            String s = p.toString();
            String str = (String)LOCAL.get(s.substring(0, s.length() - 1));
            if (str != null) {
                s = str + s.charAt(s.length() - 1);
            }
            StringBuilder sb = new StringBuilder();
            int len = s.length();
            if (!Pinyin.hasInitial(s)) {
                split = new String[]{"", s.substring(0, len - 1), s.substring(len - 1)};
            } else {
                int i = s.length() > 2 && s.charAt(1) == 'h' ? 2 : 1;
                split = new String[]{s.substring(0, i), s.substring(i, len - 1), s.substring(len - 1)};
            }
            boolean weak = split[2].equals("0");
            if (weak) {
                sb.append((String)SYMBOLS.get(split[2]));
            }
            sb.append((String)SYMBOLS.get(split[0]));
            sb.append((String)SYMBOLS.get(split[1]));
            if (!weak) {
                sb.append((String)SYMBOLS.get(split[2]));
            }
            return sb.toString();
        }
    };
    public static final PinyinFormat UNICODE = new PinyinFormat(){

        @Override
        public String format(Pinyin p) {
            int offset;
            String finale;
            StringBuilder sb = new StringBuilder();
            String s = p.toString();
            int len = s.length();
            if (!Pinyin.hasInitial(s)) {
                finale = s.substring(0, len - 1);
            } else {
                int i = s.length() > 2 && s.charAt(1) == 'h' ? 2 : 1;
                sb.append(s, 0, i);
                finale = s.substring(i, len - 1);
            }
            int n = offset = OFFSET.contains(finale) ? 1 : 0;
            if (offset == 1) {
                sb.append(finale, 0, 1);
            }
            Map group = (Map)TONES.get(s.charAt(s.length() - 1) - 48);
            sb.append(group.get(Character.valueOf(finale.charAt(offset))));
            if (finale.length() > offset + 1) {
                sb.append(finale, offset + 1, finale.length());
            }
            return sb.toString();
        }
    };

    public abstract String format(Pinyin var1);
}

