/*
 * Decompiled with CFR 0.152.
 */
package com.min01.gambler.network;

import com.min01.gambler.entity.living.EntityGambler;
import io.redspace.ironsspellbooks.api.registry.SchoolRegistry;
import io.redspace.ironsspellbooks.api.spells.SchoolType;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.registries.IForgeRegistry;

public class GamblerSchoolSyncPacket {
    private final int entityID;
    private final ResourceLocation schoolId;

    public GamblerSchoolSyncPacket(Entity entity, SchoolType school) {
        this.entityID = entity.m_19879_();
        this.schoolId = school.getId();
    }

    public GamblerSchoolSyncPacket(FriendlyByteBuf buf) {
        this.entityID = buf.readInt();
        this.schoolId = buf.m_130281_();
    }

    public void encode(FriendlyByteBuf buf) {
        buf.writeInt(this.entityID);
        buf.m_130085_(this.schoolId);
    }

    public static class Handler {
        public static boolean onMessage(GamblerSchoolSyncPacket message, Supplier<NetworkEvent.Context> ctx) {
            ctx.get().enqueueWork(() -> {
                Minecraft mc = Minecraft.m_91087_();
                Entity entity = mc.f_91073_.m_6815_(message.entityID);
                if (entity instanceof EntityGambler) {
                    EntityGambler gambler = (EntityGambler)entity;
                    gambler.school = (SchoolType)((IForgeRegistry)SchoolRegistry.REGISTRY.get()).getValue(message.schoolId);
                }
            });
            ctx.get().setPacketHandled(true);
            return true;
        }
    }
}

