/*
 * Decompiled with CFR 0.152.
 */
package com.min01.gambler.entity.renderer;

import com.min01.gambler.entity.living.EntityGambler;
import com.min01.gambler.entity.model.DiceModel;
import com.min01.gambler.entity.model.GamblerModel;
import com.mojang.blaze3d.vertex.PoseStack;
import io.redspace.ironsspellbooks.api.registry.SchoolRegistry;
import io.redspace.ironsspellbooks.api.spells.SchoolType;
import io.redspace.ironsspellbooks.entity.mobs.abstract_spell_casting_mob.AbstractSpellCastingMob;
import io.redspace.ironsspellbooks.entity.mobs.abstract_spell_casting_mob.AbstractSpellCastingMobModel;
import io.redspace.ironsspellbooks.entity.mobs.abstract_spell_casting_mob.AbstractSpellCastingMobRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;

public class GamblerRenderer
extends AbstractSpellCastingMobRenderer {
    private final DiceModel diceModel;
    private static final ResourceLocation DICE_TEXTURE = new ResourceLocation("gambler", "textures/entity/dice.png");
    private static final ResourceLocation BLOOD_DICE_TEXTURE = new ResourceLocation("gambler", "textures/entity/dice_blood.png");
    private static final ResourceLocation ELDRITCH_DICE_TEXTURE = new ResourceLocation("gambler", "textures/entity/dice_eldritch.png");
    private static final ResourceLocation ENDER_DICE_TEXTURE = new ResourceLocation("gambler", "textures/entity/dice_ender.png");
    private static final ResourceLocation EVOCATION_DICE_TEXTURE = new ResourceLocation("gambler", "textures/entity/dice_evocation.png");
    private static final ResourceLocation FIRE_DICE_TEXTURE = new ResourceLocation("gambler", "textures/entity/dice_fire.png");
    private static final ResourceLocation HOLY_DICE_TEXTURE = new ResourceLocation("gambler", "textures/entity/dice_holy.png");
    private static final ResourceLocation ICE_DICE_TEXTURE = new ResourceLocation("gambler", "textures/entity/dice_ice.png");
    private static final ResourceLocation LIGHTNING_DICE_TEXTURE = new ResourceLocation("gambler", "textures/entity/dice_lightning.png");
    private static final ResourceLocation NATURE_DICE_TEXTURE = new ResourceLocation("gambler", "textures/entity/dice_nature.png");

    public GamblerRenderer(EntityRendererProvider.Context renderManager) {
        super(renderManager, (AbstractSpellCastingMobModel)new GamblerModel());
        this.diceModel = new DiceModel(renderManager.m_174023_(DiceModel.LAYER_LOCATION));
    }

    public void render(AbstractSpellCastingMob entity, float entityYaw, float partialTick, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight) {
        super.render(entity, entityYaw, partialTick, poseStack, bufferSource, packedLight);
        if (entity instanceof EntityGambler) {
            EntityGambler gambler = (EntityGambler)entity;
            poseStack.m_85836_();
            poseStack.m_85841_(-1.0f, -1.0f, 1.0f);
            poseStack.m_252880_(0.0f, -3.0f - entity.m_20192_(), 0.0f);
            this.diceModel.setupAnim(entity, 0.0f, 0.0f, (float)entity.f_19797_ + partialTick, 0.0f, 0.0f);
            this.diceModel.m_7695_(poseStack, bufferSource.m_6299_(RenderType.m_110458_((ResourceLocation)this.getDiceTexture(gambler.school))), packedLight, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
            poseStack.m_85849_();
        }
    }

    public ResourceLocation getDiceTexture(SchoolType school) {
        if (school == SchoolRegistry.ICE.get()) {
            return ICE_DICE_TEXTURE;
        }
        if (school == SchoolRegistry.FIRE.get()) {
            return FIRE_DICE_TEXTURE;
        }
        if (school == SchoolRegistry.HOLY.get()) {
            return HOLY_DICE_TEXTURE;
        }
        if (school == SchoolRegistry.EVOCATION.get()) {
            return EVOCATION_DICE_TEXTURE;
        }
        if (school == SchoolRegistry.BLOOD.get()) {
            return BLOOD_DICE_TEXTURE;
        }
        if (school == SchoolRegistry.NATURE.get()) {
            return NATURE_DICE_TEXTURE;
        }
        if (school == SchoolRegistry.ENDER.get()) {
            return ENDER_DICE_TEXTURE;
        }
        if (school == SchoolRegistry.LIGHTNING.get()) {
            return LIGHTNING_DICE_TEXTURE;
        }
        if (school == SchoolRegistry.ELDRITCH.get()) {
            return ELDRITCH_DICE_TEXTURE;
        }
        return DICE_TEXTURE;
    }
}

