/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.customization.placeholder.placeholders.advanced;

import de.keksuccino.fancymenu.customization.placeholder.DeserializedPlaceholderString;
import de.keksuccino.fancymenu.customization.placeholder.Placeholder;
import de.keksuccino.fancymenu.util.LocalizationUtils;
import de.keksuccino.konkrete.math.MathUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import net.minecraft.client.resources.language.I18n;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RandomNumberPlaceholder
extends Placeholder {
    public RandomNumberPlaceholder() {
        super("random_number");
    }

    @Override
    public String getReplacementFor(DeserializedPlaceholderString dps) {
        String min = dps.values.get("min");
        String max = dps.values.get("max");
        if (min != null && max != null && MathUtils.isInteger((String)min) && MathUtils.isInteger((String)max)) {
            int maxInt;
            int minInt = Integer.parseInt(min);
            if (minInt == (maxInt = Integer.parseInt(max))) {
                return "" + minInt;
            }
            return "" + MathUtils.getRandomNumberInRange((int)Math.min(minInt, maxInt), (int)Math.max(minInt, maxInt));
        }
        return null;
    }

    @Override
    @Nullable
    public List<String> getValueNames() {
        ArrayList<String> l = new ArrayList<String>();
        l.add("min");
        l.add("max");
        return l;
    }

    @Override
    @NotNull
    public String getDisplayName() {
        return I18n.m_118938_((String)"fancymenu.helper.placeholder.random_number", (Object[])new Object[0]);
    }

    @Override
    public List<String> getDescription() {
        return Arrays.asList(LocalizationUtils.splitLocalizedStringLines("fancymenu.helper.placeholder.random_number.desc", new String[0]));
    }

    @Override
    public String getCategory() {
        return I18n.m_118938_((String)"fancymenu.fancymenu.editor.dynamicvariabletextfield.categories.advanced", (Object[])new Object[0]);
    }

    @Override
    @NotNull
    public DeserializedPlaceholderString getDefaultPlaceholderString() {
        HashMap<String, String> m = new HashMap<String, String>();
        m.put("min", "1");
        m.put("max", "30");
        return DeserializedPlaceholderString.build(this.getIdentifier(), m);
    }
}

